/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.scheme;

import java.lang.ref.SoftReference;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ASDC;
import org.apache.sysds.runtime.compress.colgroup.ASDCZero;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.compress.colgroup.scheme.SDCScheme;
import org.apache.sysds.runtime.compress.utils.DoubleCountHashMap;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.compress.utils.Util;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.Pair;

public class SDCSchemeSC
extends SDCScheme {
    final double def;
    private final DoubleCountHashMap map;
    private static SoftReference<ThreadLocal<Pair<IntArrayList, IntArrayList>>> cachedArrays;

    public SDCSchemeSC(IColIndex cols, DoubleCountHashMap map, double def) {
        super(cols);
        this.map = map;
        this.def = def;
    }

    protected SDCSchemeSC(ASDC g) {
        this(g.getColIndices(), g.getCommon()[0], g.getDictionary());
    }

    protected SDCSchemeSC(ASDCZero g) {
        this(g.getColIndices(), 0.0, g.getDictionary());
    }

    private SDCSchemeSC(IColIndex cols, double def, IDictionary lastDict) {
        super(cols);
        this.def = def;
        this.lastDict = lastDict;
        int unique = lastDict.getNumberOfValues(1);
        this.map = new DoubleCountHashMap(unique);
        for (int i = 0; i < unique; ++i) {
            this.map.increment(lastDict.getValue(i));
        }
    }

    @Override
    protected Object getDef() {
        return this.def;
    }

    @Override
    protected Object getMap() {
        return this.map;
    }

    @Override
    protected AColGroup encodeV(MatrixBlock data, IColIndex columns) {
        if (data.isEmpty()) {
            return new ColGroupEmpty(columns);
        }
        int nRow = data.getNumRows();
        IntArrayList offs = new IntArrayList();
        AMapToData d = this.encode(data, offs, this.cols.get(0));
        return this.finalizeEncode(data, offs, d, columns, nRow);
    }

    private AColGroup finalizeEncode(MatrixBlock data, IntArrayList offs, AMapToData d, IColIndex columns, int nRow) {
        this.allocateDictionary();
        if (offs.size() == 0) {
            return ColGroupConst.create(columns, this.def);
        }
        AOffset off = OffsetFactory.createOffset(offs);
        return ColGroupSDC.create(columns, nRow, this.lastDict, new double[]{this.def}, off, d, null);
    }

    private void allocateDictionary() {
        if (this.lastDict == null || this.lastDict.getNumberOfValues(this.cols.size()) != this.map.size()) {
            this.lastDict = DictionaryFactory.create(this.map);
        }
    }

    private AMapToData encode(MatrixBlock data, IntArrayList off, int col) {
        if (data.isInSparseFormat()) {
            return this.encodeSparse(data, off, col);
        }
        if (data.getDenseBlock().isContiguous()) {
            return this.encodeDense(data, off, col);
        }
        return this.encodeGeneric(data, off, col);
    }

    private AMapToData encodeSparse(MatrixBlock data, IntArrayList off, int col) {
        int nRow = data.getNumRows();
        SparseBlock sb = data.getSparseBlock();
        for (int i = 0; i < nRow; ++i) {
            if (Util.eq(sb.get(i, col), this.def)) continue;
            off.appendValue(i);
        }
        AMapToData d = MapToFactory.create(off.size(), this.map.size());
        for (int i = 0; i < off.size(); ++i) {
            int r = off.get(i);
            d.set(i, this.map.getId(sb.get(r, col)));
        }
        return d;
    }

    private AMapToData encodeDense(MatrixBlock data, IntArrayList off, int col) {
        int nRow = data.getNumRows();
        double[] vals = data.getDenseBlockValues();
        int nCol = data.getNumColumns();
        int max = nRow * nCol;
        int i = 0;
        for (int o = col; o < max; o += nCol) {
            if (!Util.eq(vals[o], this.def)) {
                off.appendValue(i);
            }
            ++i;
        }
        AMapToData d = MapToFactory.create(off.size(), this.map.size());
        for (int i2 = 0; i2 < off.size(); ++i2) {
            int o = off.get(i2) * nCol + col;
            d.set(i2, this.map.getId(vals[o]));
        }
        return d;
    }

    private AMapToData encodeGeneric(MatrixBlock data, IntArrayList off, int col) {
        int nRow = data.getNumRows();
        DenseBlock db = data.getDenseBlock();
        for (int i = 0; i < nRow; ++i) {
            int o;
            double[] c = db.values(i);
            if (Util.eq(c[o = db.pos(i) + col], this.def)) continue;
            off.appendValue(i);
        }
        AMapToData d = MapToFactory.create(off.size(), this.map.size());
        for (int i = 0; i < off.size(); ++i) {
            int of = off.get(i);
            int o = db.pos(of) + col;
            d.set(i, this.map.getId(db.values(of)[o]));
        }
        return d;
    }

    @Override
    protected ICLAScheme updateV(MatrixBlock data, IColIndex columns) {
        int col = columns.get(0);
        if (data.isEmpty()) {
            if (this.def != 0.0) {
                this.map.increment(0.0, data.getNumRows());
            }
        } else if (data.isInSparseFormat()) {
            this.updateSparse(data, col);
        } else if (data.getDenseBlock().isContiguous()) {
            this.updateDense(data, col);
        } else {
            this.updateGeneric(data, col);
        }
        return this;
    }

    private void updateSparse(MatrixBlock data, int col) {
        int nRow = data.getNumRows();
        SparseBlock sb = data.getSparseBlock();
        for (int i = 0; i < nRow; ++i) {
            double v = sb.get(i, col);
            if (Util.eq(v, this.def)) continue;
            this.map.increment(v);
        }
    }

    private void updateDense(MatrixBlock data, int col) {
        int nRow = data.getNumRows();
        double[] vals = data.getDenseBlockValues();
        int nCol = data.getNumColumns();
        int max = nRow * nCol;
        for (int off = col; off < max; off += nCol) {
            double v = vals[off];
            if (Util.eq(v, this.def)) continue;
            this.map.increment(v);
        }
    }

    private void updateGeneric(MatrixBlock data, int col) {
        int nRow = data.getNumRows();
        DenseBlock db = data.getDenseBlock();
        for (int i = 0; i < nRow; ++i) {
            int off;
            double[] c = db.values(i);
            double v = c[off = db.pos(i) + col];
            if (Util.eq(v, this.def)) continue;
            this.map.increment(v);
        }
    }

    @Override
    protected Pair<ICLAScheme, AColGroup> tryUpdateAndEncode(MatrixBlock data, IColIndex columns) {
        if (data.isEmpty()) {
            return new Pair<ICLAScheme, AColGroup>(this, new ColGroupEmpty(columns));
        }
        int nRow = data.getNumRows();
        Pair<IntArrayList, AMapToData> e = this.encodeAndUpdate(data, this.cols.get(0));
        this.allocateDictionary();
        AOffset off = OffsetFactory.createOffset(e.getKey());
        off.constructSkipList();
        AColGroup g = ColGroupSDC.create(columns, nRow, this.lastDict, new double[]{this.def}, off, e.getValue(), null);
        return new Pair<ICLAScheme, AColGroup>(this, g);
    }

    private Pair<IntArrayList, AMapToData> encodeAndUpdate(MatrixBlock data, int col) {
        if (data.isInSparseFormat()) {
            return this.encodeAndUpdateSparse(data, col);
        }
        if (data.getDenseBlock().isContiguous()) {
            return this.encodeAndUpdateDense(data, col);
        }
        return this.encodeAndUpdateGeneric(data, col);
    }

    private Pair<IntArrayList, AMapToData> encodeAndUpdateSparse(MatrixBlock data, int col) {
        int nRow = data.getNumRows();
        SparseBlock sb = data.getSparseBlock();
        IntArrayList off = this.getCachedArray(0);
        IntArrayList val = this.getCachedArray(1);
        for (int i = 0; i < nRow; ++i) {
            double v = sb.get(i, col);
            if (Util.eq(v, this.def)) continue;
            off.appendValue(i);
            val.appendValue(this.map.increment(v));
        }
        AMapToData d = MapToFactory.create(off.size(), this.map.size());
        for (int i = 0; i < off.size(); ++i) {
            d.set(i, val.get(i));
        }
        return new Pair<IntArrayList, AMapToData>(off, d);
    }

    private Pair<IntArrayList, AMapToData> encodeAndUpdateDense(MatrixBlock data, int col) {
        int nRow = data.getNumRows();
        double[] vals = data.getDenseBlockValues();
        int nCol = data.getNumColumns();
        int max = nRow * nCol;
        IntArrayList off = this.getCachedArray(0);
        IntArrayList val = this.getCachedArray(1);
        int i = 0;
        for (int o = col; o < max; o += nCol) {
            if (!Util.eq(vals[o], this.def)) {
                off.appendValue(i);
                val.appendValue(this.map.increment(vals[o]));
            }
            ++i;
        }
        AMapToData d = MapToFactory.create(off.size(), this.map.size());
        for (int i2 = 0; i2 < off.size(); ++i2) {
            int o = off.get(i2) * nCol + col;
            d.set(i2, this.map.getId(vals[o]));
        }
        return new Pair<IntArrayList, AMapToData>(off, d);
    }

    private Pair<IntArrayList, AMapToData> encodeAndUpdateGeneric(MatrixBlock data, int col) {
        throw new NotImplementedException();
    }

    private IntArrayList getCachedArray(int id) {
        if (cachedArrays == null) {
            ThreadLocal<Pair<IntArrayList, IntArrayList>> t = new ThreadLocal<Pair<IntArrayList, IntArrayList>>(){

                @Override
                protected Pair<IntArrayList, IntArrayList> initialValue() {
                    IntArrayList a = new IntArrayList();
                    IntArrayList b = new IntArrayList();
                    Pair<IntArrayList, IntArrayList> p = new Pair<IntArrayList, IntArrayList>(a, b);
                    return p;
                }
            };
            cachedArrays = new SoftReference<1>(t);
        }
        IntArrayList ret = id == 0 ? cachedArrays.get().get().getKey() : cachedArrays.get().get().getValue();
        ret.reset();
        return ret;
    }

    @Override
    protected AColGroup encodeVT(MatrixBlock data, IColIndex columns) {
        if (data.isEmpty() || data.isInSparseFormat() && data.getSparseBlock().isEmpty(columns.get(0))) {
            return new ColGroupEmpty(columns);
        }
        if (data.isInSparseFormat()) {
            return this.encodeSparseT(data, columns);
        }
        return this.encodeDenseT(data, columns);
    }

    private AColGroup encodeDenseT(MatrixBlock data, IColIndex columns) {
        int col = columns.get(0);
        int nCol = data.getNumColumns();
        DenseBlock db = data.getDenseBlock();
        double[] vals = db.values(col);
        int offStart = db.pos(col);
        IntArrayList off = new IntArrayList();
        int i = 0;
        int o = offStart;
        while (i < nCol) {
            if (!Util.eq(vals[o], this.def)) {
                off.appendValue(i);
            }
            ++i;
            ++o;
        }
        AMapToData d = MapToFactory.create(off.size(), this.map.size());
        for (int i2 = 0; i2 < off.size(); ++i2) {
            int o2 = off.get(i2) + offStart;
            d.set(i2, this.map.getId(vals[o2]));
        }
        return this.finalizeEncode(data, off, d, columns, data.getNumColumns());
    }

    private AColGroup encodeSparseT(MatrixBlock data, IColIndex columns) {
        int col = columns.get(0);
        int nRow = data.getNumColumns();
        SparseBlock sb = data.getSparseBlock();
        int apos = sb.pos(col);
        int[] aix = sb.indexes(col);
        int alen = sb.size(col) + apos;
        double[] aval = sb.values(col);
        if (this.def == 0.0) {
            AMapToData d = MapToFactory.create(alen - apos, this.map.size());
            int end = alen - apos;
            int i = 0;
            while (i < end) {
                d.set(i, this.map.getId(aval[apos]));
                ++i;
                ++apos;
            }
            this.allocateDictionary();
            AOffset off = OffsetFactory.createOffset(aix, sb.pos(col), alen);
            return ColGroupSDC.create(columns, nRow, this.lastDict, new double[]{this.def}, off, d, null);
        }
        IntArrayList off = this.getCachedArray(0);
        IntArrayList dt = this.getCachedArray(1);
        int zeroId = this.map.getId(0.0);
        for (int i = 0; i < data.getNumColumns(); ++i) {
            if (apos < alen && aix[apos] == i) {
                if (!Util.eq(aval[apos], this.def)) {
                    off.appendValue(i);
                    dt.appendValue(this.map.getId(aval[apos]));
                }
                ++apos;
                continue;
            }
            off.appendValue(i);
            dt.appendValue(zeroId);
        }
        AMapToData d = MapToFactory.create(dt.size(), this.map.size());
        for (int i = 0; i < dt.size(); ++i) {
            d.set(i, dt.get(i));
        }
        this.allocateDictionary();
        return ColGroupSDC.create(columns, nRow, this.lastDict, new double[]{this.def}, OffsetFactory.createOffset(off), d, null);
    }

    @Override
    protected ICLAScheme updateVT(MatrixBlock data, IColIndex columns) {
        int col = columns.get(0);
        if (data.isEmpty() || data.isInSparseFormat() && data.getSparseBlock().isEmpty(columns.get(0))) {
            if (this.def != 0.0) {
                this.map.increment(0.0, col);
            }
        } else if (data.isInSparseFormat()) {
            this.updateSparseT(data, col);
        } else {
            this.updateDenseT(data, col);
        }
        return this;
    }

    private void updateSparseT(MatrixBlock data, int col) {
        SparseBlock sb = data.getSparseBlock();
        int apos = sb.pos(col);
        int alen = sb.size(col) + apos;
        double[] aval = sb.values(col);
        if (this.def == 0.0) {
            int end = alen - apos;
            int i = 0;
            while (i < end) {
                this.map.increment(aval[apos]);
                ++i;
                ++apos;
            }
        } else {
            int end = alen - apos;
            int i = 0;
            while (i < end) {
                if (!Util.eq(aval[apos], this.def)) {
                    this.map.increment(aval[apos]);
                }
                ++i;
                ++apos;
            }
            this.map.increment(0.0, data.getNumColumns() - end);
        }
    }

    private void updateDenseT(MatrixBlock data, int col) {
        DenseBlock db = data.getDenseBlock();
        double[] vals = db.values(col);
        int nCol = data.getNumColumns();
        int i = 0;
        int off = db.pos(col);
        while (i < nCol) {
            double v = vals[off];
            if (!Util.eq(v, this.def)) {
                this.map.increment(v);
            }
            ++i;
            ++off;
        }
    }

    @Override
    protected Pair<ICLAScheme, AColGroup> tryUpdateAndEncodeT(MatrixBlock data, IColIndex columns) {
        if (data.isEmpty() || data.isInSparseFormat() && data.getSparseBlock().isEmpty(columns.get(0))) {
            return new Pair<ICLAScheme, AColGroup>(this, new ColGroupEmpty(columns));
        }
        if (data.isInSparseFormat()) {
            return this.encodeAndUpdateSparseT(data, columns);
        }
        throw new NotImplementedException();
    }

    protected Pair<ICLAScheme, AColGroup> encodeAndUpdateSparseT(MatrixBlock data, IColIndex columns) {
        int col = columns.get(0);
        int nRow = data.getNumColumns();
        SparseBlock sb = data.getSparseBlock();
        int apos = sb.pos(col);
        int[] aix = sb.indexes(col);
        int alen = sb.size(col) + apos;
        double[] aval = sb.values(col);
        if (this.def == 0.0) {
            AMapToData d = MapToFactory.create(alen - apos, this.map.size());
            int end = alen - apos;
            int i = 0;
            while (i < end) {
                d.set(i, this.map.increment(aval[apos]));
                ++i;
                ++apos;
            }
            this.allocateDictionary();
            AOffset off = OffsetFactory.createOffset(aix, sb.pos(col), alen);
            AColGroup g = ColGroupSDC.create(columns, nRow, this.lastDict, new double[]{this.def}, off, d, null);
            return new Pair<ICLAScheme, AColGroup>(this, g);
        }
        IntArrayList off = this.getCachedArray(0);
        IntArrayList dt = this.getCachedArray(1);
        int zeroId = this.map.getId(0.0);
        for (int i = 0; i < data.getNumColumns(); ++i) {
            if (aix[apos] == i) {
                if (!Util.eq(aval[apos], this.def)) {
                    off.appendValue(i);
                    dt.appendValue(this.map.increment(aval[apos]));
                }
                ++apos;
                continue;
            }
            off.appendValue(i);
            dt.appendValue(zeroId);
        }
        AMapToData d = MapToFactory.create(dt.size(), this.map.size());
        for (int i = 0; i < dt.size(); ++i) {
            d.set(i, dt.get(i));
        }
        this.allocateDictionary();
        AColGroup g = ColGroupSDC.create(columns, nRow, this.lastDict, new double[]{this.def}, OffsetFactory.createOffset(off), d, null);
        return new Pair<ICLAScheme, AColGroup>(this, g);
    }

    @Override
    public SDCSchemeSC clone() {
        return new SDCSchemeSC(this.cols, this.map.clone(), this.def);
    }
}

