/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.cog;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.io.cog.COGByteReader;
import org.apache.sysds.runtime.io.cog.IFDTag;
import org.apache.sysds.runtime.io.cog.IFDTagDictionary;
import org.apache.sysds.runtime.io.cog.TIFFDataTypes;

public class COGHeader {
    private boolean isLittleEndian;
    private String GDALMetadata;
    private IFDTag[] IFD;
    private boolean isBigTIFF;
    private ArrayList<IFDTag[]> additionalIFDs;

    public COGHeader(boolean isLittleEndian) {
        this.isLittleEndian = isLittleEndian;
        this.GDALMetadata = "";
        this.additionalIFDs = new ArrayList();
    }

    public void setIFD(IFDTag[] IFD) {
        this.IFD = IFD;
    }

    public IFDTag[] getIFD() {
        return this.IFD;
    }

    public void addAdditionalIFD(IFDTag[] IFD) {
        this.additionalIFDs.add(IFD);
    }

    public ArrayList<IFDTag[]> getAdditionalIFDs() {
        return this.additionalIFDs;
    }

    public IFDTag[] getSingleAdditionalIFD(int index) {
        return this.additionalIFDs.get(index);
    }

    public void setSingleAdditionalIFD(int index, IFDTag[] IFD) {
        this.additionalIFDs.set(index, IFD);
    }

    public void removeSingleAdditionalIFD(int index) {
        this.additionalIFDs.remove(index);
    }

    public void setLittleEndian(boolean isLittleEndian) {
        this.isLittleEndian = isLittleEndian;
    }

    public boolean isLittleEndian() {
        return this.isLittleEndian;
    }

    public void setGDALMetadata(String GDALMetadata) {
        this.GDALMetadata = GDALMetadata;
    }

    public String getGDALMetadata() {
        return this.GDALMetadata;
    }

    public void setBigTIFF(boolean isBigTIFF) {
        this.isBigTIFF = isBigTIFF;
    }

    public boolean isBigTIFF() {
        return this.isBigTIFF;
    }

    public Number parseByteArray(byte[] bytes, int length, int offset, boolean isDecimal, boolean isSigned, boolean isRational) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.order(this.isLittleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        buffer.position(offset);
        if (isRational && !isSigned) {
            long numerator = Integer.toUnsignedLong(buffer.getInt());
            long denominator = Integer.toUnsignedLong(buffer.getInt());
            return (double)numerator / (double)denominator;
        }
        if (isRational && isSigned) {
            long numerator = buffer.getInt();
            long denominator = buffer.getInt();
            return (double)numerator / (double)denominator;
        }
        if (isDecimal) {
            switch (length) {
                case 4: {
                    return Float.valueOf(buffer.getFloat());
                }
                case 8: {
                    return buffer.getDouble();
                }
            }
            throw new IllegalArgumentException("Unsupported length: " + length);
        }
        switch (length) {
            case 1: {
                return isSigned ? buffer.get() : Byte.toUnsignedInt(buffer.get());
            }
            case 2: {
                return isSigned ? buffer.getShort() : Short.toUnsignedInt(buffer.getShort());
            }
            case 4: {
                return isSigned ? (long)buffer.getInt() : Integer.toUnsignedLong(buffer.getInt());
            }
            case 8: {
                return isSigned ? buffer.getLong() : buffer.getLong();
            }
        }
        throw new IllegalArgumentException("Unsupported length: " + length);
    }

    private static COGHeader prepareHeader(COGByteReader byteReader) {
        byte[] header = byteReader.readBytes(4);
        boolean littleEndian = false;
        if ((header[0] & 0xFF) == 77 && (header[1] & 0xFF) == 77) {
            littleEndian = false;
        } else if ((header[0] & 0xFF) == 73 && (header[1] & 0xFF) == 73) {
            littleEndian = true;
        } else {
            throw new DMLRuntimeException("Invalid Byte-Order");
        }
        COGHeader cogHeader = new COGHeader(littleEndian);
        int magic = cogHeader.parseByteArray(header, 2, 2, false, false, false).intValue();
        if (magic == 42) {
            cogHeader.setBigTIFF(false);
        } else if (magic == 43) {
            cogHeader.setBigTIFF(true);
        } else {
            throw new DMLRuntimeException("Invalid Magic Number");
        }
        return cogHeader;
    }

    public static COGHeader readCOGHeader(COGByteReader byteReader) {
        int tagDataLength;
        byte[] ifdOffsetRaw;
        long ifdOffset;
        COGHeader cogHeader = COGHeader.prepareHeader(byteReader);
        int ifdOffsetSize = 4;
        if (cogHeader.isBigTIFF()) {
            byte[] offsetSize = byteReader.readBytes(2);
            ifdOffsetSize = cogHeader.parseByteArray(offsetSize, 2, 0, false, false, false).shortValue();
            byteReader.skipBytes(2L);
        }
        if ((ifdOffset = (long)cogHeader.parseByteArray(ifdOffsetRaw = byteReader.readBytes(ifdOffsetSize), ifdOffsetSize, 0, false, false, false).intValue()) > 8L) {
            byte[] metadata = byteReader.readBytes(ifdOffset - (long)(cogHeader.isBigTIFF() ? 16 : 8));
            cogHeader.setGDALMetadata(new String(metadata));
        }
        boolean firstIFD = true;
        int nextIFDOffset = 0;
        int tagCountLength = cogHeader.isBigTIFF() ? 8 : 4;
        int n = tagDataLength = cogHeader.isBigTIFF() ? 8 : 4;
        while (nextIFDOffset != 0 || firstIFD) {
            byteReader.skipBytes((long)nextIFDOffset - (firstIFD ? 0L : byteReader.getTotalBytesRead()));
            byte[] numberOfTagsRaw = byteReader.readBytes(cogHeader.isBigTIFF() ? 8 : 2);
            int numberOfTags = cogHeader.parseByteArray(numberOfTagsRaw, cogHeader.isBigTIFF() ? 8 : 2, 0, false, false, false).intValue();
            IFDTag[] ifdTags = new IFDTag[numberOfTags];
            for (int i = 0; i < numberOfTags; ++i) {
                IFDTag ifdTag;
                Number[] tagData;
                byte[] tag = byteReader.readBytes(cogHeader.isBigTIFF() ? 20 : 12);
                int tagId = cogHeader.parseByteArray(tag, 2, 0, false, false, false).intValue();
                int tagType = cogHeader.parseByteArray(tag, 2, 2, false, false, false).intValue();
                TIFFDataTypes dataType = TIFFDataTypes.valueOf(tagType);
                int tagCount = cogHeader.parseByteArray(tag, tagCountLength, 4, false, false, false).intValue();
                long tagValue = cogHeader.parseByteArray(tag, tagDataLength, cogHeader.isBigTIFF() ? 12 : 8, false, false, false).longValue();
                if (dataType.getSize() * tagCount <= tagDataLength) {
                    tagData = COGHeader.parseTagData(tagCount, tag, dataType, cogHeader, cogHeader.isBigTIFF() ? 8 : 4, cogHeader.isBigTIFF() ? 12 : 8);
                } else {
                    long offset = tagValue;
                    int totalSize = tagCount * dataType.getSize();
                    long bytesToRead = offset - byteReader.getTotalBytesRead() + (long)totalSize;
                    byteReader.mark((int)bytesToRead);
                    byteReader.readBytes(offset - byteReader.getTotalBytesRead());
                    byte[] data = byteReader.readBytes(totalSize);
                    tagData = COGHeader.parseTagData(tagCount, data, dataType, cogHeader, 0);
                    byteReader.reset();
                }
                IFDTagDictionary tagDictionary = IFDTagDictionary.valueOf(tagId);
                ifdTags[i] = ifdTag = new IFDTag(tagDictionary != null ? tagDictionary : IFDTagDictionary.Unknown, (short)tagType, tagCount, tagData);
            }
            if (firstIFD) {
                cogHeader.setIFD((IFDTag[])ifdTags.clone());
                firstIFD = false;
            } else {
                cogHeader.addAdditionalIFD((IFDTag[])ifdTags.clone());
            }
            byte[] nextIFDOffsetRaw = byteReader.readBytes(4);
            nextIFDOffset = cogHeader.parseByteArray(nextIFDOffsetRaw, 4, 0, false, false, false).intValue();
        }
        return cogHeader;
    }

    private static Number[] parseTagData(int tagCount, byte[] rawData, TIFFDataTypes dataType, COGHeader cogHeader, int maxSize) {
        return COGHeader.parseTagData(tagCount, rawData, dataType, cogHeader, maxSize, 0);
    }

    private static Number[] parseTagData(int tagCount, byte[] rawData, TIFFDataTypes dataType, COGHeader cogHeader, int maxSize, int offset) {
        if (maxSize > 0 && dataType.getSize() * tagCount > maxSize) {
            throw new DMLRuntimeException("Error while parsing. Data type " + dataType.toString() + " cannot fit into " + maxSize + " bytes");
        }
        Number[] tagData = new Number[tagCount];
        block7: for (int j = 0; j < tagCount; ++j) {
            switch (dataType) {
                case BYTE: 
                case ASCII: 
                case SHORT: 
                case LONG: 
                case LONG8: 
                case UNDEFINED: {
                    tagData[j] = cogHeader.parseByteArray(rawData, dataType.getSize(), offset + j * dataType.getSize(), false, false, false);
                    continue block7;
                }
                case SBYTE: 
                case SSHORT: 
                case SLONG: 
                case SLONG8: 
                case IFD8: {
                    tagData[j] = cogHeader.parseByteArray(rawData, dataType.getSize(), offset + j * dataType.getSize(), false, true, false);
                    continue block7;
                }
                case RATIONAL: {
                    tagData[j] = cogHeader.parseByteArray(rawData, dataType.getSize(), offset + j * dataType.getSize(), false, false, true);
                    continue block7;
                }
                case SRATIONAL: {
                    tagData[j] = cogHeader.parseByteArray(rawData, dataType.getSize(), offset + j * dataType.getSize(), false, true, true);
                    continue block7;
                }
                case FLOAT: 
                case DOUBLE: {
                    tagData[j] = cogHeader.parseByteArray(rawData, dataType.getSize(), offset + j * dataType.getSize(), true, false, false);
                }
            }
        }
        return tagData;
    }

    public static String isCompatible(IFDTag[] IFD) {
        boolean hasTileOffsets = false;
        int imageWidth = -1;
        int imageHeight = -1;
        int tileWidth = -1;
        int tileHeight = -1;
        block9: for (IFDTag tag : IFD) {
            switch (tag.getTagId()) {
                case BitsPerSample: {
                    Number[] data = tag.getData();
                    for (int i = 0; i < data.length; ++i) {
                        if (data[i].intValue() == 8 || data[i].intValue() == 16 || data[i].intValue() == 32) continue;
                        return "Unsupported bit depth: " + data[i];
                    }
                    continue block9;
                }
                case TileOffsets: {
                    if (tag.getData().length <= 0) continue block9;
                    hasTileOffsets = true;
                    continue block9;
                }
                case Compression: {
                    if (tag.getData()[0].intValue() == 1 || tag.getData()[0].intValue() == 8) continue block9;
                    return "Unsupported compression: " + tag.getData()[0];
                }
                case ImageWidth: {
                    imageWidth = tag.getData()[0].intValue();
                    continue block9;
                }
                case ImageLength: {
                    imageHeight = tag.getData()[0].intValue();
                    continue block9;
                }
                case TileWidth: {
                    tileWidth = tag.getData()[0].intValue();
                    continue block9;
                }
                case TileLength: {
                    tileHeight = tag.getData()[0].intValue();
                }
            }
        }
        if (!hasTileOffsets) {
            return "No tile offsets found";
        }
        if (imageWidth % tileWidth != 0 || imageHeight % tileHeight != 0) {
            return "Image can't be split into tiles equally";
        }
        return "";
    }
}

