/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.cog;

public enum TIFFDataTypes {
    BYTE(1),
    ASCII(2),
    SHORT(3),
    LONG(4),
    RATIONAL(5),
    SBYTE(6),
    UNDEFINED(7),
    SSHORT(8),
    SLONG(9),
    SRATIONAL(10),
    FLOAT(11),
    DOUBLE(12),
    LONG8(16),
    SLONG8(17),
    IFD8(18);

    private final int value;

    private TIFFDataTypes(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public int getSize() {
        switch (this) {
            case BYTE: 
            case ASCII: 
            case SBYTE: 
            case UNDEFINED: {
                return 1;
            }
            case SHORT: 
            case SSHORT: {
                return 2;
            }
            case LONG: 
            case SLONG: 
            case FLOAT: {
                return 4;
            }
            case RATIONAL: 
            case SRATIONAL: 
            case DOUBLE: 
            case LONG8: 
            case SLONG8: 
            case IFD8: {
                return 8;
            }
        }
        return 0;
    }

    public static TIFFDataTypes valueOf(int value) {
        for (TIFFDataTypes dataType : TIFFDataTypes.values()) {
            if (dataType.getValue() != value) continue;
            return dataType;
        }
        return null;
    }
}

