/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.util;

import org.apache.tapestry5.ioc.services.ClassPropertyAdapter;
import org.apache.tapestry5.ioc.services.PropertyAccess;

public class ExceptionUtils {
    public static <T extends Throwable> T findCause(Throwable t, Class<T> type) {
        for (Throwable current = t; current != null; current = current.getCause()) {
            if (!type.isInstance(current)) continue;
            return (T)((Throwable)type.cast(current));
        }
        return null;
    }

    public static <T extends Throwable> T findCause(Throwable t, Class<T> type, PropertyAccess access) {
        Throwable current = t;
        while (current != null) {
            if (type.isInstance(current)) {
                return (T)((Throwable)type.cast(current));
            }
            Throwable next = null;
            ClassPropertyAdapter adapter = access.getAdapter(current);
            for (String name : adapter.getPropertyNames()) {
                Object value = adapter.getPropertyAdapter(name).get(current);
                if (value == null || value == current || !(value instanceof Throwable)) continue;
                next = (Throwable)value;
                break;
            }
            current = next;
        }
        return null;
    }

    public static String toMessage(Throwable exception) {
        assert (exception != null);
        String message = exception.getMessage();
        if (message != null) {
            return message;
        }
        return exception.getClass().getName();
    }
}

