/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.javadoc;

import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;

public class ParameterDescription {
    public final FieldDoc field;
    public final String name;
    public final String type;
    public final String defaultValue;
    public final String defaultPrefix;
    public final boolean required;
    public final boolean allowNull;
    public final boolean cache;
    public final String since;
    public final boolean deprecated;
    private static final Pattern SPECIAL_CONTENT = Pattern.compile("(?:</?(\\p{Alpha}+)>)|(?:&\\p{Alpha}+;)");
    private static final Set<String> PASS_THROUGH_TAGS = CollectionFactory.newSet((Object[])new String[]{"b", "em", "i", "code", "strong"});

    public ParameterDescription(FieldDoc fieldDoc, String name, String type, String defaultValue, String defaultPrefix, boolean required, boolean allowNull, boolean cache, String since, boolean deprecated) {
        this.field = fieldDoc;
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.defaultPrefix = defaultPrefix;
        this.required = required;
        this.allowNull = allowNull;
        this.cache = cache;
        this.since = since;
        this.deprecated = deprecated;
    }

    public String extractDescription() throws IOException {
        StringBuilder builder = new StringBuilder();
        for (Tag tag : this.field.inlineTags()) {
            if (tag.name().equals("Text")) {
                ParameterDescription.appendContentSafe(builder, tag.text());
                continue;
            }
            if (tag.name().equals("@link")) {
                SeeTag seeTag = (SeeTag)tag;
                String label = seeTag.label();
                if (label != null && !label.equals("")) {
                    builder.append(StringEscapeUtils.escapeHtml((String)label));
                    continue;
                }
                if (seeTag.referencedClassName() != null) {
                    builder.append(StringEscapeUtils.escapeHtml((String)seeTag.referencedClassName()));
                }
                if (seeTag.referencedMemberName() == null) continue;
                builder.append('#');
                builder.append(StringEscapeUtils.escapeHtml((String)seeTag.referencedMemberName()));
                continue;
            }
            if (!tag.name().equals("@code")) continue;
            builder.append("<code>");
            builder.append(StringEscapeUtils.escapeHtml((String)tag.text()));
            builder.append("</code>");
        }
        String text = builder.toString();
        return text.trim();
    }

    private static void appendContentSafe(StringBuilder sb, String string) {
        Matcher m = SPECIAL_CONTENT.matcher(string);
        int index = 0;
        while (index < string.length()) {
            boolean match = m.find(index);
            if (match) {
                String tagName;
                if (index != m.start()) {
                    sb.append(StringEscapeUtils.escapeHtml((String)string.substring(index, m.start())));
                }
                if ((tagName = m.group(1)) != null) {
                    if (PASS_THROUGH_TAGS.contains(tagName.toLowerCase(Locale.US))) {
                        sb.append(m.group());
                    }
                } else {
                    sb.append(m.group());
                }
                index = m.end();
                continue;
            }
            sb.append(StringEscapeUtils.escapeHtml((String)string.substring(index)));
            break;
        }
    }
}

