/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.annotations.Cached;
import org.apache.tapestry5.annotations.OnEvent;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.UnknownActivationContextCheck;
import org.apache.tapestry5.annotations.WhitelistAccessOnly;
import org.apache.tapestry5.ioc.annotations.Description;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.ComponentLibraryInfo;
import org.apache.tapestry5.services.ComponentLibraryInfoSource;
import org.apache.tapestry5.services.LibraryMapping;
import org.apache.tapestry5.util.TextStreamResponse;

@UnknownActivationContextCheck(value=false)
@WhitelistAccessOnly
public class ComponentLibraries {
    private static final String[] EMTPY_STRING_ARRAY = new String[0];
    private static final Comparator<LibraryMapping> LIBRARY_MAPPING_COMPARATOR = new Comparator<LibraryMapping>(){

        @Override
        public int compare(LibraryMapping mapping1, LibraryMapping mapping2) {
            return mapping1.libraryName.compareTo(mapping2.libraryName);
        }
    };
    @Inject
    private ComponentClassResolver componentClassResolver;
    @Property
    private LibraryMapping libraryMapping;
    @Property
    private String logicalName;
    @Property
    private List<String> logicalNames;
    @Property
    private String headerName;
    @Property
    private List<String> pages;
    @Property
    private List<String> components;
    @Property
    private List<String> mixins;
    private Type type;
    @Inject
    private Block classesTable;
    @Inject
    @Symbol(value="tapestry.production-mode")
    @Property
    private boolean productionMode;
    @Inject
    private ComponentLibraryInfoSource componentLibraryInfoSource;

    @Cached
    public List<LibraryMapping> getLibraryMappings() {
        ArrayList<LibraryMapping> mappings = new ArrayList<LibraryMapping>();
        for (LibraryMapping libraryMapping : this.componentClassResolver.getLibraryMappings()) {
            if ("".equals(libraryMapping.libraryName)) continue;
            mappings.add(libraryMapping);
        }
        Collections.sort(mappings, LIBRARY_MAPPING_COMPARATOR);
        return mappings;
    }

    @Cached(watch="libraryMapping")
    public ComponentLibraryInfo getInfo() {
        return this.componentLibraryInfoSource.find(this.libraryMapping);
    }

    public List<String> getLibraryNames() {
        return this.componentClassResolver.getLibraryNames();
    }

    public String getLibraryClientId() {
        return this.libraryMapping.libraryName.replace("/", "-");
    }

    private List<String> filter(List<String> allNames) {
        ArrayList<String> logicalNames = new ArrayList<String>();
        for (String name : allNames) {
            if (!name.startsWith(this.libraryMapping.libraryName + "/") || this.libraryMapping.libraryName.equals("core") && name.endsWith("Test")) continue;
            logicalNames.add(name);
        }
        return logicalNames;
    }

    public Block getComponentsTable() {
        this.logicalNames = this.filter(this.componentClassResolver.getComponentNames());
        this.type = Type.COMPONENT;
        this.headerName = "Components";
        return this.classesTable;
    }

    public Block getPagesTable() {
        this.logicalNames = this.filter(this.componentClassResolver.getPageNames());
        this.type = Type.PAGE;
        this.headerName = "Pages";
        return this.classesTable;
    }

    public Block getMixinsTable() {
        this.logicalNames = this.filter(this.componentClassResolver.getMixinNames());
        this.type = Type.MIXIN;
        this.headerName = "Mixins";
        return this.classesTable;
    }

    public String getSourceUrl() {
        return this.getInfo() != null ? this.getInfo().getSourceUrl(this.getClassName()) : null;
    }

    public String getJavaDocUrl() {
        return this.getInfo() != null ? this.getInfo().getJavadocUrl(this.getClassName()) : null;
    }

    private String getClassName() {
        return ComponentLibraries.getClassName(this.logicalName, this.type, this.componentClassResolver);
    }

    private static String getClassName(String logicalName, Type type, ComponentClassResolver componentClassResolver) {
        String className;
        switch (type) {
            case PAGE: {
                className = componentClassResolver.resolvePageNameToClassName(logicalName);
                break;
            }
            case COMPONENT: {
                className = componentClassResolver.resolveComponentTypeToClassName(logicalName);
                break;
            }
            case MIXIN: {
                className = componentClassResolver.resolveMixinTypeToClassName(logicalName);
                break;
            }
            default: {
                className = null;
            }
        }
        return className;
    }

    public String getSimpleLogicalName() {
        return this.logicalName.replace("core/", "");
    }

    @Cached(watch="logicalName")
    public String[] getTags() throws ClassNotFoundException {
        Description description = this.getDescription();
        return description != null ? description.tags() : EMTPY_STRING_ARRAY;
    }

    @Cached(watch="logicalName")
    public Description getDescription() throws ClassNotFoundException {
        return Class.forName(this.getClassName()).getAnnotation(Description.class);
    }

    public boolean isClassHasTags() throws ClassNotFoundException {
        return this.getTags().length > 0;
    }

    @OnEvent(value="json")
    Object generateJSONDescription(String libraryName) {
        for (LibraryMapping mapping : this.componentClassResolver.getLibraryMappings()) {
            if (!libraryName.equalsIgnoreCase(mapping.libraryName)) continue;
            this.libraryMapping = mapping;
            break;
        }
        JSONObject object = new JSONObject();
        object.put("libraryName", (Object)libraryName);
        object.put("rootPackage", (Object)this.libraryMapping.getRootPackage());
        ComponentLibraryInfo info = this.getInfo();
        if (info != null) {
            JSONObject infoJsonObject = new JSONObject();
            this.putIfNotNull("description", info.getDescription(), infoJsonObject);
            this.putIfNotNull("homepage", info.getHomepageUrl(), infoJsonObject);
            this.putIfNotNull("documentationUrl", info.getDocumentationUrl(), infoJsonObject);
            this.putIfNotNull("javadocUrl", info.getJavadocUrl(), infoJsonObject);
            this.putIfNotNull("groupId", info.getGroupId(), infoJsonObject);
            this.putIfNotNull("artifactId", info.getArtifactId(), infoJsonObject);
            this.putIfNotNull("version", info.getVersion(), infoJsonObject);
            this.putIfNotNull("sourceBrowseUrl", info.getSourceBrowseUrl(), infoJsonObject);
            this.putIfNotNull("sourceRootUrl", info.getSourceRootUrl(), infoJsonObject);
            this.putIfNotNull("issueTrackerUrl", info.getIssueTrackerUrl(), infoJsonObject);
            this.putIfNotNull("dependencyInfoUrl", info.getDependencyManagementInfoUrl(), infoJsonObject);
            if (info.getTags() != null) {
                for (String tag : info.getTags()) {
                    infoJsonObject.accumulate("tags", (Object)tag);
                }
            }
            object.put("info", (Object)infoJsonObject);
        }
        this.addClasses("components", this.filter(this.componentClassResolver.getComponentNames()), Type.COMPONENT, info, object);
        this.addClasses("pages", this.filter(this.componentClassResolver.getPageNames()), Type.PAGE, info, object);
        this.addClasses("mixins", this.filter(this.componentClassResolver.getMixinNames()), Type.MIXIN, info, object);
        return new TextStreamResponse("text/javascript", object.toString());
    }

    private void addClasses(String property, List<String> classes, Type type, ComponentLibraryInfo info, JSONObject object) {
        if (classes.size() > 0) {
            JSONArray classesJsonArray = new JSONArray();
            for (String logicalName : classes) {
                logicalName = logicalName.replace("core/", "");
                String className = ComponentLibraries.getClassName(logicalName, type, this.componentClassResolver);
                JSONObject classJsonObject = new JSONObject();
                classJsonObject.put("logicalName", (Object)logicalName);
                classJsonObject.put("class", (Object)className);
                if (info != null) {
                    this.putIfNotNull("sourceUrl", info.getSourceUrl(className), classJsonObject);
                    this.putIfNotNull("javadocUrl", info.getJavadocUrl(className), classJsonObject);
                }
                try {
                    Description description = this.getClass(className);
                    if (description != null) {
                        this.putIfNotNull("description", description.text(), classJsonObject);
                        if (description.tags().length > 0) {
                            for (String tag : description.tags()) {
                                classJsonObject.accumulate("tag", (Object)tag);
                            }
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                classesJsonArray.put((Object)classJsonObject);
            }
            object.put(property, (Object)classesJsonArray);
        }
    }

    private Description getClass(String className) throws ClassNotFoundException {
        return Class.forName(className).getAnnotation(Description.class);
    }

    private void putIfNotNull(String propertyName, String value, JSONObject object) {
        if (value != null) {
            object.put(propertyName, (Object)value);
        }
    }

    private static enum Type {
        PAGE,
        COMPONENT,
        MIXIN;

    }
}

