/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.dynamic;

import java.util.Map;
import org.apache.tapestry5.internal.dynamic.DynamicTemplateSaxParser;
import org.apache.tapestry5.internal.services.PageSource;
import org.apache.tapestry5.internal.services.TemplateParser;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.URLChangeTracker;
import org.apache.tapestry5.ioc.services.ClasspathURLConverter;
import org.apache.tapestry5.services.BindingSource;
import org.apache.tapestry5.services.UpdateListener;
import org.apache.tapestry5.services.UpdateListenerHub;
import org.apache.tapestry5.services.dynamic.DynamicTemplate;
import org.apache.tapestry5.services.dynamic.DynamicTemplateParser;

public class DynamicTemplateParserImpl
implements DynamicTemplateParser,
UpdateListener {
    private final Map<Resource, DynamicTemplate> cache = CollectionFactory.newConcurrentMap();
    private final BindingSource bindingSource;
    private final PageSource pageSource;
    private final URLChangeTracker tracker;
    private final TemplateParser componentTemplateParser;

    public DynamicTemplateParserImpl(ClasspathURLConverter converter, BindingSource bindingSource, PageSource pageSource, TemplateParser componentTemplateParser) {
        this.bindingSource = bindingSource;
        this.pageSource = pageSource;
        this.componentTemplateParser = componentTemplateParser;
        this.tracker = new URLChangeTracker(converter);
    }

    @PostInjection
    public void registerAsUpdateListener(UpdateListenerHub hub) {
        hub.addUpdateListener((UpdateListener)this);
    }

    @Override
    public DynamicTemplate parseTemplate(Resource resource) {
        DynamicTemplate result = this.cache.get(resource);
        if (result == null) {
            result = this.doParse(resource);
            this.cache.put(resource, result);
            this.tracker.add(resource.toURL());
        }
        return result;
    }

    private DynamicTemplate doParse(Resource resource) {
        return new DynamicTemplateSaxParser(resource, this.bindingSource, this.componentTemplateParser.getDTDURLMappings()).parse();
    }

    public void checkForUpdates() {
        if (this.tracker.containsChanges()) {
            this.tracker.clear();
            this.cache.clear();
            this.pageSource.clearCache();
        }
    }
}

