/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.TrackableComponentEventCallback;
import org.apache.tapestry5.internal.services.AjaxPartialResponseRenderer;
import org.apache.tapestry5.internal.services.ComponentResultProcessorWrapper;
import org.apache.tapestry5.internal.services.PageActivator;
import org.apache.tapestry5.internal.services.PageRenderQueue;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.structure.ComponentPageElement;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.internal.util.Holder;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.Ajax;
import org.apache.tapestry5.services.ComponentEventRequestHandler;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.ComponentEventResultProcessor;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.Request;

public class AjaxComponentEventRequestHandler
implements ComponentEventRequestHandler {
    private final RequestPageCache cache;
    private final Request request;
    private final PageRenderQueue queue;
    private final ComponentEventResultProcessor resultProcessor;
    private final Environment environment;
    private final AjaxPartialResponseRenderer partialRenderer;
    private final PageActivator pageActivator;

    public AjaxComponentEventRequestHandler(RequestPageCache cache, Request request, PageRenderQueue queue, @Ajax ComponentEventResultProcessor resultProcessor, PageActivator pageActivator, Environment environment, AjaxPartialResponseRenderer partialRenderer) {
        this.cache = cache;
        this.queue = queue;
        this.resultProcessor = resultProcessor;
        this.pageActivator = pageActivator;
        this.request = request;
        this.environment = environment;
        this.partialRenderer = partialRenderer;
    }

    @Override
    public void handle(ComponentEventRequestParameters parameters) throws IOException {
        Page activePage = this.cache.get(parameters.getActivePageName());
        final Holder<Boolean> resultProcessorInvoked = Holder.create();
        resultProcessorInvoked.put(false);
        ComponentEventResultProcessor interceptor = new ComponentEventResultProcessor(){

            public void processResultValue(Object value) throws IOException {
                resultProcessorInvoked.put(true);
                AjaxComponentEventRequestHandler.this.resultProcessor.processResultValue(value);
            }
        };
        this.queue.setRenderingPage(activePage);
        this.request.setAttribute("page-name", parameters.getActivePageName());
        if (this.pageActivator.activatePage(activePage.getRootElement().getComponentResources(), parameters.getPageActivationContext(), interceptor)) {
            return;
        }
        Page containerPage = this.cache.get(parameters.getContainingPageName());
        ComponentPageElement element = containerPage.getComponentElementByNestedId(parameters.getNestedComponentId());
        ComponentResultProcessorWrapper callback = new ComponentResultProcessorWrapper(interceptor);
        this.environment.push(ComponentEventResultProcessor.class, interceptor);
        this.environment.push(TrackableComponentEventCallback.class, callback);
        boolean handled = element.triggerContextEvent(parameters.getEventType(), parameters.getEventContext(), callback);
        if (!handled) {
            throw new TapestryException(String.format("Request event '%s' (on component %s) was not handled; you must provide a matching event handler method in the component or in one of its containers.", parameters.getEventType(), element.getCompleteId()), (Object)element, null);
        }
        this.environment.pop(TrackableComponentEventCallback.class);
        this.environment.pop(ComponentEventResultProcessor.class);
        boolean wasInvoked = (Boolean)resultProcessorInvoked.get();
        if (!wasInvoked && this.queue.isPartialRenderInitialized()) {
            this.partialRenderer.renderPartialPageMarkup();
            return;
        }
        if (wasInvoked) {
            return;
        }
        this.resultProcessor.processResultValue(new JSONObject());
    }
}

