/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Locale;
import java.util.Map;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.services.pageload.ComponentResourceSelector;
import org.apache.tapestry5.services.transform.InjectionProvider2;
import org.slf4j.Logger;

public class CommonResourcesInjectionProvider
implements InjectionProvider2 {
    private static ResourceProvider<ComponentResourceSelector> selectorProvider = new ResourceProvider<ComponentResourceSelector>(){

        @Override
        public ComponentResourceSelector get(ComponentResources resources) {
            return resources.getResourceSelector();
        }
    };
    private static ResourceProvider<Messages> messagesProvider = new ResourceProvider<Messages>(){

        @Override
        public Messages get(ComponentResources resources) {
            return resources.getMessages();
        }
    };
    private static ResourceProvider<Locale> localeProvider = new ResourceProvider<Locale>(){

        @Override
        public Locale get(ComponentResources resources) {
            return resources.getLocale();
        }
    };
    private static ResourceProvider<Logger> loggerProvider = new ResourceProvider<Logger>(){

        @Override
        public Logger get(ComponentResources resources) {
            return resources.getLogger();
        }
    };
    private static ResourceProvider<ComponentResources> resourcesProvider = new ResourceProvider<ComponentResources>(){

        @Override
        public ComponentResources get(ComponentResources resources) {
            return resources;
        }
    };
    private static final Map<String, ResourceProvider> configuration = CollectionFactory.newMap();

    public CommonResourcesInjectionProvider() {
        CommonResourcesInjectionProvider.add(ComponentResources.class, resourcesProvider);
        CommonResourcesInjectionProvider.add(ComponentResourceSelector.class, selectorProvider);
        CommonResourcesInjectionProvider.add(Messages.class, messagesProvider);
        CommonResourcesInjectionProvider.add(Locale.class, localeProvider);
        CommonResourcesInjectionProvider.add(Logger.class, loggerProvider);
    }

    private static void add(Class type, ResourceProvider provider) {
        configuration.put(type.getName(), provider);
    }

    @Override
    public boolean provideInjection(PlasticField field, ObjectLocator locator, MutableComponentModel componentModel) {
        ResourceProvider provider = configuration.get(field.getTypeName());
        if (provider == null) {
            return false;
        }
        field.injectComputed((ComputedValue)provider);
        return true;
    }

    static abstract class ResourceProvider<T>
    implements ComputedValue<T> {
        ResourceProvider() {
        }

        public T get(InstanceContext context) {
            ComponentResources resources = (ComponentResources)context.get(ComponentResources.class);
            return this.get(resources);
        }

        abstract T get(ComponentResources var1);
    }
}

