/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.ajax;

import java.io.IOException;
import java.util.Map;
import org.apache.tapestry5.ajax.MultiZoneUpdate;
import org.apache.tapestry5.internal.services.AjaxPartialResponseRenderer;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.ioc.util.ExceptionUtils;
import org.apache.tapestry5.runtime.RenderCommand;
import org.apache.tapestry5.services.ComponentEventResultProcessor;
import org.apache.tapestry5.services.ajax.AjaxResponseRenderer;

public class MultiZoneUpdateEventResultProcessor
implements ComponentEventResultProcessor<MultiZoneUpdate> {
    private final TypeCoercer typeCoercer;
    private final AjaxResponseRenderer ajaxResponseRenderer;
    private final AjaxPartialResponseRenderer partialRenderer;

    public MultiZoneUpdateEventResultProcessor(TypeCoercer typeCoercer, AjaxResponseRenderer ajaxResponseRenderer, AjaxPartialResponseRenderer partialRenderer) {
        this.typeCoercer = typeCoercer;
        this.ajaxResponseRenderer = ajaxResponseRenderer;
        this.partialRenderer = partialRenderer;
    }

    @Override
    public void processResultValue(MultiZoneUpdate value) throws IOException {
        Map<String, Object> map = value.getZoneToRenderMap();
        for (String zoneId : map.keySet()) {
            Object provided = map.get(zoneId);
            RenderCommand zoneRenderCommand = this.toRenderer(zoneId, provided);
            this.ajaxResponseRenderer.addRender(zoneId, zoneRenderCommand);
        }
        this.partialRenderer.renderPartialPageMarkup();
    }

    private RenderCommand toRenderer(String zoneId, Object provided) {
        try {
            return (RenderCommand)this.typeCoercer.coerce(provided, RenderCommand.class);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(String.format("Failure converting renderer for zone '%s': %s", zoneId, ExceptionUtils.toMessage((Throwable)ex)), ex);
        }
    }
}

