/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Map;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.services.assets.DelegatingSRS;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.assets.ResourceDependencies;
import org.apache.tapestry5.services.assets.StreamableResource;
import org.apache.tapestry5.services.assets.StreamableResourceProcessing;
import org.apache.tapestry5.services.assets.StreamableResourceSource;

public class SRSCachingInterceptor
extends DelegatingSRS {
    private final Map<Resource, SoftReference<StreamableResource>> cache = CollectionFactory.newConcurrentMap();

    public SRSCachingInterceptor(StreamableResourceSource delegate, ResourceChangeTracker tracker) {
        super(delegate);
        tracker.clearOnInvalidation(this.cache);
    }

    @Override
    public StreamableResource getStreamableResource(Resource baseResource, StreamableResourceProcessing processing, ResourceDependencies dependencies) throws IOException {
        if (!this.enableCache(processing)) {
            return this.delegate.getStreamableResource(baseResource, processing, dependencies);
        }
        StreamableResource result = TapestryInternalUtils.getAndDeref(this.cache, baseResource);
        if (result == null && this.isCacheable(result = this.delegate.getStreamableResource(baseResource, processing, dependencies))) {
            dependencies.addDependency(baseResource);
            this.cache.put(baseResource, new SoftReference<StreamableResource>(result));
        }
        return result;
    }

    protected boolean isCacheable(StreamableResource resource) {
        return true;
    }

    protected boolean enableCache(StreamableResourceProcessing processing) {
        return processing != StreamableResourceProcessing.FOR_AGGREGATION;
    }
}

