/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.commons.services.InvalidationEventHub;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.commons.util.ExceptionUtils;
import org.apache.tapestry5.http.services.RequestGlobals;
import org.apache.tapestry5.internal.services.PageSource;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.annotations.ComponentClasses;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.annotations.Scope;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.slf4j.Logger;

@Scope(value="perthread")
public class RequestPageCacheImpl
implements RequestPageCache,
Runnable {
    private final Logger logger;
    private final ComponentClassResolver resolver;
    private final PageSource pageSource;
    private final RequestGlobals requestGlobals;
    private final Map<String, Page> cache = CollectionFactory.newMap();

    public RequestPageCacheImpl(Logger logger, ComponentClassResolver resolver, PageSource pageSource, RequestGlobals requestGlobals) {
        this.logger = logger;
        this.resolver = resolver;
        this.pageSource = pageSource;
        this.requestGlobals = requestGlobals;
    }

    @PostInjection
    public void listenForThreadCleanup(PerthreadManager perthreadManager, @ComponentClasses InvalidationEventHub classesHub) {
        perthreadManager.addThreadCleanupCallback((Runnable)this);
        classesHub.addInvalidationCallback(this::listen);
    }

    @Override
    public void run() {
        for (Page page : this.cache.values()) {
            try {
                page.detached();
            }
            catch (Throwable t) {
                this.logger.error("Error detaching page {}: {}", new Object[]{page, ExceptionUtils.toMessage((Throwable)t), t});
            }
        }
    }

    @Override
    public Page get(String pageName) {
        String canonical = this.resolver.canonicalizePageName(pageName);
        Page page = this.cache.get(canonical);
        if (page == null) {
            page = this.pageSource.getPage(canonical);
            try {
                page.attached();
            }
            catch (Throwable t) {
                throw new RuntimeException(String.format("Unable to attach page %s: %s", canonical, ExceptionUtils.toMessage((Throwable)t)), t);
            }
            this.cache.put(canonical, page);
        }
        if (canonical.equals(this.requestGlobals.getActivePageName())) {
            this.requestGlobals.getRequest().setAttribute("tapestry.active-page-loaded", (Object)true);
        }
        return page;
    }

    private List<String> listen(List<String> resources) {
        for (String resource : resources) {
            if (!this.resolver.isPage(resource)) continue;
            String canonicalName = this.resolver.canonicalizePageName(this.resolver.getLogicalName(resource));
            this.cache.remove(canonicalName);
        }
        return Collections.emptyList();
    }
}

