/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.services.javascript;

import org.apache.tapestry5.services.javascript.JavaScriptAggregationStrategy;
import org.apache.tapestry5.services.javascript.StackExtensionType;

public class StackExtension {
    public final StackExtensionType type;
    public final String value;

    public StackExtension(StackExtensionType type, String value) {
        this.type = type;
        this.value = value;
    }

    public String toString() {
        return String.format("StackExtension[%s %s]", this.type.name(), this.value);
    }

    public static StackExtension library(String path) {
        return new StackExtension(StackExtensionType.LIBRARY, path);
    }

    public static StackExtension module(String name) {
        return new StackExtension(StackExtensionType.MODULE, name);
    }

    public static StackExtension stylesheet(String path) {
        return new StackExtension(StackExtensionType.STYLESHEET, path);
    }

    public static StackExtension stack(String name) {
        return new StackExtension(StackExtensionType.STACK, name);
    }

    public static StackExtension javascriptAggregation(JavaScriptAggregationStrategy strategy) {
        return new StackExtension(StackExtensionType.AGGREGATION_STRATEGY, strategy.name());
    }
}

