/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Map;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.commons.Location;
import org.apache.tapestry5.commons.internal.services.StringInterner;
import org.apache.tapestry5.commons.internal.util.TapestryException;
import org.apache.tapestry5.commons.util.ExceptionUtils;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.BindingFactory;
import org.apache.tapestry5.services.BindingSource;

public class BindingSourceImpl
implements BindingSource {
    private final Map<String, BindingFactory> factories;
    private final StringInterner interner;

    public BindingSourceImpl(Map<String, BindingFactory> factories, StringInterner interner) {
        this.factories = factories;
        this.interner = interner;
    }

    @Override
    public Binding newBinding(String description, ComponentResources container, String defaultPrefix, String expression) {
        return this.newBinding(description, container, container, defaultPrefix, expression, null);
    }

    @Override
    public Binding newBinding(String description, ComponentResources container, ComponentResources component, String defaultPrefix, String expression, Location location) {
        String prefix;
        assert (InternalUtils.isNonBlank((String)description));
        assert (container != null);
        assert (InternalUtils.isNonBlank((String)defaultPrefix));
        assert (component != null);
        String subexpression = expression;
        int colonx = expression.indexOf(58);
        BindingFactory factory = null;
        if (colonx > 0 && (factory = this.factories.get(prefix = expression.substring(0, colonx))) != null) {
            subexpression = expression.substring(colonx + 1);
        }
        if (factory == null) {
            factory = this.factories.get(defaultPrefix);
        }
        try {
            return factory.newBinding(this.interner.intern(description), container, component, subexpression, location);
        }
        catch (Exception ex) {
            throw new TapestryException(String.format("Could not convert '%s' into a component parameter binding: %s", expression, ExceptionUtils.toMessage((Throwable)ex)), location, (Throwable)ex);
        }
    }
}

