/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import java.lang.annotation.Annotation;
import java.util.Collection;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.func.Worker;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.MethodHandle;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.runtime.PageLifecycleListener;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class PageLifecycleAnnotationWorker
implements ComponentClassTransformWorker2 {
    private final Class<? extends Annotation> methodAnnotationClass;
    private final MethodDescription lifecycleMethodDescription;
    private final String methodAlias;
    private final Predicate<PlasticMethod> MATCHER = new Predicate<PlasticMethod>(){

        public boolean accept(PlasticMethod method) {
            return method.getDescription().methodName.equalsIgnoreCase(PageLifecycleAnnotationWorker.this.methodAlias) || method.hasAnnotation(PageLifecycleAnnotationWorker.this.methodAnnotationClass);
        }
    };
    private final Worker<PlasticMethod> VALIDATE = new Worker<PlasticMethod>(){

        public void work(PlasticMethod method) {
            if (!method.isVoid()) {
                throw new RuntimeException(String.format("Method %s is a lifecycle method and should return void.", method.getMethodIdentifier()));
            }
            if (!method.getParameters().isEmpty()) {
                throw new RuntimeException(String.format("Method %s is a lifecycle method and should take no parameters.", method.getMethodIdentifier()));
            }
        }
    };

    public PageLifecycleAnnotationWorker(Class<? extends Annotation> methodAnnotationClass, MethodDescription lifecycleMethodDescription, String methodAlias) {
        this.methodAnnotationClass = methodAnnotationClass;
        this.lifecycleMethodDescription = lifecycleMethodDescription;
        this.methodAlias = methodAlias;
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        Flow<PlasticMethod> methods = this.matchLifecycleMethods(plasticClass);
        if (methods.isEmpty()) {
            return;
        }
        plasticClass.introduceInterface(PageLifecycleListener.class);
        for (PlasticMethod method : methods) {
            this.invokeMethodWithinLifecycle(plasticClass, method);
        }
    }

    private void invokeMethodWithinLifecycle(PlasticClass plasticClass, PlasticMethod method) {
        MethodHandle handle = method.getHandle();
        plasticClass.introduceMethod(this.lifecycleMethodDescription).addAdvice(this.createAdvice(handle));
    }

    private MethodAdvice createAdvice(final MethodHandle handle) {
        return new MethodAdvice(){

            public void advise(MethodInvocation invocation) {
                invocation.proceed();
                handle.invoke(invocation.getInstance(), new Object[0]).rethrow();
            }
        };
    }

    private Flow<PlasticMethod> matchLifecycleMethods(PlasticClass plasticClass) {
        return (Flow)((Flow)F.flow((Collection)plasticClass.getMethods()).filter(this.MATCHER)).each(this.VALIDATE);
    }
}

