/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.rest.jackson.internal;

import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.tapestry5.commons.internal.util.TapestryException;
import org.apache.tapestry5.http.services.HttpRequestBodyConverter;
import org.apache.tapestry5.jacksondatabind.services.ObjectMapperSource;
import org.apache.tapestry5.services.rest.MappedEntityManager;

public class JacksonHttpRequestBodyConverter
implements HttpRequestBodyConverter {
    private final Set<Class<?>> entities;
    private final ObjectMapperSource objectMapperSource;

    public JacksonHttpRequestBodyConverter(MappedEntityManager mappedEntityManager, ObjectMapperSource objectMapperSource) {
        this.entities = mappedEntityManager.getEntities();
        this.objectMapperSource = objectMapperSource;
    }

    public <T> T convert(HttpServletRequest request, Class<T> type) {
        Object value = null;
        if (this.entities.contains(type)) {
            try {
                value = this.objectMapperSource.get(type).readValue((Reader)request.getReader(), type);
            }
            catch (IOException e) {
                throw new TapestryException("Exception while converting HTTP request body into " + type.getName(), (Throwable)e);
            }
        }
        return (T)value;
    }
}

