/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.Binding;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.BeginRender;
import org.apache.tapestry5.annotations.Mixin;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.corelib.base.AbstractField;
import org.apache.tapestry5.corelib.mixins.RenderDisabled;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.compatibility.Compatibility;
import org.apache.tapestry5.services.compatibility.Trait;

public class Checkbox
extends AbstractField {
    @Parameter(required=true, autoconnect=true)
    private boolean value;
    @Parameter(defaultPrefix="validate", allowNull=false)
    private FieldValidator<Object> validate;
    @Mixin
    private RenderDisabled renderDisabled;
    @Inject
    private Compatibility compatibility;
    private boolean bootstrap4;

    void pageLoaded() {
        this.bootstrap4 = this.compatibility.enabled(Trait.BOOTSTRAP_4);
    }

    @BeginRender
    void begin(MarkupWriter writer) {
        String asSubmitted = this.validationTracker.getInput(this);
        boolean checked = asSubmitted != null ? Boolean.parseBoolean(asSubmitted) : this.value;
        writer.element("input", "type", "checkbox", "name", this.getControlName(), "id", this.getClientId(), "checked", checked ? "checked" : null);
        this.putPropertyNameIntoBeanValidationContext("value");
        this.validate.render(writer);
        this.removePropertyNameFromBeanValidationContext();
        this.resources.renderInformalParameters(writer);
        if (this.bootstrap4) {
            Element element = writer.getElement();
            String classAttribute = element.getAttribute("class");
            classAttribute = classAttribute != null ? "form-check-input " + classAttribute : "form-check-input";
            element.forceAttributes("class", classAttribute);
        }
        this.decorateInsideField();
    }

    @AfterRender
    void after(MarkupWriter writer) {
        writer.end();
    }

    @Override
    protected void processSubmission(String controlName) {
        String postedValue = this.request.getParameter(controlName);
        boolean translated = postedValue != null;
        this.validationTracker.recordInput(this, Boolean.toString(translated));
        this.putPropertyNameIntoBeanValidationContext("value");
        try {
            this.fieldValidationSupport.validate(translated, this.resources, this.validate);
            this.value = translated;
        }
        catch (ValidationException ex) {
            this.validationTracker.recordError(this, ex.getMessage());
        }
        this.removePropertyNameFromBeanValidationContext();
    }

    final Binding defaultValidate() {
        return this.defaultProvider.defaultValidatorBinding("value", this.resources);
    }
}

