/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.UnknownActivationContextCheck;
import org.apache.tapestry5.annotations.WhitelistAccessOnly;
import org.apache.tapestry5.internal.plastic.PlasticClassLoader;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.pageload.PageClassLoaderContext;
import org.apache.tapestry5.services.pageload.PageClassLoaderContextManager;

@UnknownActivationContextCheck(value=false)
@WhitelistAccessOnly
public class PageClassLoaderContexts {
    @Inject
    private PageClassLoaderContextManager pageClassLoaderContextManager;

    void onRender(MarkupWriter writer) {
        PageClassLoaderContext root = this.pageClassLoaderContextManager.getRoot();
        this.render(root, writer);
    }

    private void render(PageClassLoaderContext context, MarkupWriter writer) {
        int classes = context.getClassNames().size();
        writer.element("li", new Object[0]);
        writer.element("details", new Object[0]);
        writer.element("summary", new Object[0]);
        writer.element("span", "class", "glyphicon glyphicon-zoom-in");
        writer.end();
        writer.write(context.getName());
        writer.write(" (");
        writer.write(((PlasticClassLoader)context.getClassLoader()).getClassLoaderId());
        writer.write(", ");
        writer.write(String.valueOf(classes));
        if (classes > 1) {
            writer.write(" classes)");
        } else {
            writer.write(" class)");
        }
        writer.end();
        if (!context.isRoot() && !context.getClassNames().isEmpty()) {
            ArrayList<String> classNames = new ArrayList<String>(context.getClassNames());
            Collections.sort(classNames);
            writer.element("ul", new Object[0]);
            for (String className : classNames) {
                writer.element("li", new Object[0]).text(className);
                writer.end();
            }
            writer.end();
        }
        writer.end();
        ArrayList<PageClassLoaderContext> children = new ArrayList<PageClassLoaderContext>(context.getChildren());
        if (!children.isEmpty()) {
            children.sort(Comparator.comparing(PageClassLoaderContext::getName));
            writer.element("ul", new Object[0]);
            for (PageClassLoaderContext child : children) {
                writer.element("li", new Object[0]);
                this.render(child, writer);
                writer.end();
            }
            writer.end();
        }
        writer.end();
    }
}

