/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.Translator;
import org.apache.tapestry5.commons.util.AvailableValues;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.commons.util.StrategyRegistry;
import org.apache.tapestry5.commons.util.UnknownValueException;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.services.TranslatorSource;

public class TranslatorSourceImpl
implements TranslatorSource,
Runnable {
    private final Map<String, Translator> nameToTranslator = CollectionFactory.newCaseInsensitiveMap();
    private final StrategyRegistry<Translator> registry;
    private static final Map<String, Translator> EMPTY = Collections.emptyMap();

    public TranslatorSourceImpl(Map<Class, Translator> configuration) {
        this(configuration, EMPTY);
    }

    public TranslatorSourceImpl(Map<Class, Translator> configuration, Map<String, Translator> alternates) {
        for (Map.Entry<Class, Translator> me : configuration.entrySet()) {
            Translator translator;
            Class type = me.getKey();
            if (!type.equals((translator = me.getValue()).getType())) {
                throw new RuntimeException(String.format("Contributed translator for type %s reports its type as %s. Please change the contribution so that the key matches that translator type.", type.getName(), translator.getType().getName()));
            }
            String name = translator.getName();
            if (this.nameToTranslator.containsKey(name)) {
                throw new RuntimeException(String.format("Two different Translators contributed to the TranslatorSource service use the same translator name: '%s'.  Translator names must be unique.", name));
            }
            this.nameToTranslator.put(name, translator);
        }
        for (String name : alternates.keySet()) {
            if (this.nameToTranslator.containsKey(name)) {
                throw new RuntimeException(String.format("Translator '%s' contributed to the TranslatorAlternatesSource service has the same name as a standard Translator contributed to the TranslatorSource service.", name));
            }
            this.nameToTranslator.put(name, alternates.get(name));
        }
        this.registry = StrategyRegistry.newInstance(Translator.class, configuration, (boolean)true);
    }

    @Override
    public Translator get(String name) {
        Translator result = this.nameToTranslator.get(name);
        if (result == null) {
            throw new UnknownValueException(String.format("Unknown translator type '%s'.", name), new AvailableValues("Configured translators", this.nameToTranslator));
        }
        return result;
    }

    @Override
    public Translator getByType(Class valueType) {
        Translator result = (Translator)this.registry.get(valueType);
        if (result == null) {
            List names = CollectionFactory.newList();
            for (Class type : this.registry.getTypes()) {
                names.add(type.getName());
            }
            throw new IllegalArgumentException(String.format("No translator is defined for type %s.  Registered types: %s.", PlasticUtils.toTypeName((Class)valueType), InternalUtils.joinSorted((Collection)names)));
        }
        return result;
    }

    @Override
    public Translator findByType(Class valueType) {
        return (Translator)this.registry.get(valueType);
    }

    @Override
    public void run() {
        this.registry.clearCache();
    }
}

