/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.http.internal.services;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.http.internal.services.TapestrySessionFactory;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.http.services.Session;

public class RequestImpl
implements Request {
    static final String REQUESTED_WITH_HEADER = "X-Requested-With";
    static final String XML_HTTP_REQUEST = "XMLHttpRequest";
    static final String X_FORWARDED_PROTO_HEADER = "X-Forwarded-Proto";
    static final String X_FORWARDED_PROTO_HTTPS = "https";
    private final HttpServletRequest request;
    private final String applicationCharset;
    private final TapestrySessionFactory sessionFactory;
    private boolean encodingSet;
    private Session session;

    public RequestImpl(HttpServletRequest request, String applicationCharset, TapestrySessionFactory sessionFactory) {
        this.request = request;
        this.applicationCharset = applicationCharset;
        this.sessionFactory = sessionFactory;
    }

    @Override
    public List<String> getParameterNames() {
        this.setupEncoding();
        return RequestImpl.toList(this.request.getParameterNames());
    }

    @Override
    public List<String> getHeaderNames() {
        return RequestImpl.toList(this.request.getHeaderNames());
    }

    @Override
    public String getParameter(String name) {
        this.setupEncoding();
        return this.request.getParameter(name);
    }

    @Override
    public String[] getParameters(String name) {
        this.setupEncoding();
        return this.request.getParameterValues(name);
    }

    @Override
    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    @Override
    public String getPath() {
        String pathInfo = this.request.getPathInfo();
        if (pathInfo == null) {
            return this.request.getServletPath();
        }
        return pathInfo.length() == 0 ? "/" : pathInfo;
    }

    @Override
    public String getContextPath() {
        return this.request.getContextPath();
    }

    @Override
    public boolean isSessionInvalidated() {
        if (this.session == null) {
            this.session = this.sessionFactory.getSession(false);
        }
        return this.session != null && this.session.isInvalidated();
    }

    @Override
    public Session getSession(boolean create) {
        if (this.session != null && this.session.isInvalidated()) {
            this.session = null;
        }
        if (this.session == null) {
            this.session = this.sessionFactory.getSession(create);
        }
        return this.session;
    }

    @Override
    public Locale getLocale() {
        return this.request.getLocale();
    }

    @Override
    public long getDateHeader(String name) {
        return this.request.getDateHeader(name);
    }

    private void setupEncoding() {
        if (this.encodingSet) {
            return;
        }
        String requestEncoding = this.request.getCharacterEncoding();
        try {
            this.request.setCharacterEncoding(requestEncoding != null ? requestEncoding : this.applicationCharset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        this.encodingSet = true;
    }

    @Override
    public boolean isXHR() {
        return XML_HTTP_REQUEST.equals(this.request.getHeader(REQUESTED_WITH_HEADER));
    }

    @Override
    public boolean isSecure() {
        return this.request.isSecure() || X_FORWARDED_PROTO_HTTPS.equals(this.request.getHeader(X_FORWARDED_PROTO_HEADER));
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    @Override
    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    @Override
    public List<String> getAttributeNames() {
        this.setupEncoding();
        return RequestImpl.toList(this.request.getAttributeNames());
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getServerName() {
        return this.request.getServerName();
    }

    @Override
    public int getLocalPort() {
        return this.request.getLocalPort();
    }

    @Override
    public int getServerPort() {
        return this.request.getServerPort();
    }

    @Override
    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    private static List<String> toList(Enumeration e) {
        List result = CollectionFactory.newList();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            result.add(name);
        }
        Collections.sort(result);
        return result;
    }
}

