/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect.zip;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.tika.detect.zip.StreamingDetectContext;
import org.apache.tika.detect.zip.ZipContainerDetector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.mime.MediaType;

public class JarDetector
implements ZipContainerDetector {
    private static SeenManifest SEEN_MANIFEST = new SeenManifest();

    @Override
    public MediaType detect(ZipFile zip, TikaInputStream tis) throws IOException {
        if (zip.getEntry("META-INF/MANIFEST.MF") != null) {
            if (zip.getEntry("AndroidManifest.xml") != null) {
                return MediaType.application("vnd.android.package-archive");
            }
            if (zip.getEntry("WEB-INF/") != null) {
                return MediaType.application("x-tika-java-web-archive");
            }
            if (zip.getEntry("META-INF/application.xml") != null) {
                return MediaType.application("x-tika-java-enterprise-archive");
            }
            return MediaType.application("java-archive");
        }
        if (zip.getEntry("AndroidManifest.xml") != null) {
            return MediaType.application("vnd.android.package-archive");
        }
        return null;
    }

    @Override
    public MediaType streamingDetectUpdate(ZipArchiveEntry zae, InputStream zis, StreamingDetectContext detectContext) {
        SeenManifest seenManifest;
        String name = zae.getName();
        if (name.equals("AndroidManifest.xml")) {
            return MediaType.application("vnd.android.package-archive");
        }
        if (name.equals("META-INF/MANIFEST.MF")) {
            detectContext.set(SeenManifest.class, SEEN_MANIFEST);
        }
        if ((seenManifest = detectContext.get(SeenManifest.class)) != null) {
            if (name.equals("AndroidManifest.xml")) {
                return MediaType.application("vnd.android.package-archive");
            }
            if (name.equals("WEB-INF/")) {
                return MediaType.application("x-tika-java-web-archive");
            }
            if (name.equals("META-INF/application.xml")) {
                return MediaType.application("x-tika-java-enterprise-archive");
            }
        }
        return null;
    }

    @Override
    public MediaType streamingDetectFinal(StreamingDetectContext detectContext) {
        if (detectContext.get(SeenManifest.class) != null) {
            return MediaType.application("java-archive");
        }
        return null;
    }

    private static class SeenManifest {
        private SeenManifest() {
        }
    }
}

