/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.TikaMemoryLimitException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.image.ICNSType;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ICNSParser
implements Parser {
    public static final String ICNS_MIME_TYPE = "image/icns";
    private static final long serialVersionUID = 922010233654248327L;
    private static final long MAX_IMAGE_LENGTH_BYTES = 0xA00000L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.image("icns"));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        int icon_length;
        byte[] header = new byte[4];
        IOUtils.read(stream, header, 0, 4);
        if (header[0] != 105 || header[1] != 99 || header[2] != 110 || header[3] != 115) {
            throw new TikaException("ICNS magic signature invalid");
        }
        IOUtils.read(stream, header, 0, 4);
        int image_length = ByteBuffer.wrap(header).getInt();
        if ((long)(image_length -= 8) > 0xA00000L) {
            throw new TikaMemoryLimitException(image_length, 0xA00000L);
        }
        if (image_length < 0) {
            throw new TikaException("image length must be >= 0");
        }
        byte[] full_file = new byte[image_length];
        IOUtils.readFully(stream, full_file);
        ArrayList<ICNSType> icons = new ArrayList<ICNSType>();
        ArrayList<ICNSType> icon_masks = new ArrayList<ICNSType>();
        byte[] tempByteArray = new byte[4];
        for (int offset = 0; offset < image_length - 8; offset += icon_length) {
            tempByteArray[0] = full_file[offset];
            tempByteArray[1] = full_file[offset + 1];
            tempByteArray[2] = full_file[offset + 2];
            tempByteArray[3] = full_file[offset + 3];
            ICNSType icnstype = ICNSType.findIconType(tempByteArray);
            if (icnstype == null) break;
            if (icnstype.hasMask()) {
                icon_masks.add(ICNSType.findIconType(tempByteArray));
            } else {
                icons.add(ICNSType.findIconType(tempByteArray));
            }
            tempByteArray[0] = full_file[offset + 4];
            tempByteArray[1] = full_file[offset + 5];
            tempByteArray[2] = full_file[offset + 6];
            tempByteArray[3] = full_file[offset + 7];
            icon_length = ByteBuffer.wrap(tempByteArray).getInt();
            if (icon_length <= 0) break;
        }
        StringBuilder icon_details = new StringBuilder();
        StringBuilder iconmask_details = new StringBuilder();
        for (ICNSType icon : icons) {
            String bitsPerPixel = icon.getBitsPerPixel() != 0 ? icon.getBitsPerPixel() + " bpp" : "JPEG 2000 or PNG format";
            String dimensions = !icon.hasRetinaDisplay() ? icon.getHeight() + "x" + icon.getWidth() : icon.getHeight() + "x" + icon.getWidth() + "@2X";
            icon_details.append(", ").append(dimensions).append(" (").append(bitsPerPixel).append(")");
        }
        for (ICNSType icon : icon_masks) {
            iconmask_details.append(", ").append(icon.getHeight()).append("x").append(icon.getWidth()).append(" (").append(icon.getBitsPerPixel()).append(" bpp").append(")");
        }
        metadata.set("Content-Type", ICNS_MIME_TYPE);
        if (!icon_details.toString().equals("")) {
            metadata.set("Icon count", String.valueOf(icons.size()));
            icon_details = new StringBuilder(icon_details.substring(2));
            metadata.set("Icon details", icon_details.toString());
        }
        if (!iconmask_details.toString().equals("")) {
            metadata.set("Masked icon count", String.valueOf(icon_masks.size()));
            iconmask_details = new StringBuilder(iconmask_details.substring(2));
            metadata.set("Masked icon details", iconmask_details.toString());
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.endDocument();
    }
}

