/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.pst;

import com.pff.PSTAttachment;
import com.pff.PSTException;
import com.pff.PSTMessage;
import com.pff.PSTRecipient;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Message;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.PST;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.html.JSoupParser;
import org.apache.tika.parser.microsoft.OutlookExtractor;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PSTMailItemParser
implements Parser {
    public static final MediaType PST_MAIL_ITEM = MediaType.application("x-tika-pst-mail-item");
    public static final String PST_MAIL_ITEM_STRING = PST_MAIL_ITEM.toString();
    public static final Set<MediaType> SUPPORTED_ITEMS = Set.of(PST_MAIL_ITEM);

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_ITEMS;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        TikaInputStream tis = TikaInputStream.cast(stream);
        if (tis == null) {
            throw new TikaException("Stream must be a TikaInputStream");
        }
        Object openContainerObj = tis.getOpenContainer();
        if (openContainerObj == null) {
            throw new TikaException("Open container must not be null.");
        }
        if (!(openContainerObj instanceof PSTMessage)) {
            throw new TikaException("Open container must be a PSTMessage");
        }
        PSTMessage pstMsg = (PSTMessage)openContainerObj;
        EmbeddedDocumentExtractor ex = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(context);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        this.parseMailAndAttachments(pstMsg, xhtml, metadata, context, ex);
        xhtml.endDocument();
    }

    private void parseMailAndAttachments(PSTMessage pstMsg, XHTMLContentHandler handler, Metadata metadata, ParseContext context, EmbeddedDocumentExtractor embeddedExtractor) throws SAXException, IOException, TikaException {
        this.extractMetadata(pstMsg, metadata);
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "class", "class", "CDATA", "embedded");
        attributes.addAttribute("", "id", "id", "CDATA", pstMsg.getInternetMessageId());
        handler.startElement("div", attributes);
        this.parseMailItem(pstMsg, handler, metadata, context);
        this.parseMailAttachments(pstMsg, handler, metadata, context, embeddedExtractor);
        handler.endElement("div");
    }

    private void parseMailItem(PSTMessage pstMail, XHTMLContentHandler xhtml, Metadata metadata, ParseContext context) throws SAXException, IOException, TikaException {
        String htmlChunk = pstMail.getBodyHTML();
        if (!StringUtils.isBlank(htmlChunk)) {
            Parser htmlParser = EmbeddedDocumentUtil.tryToFindExistingLeafParser(JSoupParser.class, context);
            if (htmlParser == null) {
                htmlParser = new JSoupParser();
            }
            if (htmlParser instanceof JSoupParser) {
                ((JSoupParser)htmlParser).parseString(htmlChunk, new EmbeddedContentHandler(new BodyContentHandler(xhtml)), metadata, context);
            } else {
                byte[] data = htmlChunk.getBytes(StandardCharsets.UTF_8);
                htmlParser.parse(UnsynchronizedByteArrayInputStream.builder().setByteArray(data).get(), new EmbeddedContentHandler(new BodyContentHandler(xhtml)), new Metadata(), context);
            }
            return;
        }
        String mailContent = pstMail.getBody();
        xhtml.startElement("p");
        xhtml.characters(mailContent);
        xhtml.endElement("p");
    }

    private void extractMetadata(PSTMessage pstMail, Metadata metadata) {
        metadata.set("resourceName", pstMail.getSubject() + ".msg");
        metadata.set("embeddedRelationshipId", pstMail.getInternetMessageId());
        metadata.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.ATTACHMENT.name());
        metadata.set(TikaCoreProperties.IDENTIFIER, pstMail.getInternetMessageId());
        metadata.set(TikaCoreProperties.TITLE, pstMail.getSubject());
        metadata.set(TikaCoreProperties.SUBJECT, pstMail.getSubject());
        metadata.set("Message-From", pstMail.getSenderName());
        metadata.set(TikaCoreProperties.CREATOR, pstMail.getSenderName());
        metadata.set(TikaCoreProperties.CREATED, pstMail.getCreationTime());
        metadata.set(Office.MAPI_MESSAGE_CLIENT_SUBMIT_TIME, pstMail.getClientSubmitTime());
        metadata.set(TikaCoreProperties.MODIFIED, pstMail.getLastModificationTime());
        metadata.set(TikaCoreProperties.COMMENTS, pstMail.getComment());
        metadata.set(PST.DESCRIPTOR_NODE_ID, String.valueOf(pstMail.getDescriptorNodeId()));
        metadata.set(Message.MESSAGE_FROM_EMAIL, pstMail.getSenderEmailAddress());
        if (!StringUtils.isBlank(pstMail.getRecipientsString()) && !pstMail.getRecipientsString().equals("No recipients table!")) {
            metadata.set(Office.MAPI_RECIPIENTS_STRING, pstMail.getRecipientsString());
        }
        metadata.set(Message.MESSAGE_TO_DISPLAY_NAME, pstMail.getDisplayTo());
        metadata.set(Message.MESSAGE_CC_DISPLAY_NAME, pstMail.getDisplayCC());
        metadata.set(Message.MESSAGE_BCC_DISPLAY_NAME, pstMail.getDisplayBCC());
        metadata.set(Office.MAPI_IMPORTANCE, pstMail.getImportance());
        metadata.set(Office.MAPI_PRIORTY, pstMail.getPriority());
        metadata.set(Office.MAPI_IS_FLAGGED, pstMail.isFlagged());
        metadata.set(Office.MAPI_MESSAGE_CLASS, OutlookExtractor.getNormalizedMessageClass(pstMail.getMessageClass()));
        metadata.set(Message.MESSAGE_FROM_EMAIL, pstMail.getSenderEmailAddress());
        metadata.set(Office.MAPI_FROM_REPRESENTING_EMAIL, pstMail.getSentRepresentingEmailAddress());
        metadata.set(Message.MESSAGE_FROM_NAME, pstMail.getSenderName());
        metadata.set(Office.MAPI_FROM_REPRESENTING_NAME, pstMail.getSentRepresentingName());
        try {
            block7: for (int i = 0; i < pstMail.getNumberOfRecipients(); ++i) {
                PSTRecipient recipient = pstMail.getRecipient(i);
                switch (OutlookExtractor.RECIPIENT_TYPE.getTypeFromVal(recipient.getRecipientType())) {
                    case TO: {
                        OutlookExtractor.addEvenIfNull(Message.MESSAGE_TO_DISPLAY_NAME, recipient.getDisplayName(), metadata);
                        OutlookExtractor.addEvenIfNull(Message.MESSAGE_TO_EMAIL, recipient.getEmailAddress(), metadata);
                        continue block7;
                    }
                    case CC: {
                        OutlookExtractor.addEvenIfNull(Message.MESSAGE_CC_DISPLAY_NAME, recipient.getDisplayName(), metadata);
                        OutlookExtractor.addEvenIfNull(Message.MESSAGE_CC_EMAIL, recipient.getEmailAddress(), metadata);
                        continue block7;
                    }
                    case BCC: {
                        OutlookExtractor.addEvenIfNull(Message.MESSAGE_BCC_DISPLAY_NAME, recipient.getDisplayName(), metadata);
                        OutlookExtractor.addEvenIfNull(Message.MESSAGE_BCC_EMAIL, recipient.getEmailAddress(), metadata);
                        continue block7;
                    }
                }
            }
        }
        catch (PSTException | IOException exception) {
            // empty catch block
        }
    }

    private void parseMailAttachments(PSTMessage email, XHTMLContentHandler xhtml, Metadata metadata, ParseContext context, EmbeddedDocumentExtractor embeddedExtractor) throws TikaException {
        int numberOfAttachments = email.getNumberOfAttachments();
        for (int i = 0; i < numberOfAttachments; ++i) {
            try {
                PSTAttachment attachment = email.getAttachment(i);
                this.parseMailAttachment(xhtml, attachment, metadata, embeddedExtractor);
                continue;
            }
            catch (Exception e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException(e, metadata);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMailAttachment(XHTMLContentHandler xhtml, PSTAttachment attachment, Metadata metadata, EmbeddedDocumentExtractor embeddedExtractor) throws PSTException, IOException, TikaException, SAXException {
        PSTMessage attachedEmail = attachment.getEmbeddedPSTMessage();
        if (attachedEmail != null) {
            try (TikaInputStream tis = TikaInputStream.get(new byte[0]);){
                tis.setOpenContainer(attachedEmail);
                Metadata attachMetadata = new Metadata();
                attachMetadata.set(TikaCoreProperties.CONTENT_TYPE_PARSER_OVERRIDE, PST_MAIL_ITEM_STRING);
                attachMetadata.set("resourceName", attachedEmail.getSubject() + ".msg");
                attachMetadata.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.ATTACHMENT.name());
                embeddedExtractor.parseEmbedded(tis, xhtml, attachMetadata, true);
            }
            return;
        }
        String filename = attachment.getLongFilename();
        if (filename.isEmpty()) {
            filename = attachment.getFilename();
        }
        xhtml.element("p", filename);
        Metadata attachMeta = new Metadata();
        attachMeta.set("resourceName", filename);
        attachMeta.set("embeddedRelationshipId", filename);
        attachMeta.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.ATTACHMENT.toString());
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "class", "class", "CDATA", "embedded");
        attributes.addAttribute("", "id", "id", "CDATA", filename);
        xhtml.startElement("div", attributes);
        if (embeddedExtractor.shouldParseEmbedded(attachMeta)) {
            TikaInputStream tis = null;
            try {
                tis = TikaInputStream.get(attachment.getFileInputStream());
            }
            catch (NullPointerException e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException(e, metadata);
                return;
            }
            try {
                embeddedExtractor.parseEmbedded(tis, xhtml, attachMeta, false);
            }
            finally {
                tis.close();
            }
        }
        xhtml.endElement("div");
    }
}

