/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.io.RandomAccessStreamCache;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.fixup.AbstractFixup;
import org.apache.pdfbox.pdmodel.fixup.processor.AcroFormDefaultsProcessor;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.AccessPermissions;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.PDF;
import org.apache.tika.metadata.PagedText;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.RenderingParser;
import org.apache.tika.parser.pdf.AccessChecker;
import org.apache.tika.parser.pdf.OCR2XHTML;
import org.apache.tika.parser.pdf.OCRPageCounter;
import org.apache.tika.parser.pdf.PDF2XHTML;
import org.apache.tika.parser.pdf.PDFMarkedContent2XHTML;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.parser.pdf.PDMetadataExtractor;
import org.apache.tika.parser.pdf.XFAExtractor;
import org.apache.tika.parser.pdf.image.ImageGraphicsEngineFactory;
import org.apache.tika.parser.pdf.updates.IncrementalUpdateRecord;
import org.apache.tika.parser.pdf.updates.IsIncrementalUpdate;
import org.apache.tika.parser.pdf.updates.StartXRefOffset;
import org.apache.tika.parser.pdf.updates.StartXRefScanner;
import org.apache.tika.parser.pdf.xmpschemas.XMPSchemaIllustrator;
import org.apache.tika.renderer.PageRangeRequest;
import org.apache.tika.renderer.RenderResult;
import org.apache.tika.renderer.RenderResults;
import org.apache.tika.renderer.Renderer;
import org.apache.tika.renderer.pdf.pdfbox.PDFBoxRenderer;
import org.apache.tika.renderer.pdf.pdfbox.PDFRenderingState;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PDFParser
implements Parser,
RenderingParser,
Initializable {
    public static final MediaType MEDIA_TYPE = MediaType.application("pdf");
    private static final long serialVersionUID = -752276948656079347L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MEDIA_TYPE);
    static COSName AF_RELATIONSHIP = COSName.getPDFName("AFRelationship");
    private static COSName ENCRYPTED_PAYLOAD = COSName.getPDFName("EncryptedPayload");
    private PDFParserConfig defaultConfig = new PDFParserConfig();

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        PDFParserConfig localConfig = this.defaultConfig;
        PDFParserConfig userConfig = context.get(PDFParserConfig.class);
        if (userConfig != null) {
            localConfig = this.defaultConfig.cloneAndUpdate(userConfig);
        }
        if (localConfig.isSetKCMS()) {
            System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
        }
        IncrementalUpdateRecord incomingIncrementalUpdateRecord = context.get(IncrementalUpdateRecord.class);
        context.set(IncrementalUpdateRecord.class, null);
        this.initRenderer(localConfig, context);
        PDDocument pdfDocument = null;
        String password = "";
        PDFRenderingState incomingRenderingState = context.get(PDFRenderingState.class);
        TikaInputStream tstream = null;
        boolean shouldClose = false;
        OCRPageCounter prevOCRCounter = context.get(OCRPageCounter.class);
        context.set(OCRPageCounter.class, new OCRPageCounter());
        try {
            if (this.shouldSpool(localConfig)) {
                if (stream instanceof TikaInputStream) {
                    tstream = (TikaInputStream)stream;
                } else {
                    tstream = TikaInputStream.get(CloseShieldInputStream.wrap(stream));
                    shouldClose = true;
                }
                context.set(PDFRenderingState.class, new PDFRenderingState(tstream));
            } else {
                tstream = TikaInputStream.cast(stream);
            }
            this.scanXRefOffsets(localConfig, tstream, metadata, context);
            password = this.getPassword(metadata, context);
            MemoryUsageSetting memoryUsageSetting = null;
            memoryUsageSetting = localConfig.getMaxMainMemoryBytes() >= 0L ? MemoryUsageSetting.setupMixed(localConfig.getMaxMainMemoryBytes()) : MemoryUsageSetting.setupMainMemoryOnly();
            pdfDocument = this.getPDDocument(stream, tstream, password, memoryUsageSetting.streamCache, metadata, context);
            boolean hasCollection = this.hasCollection(pdfDocument, metadata);
            this.checkEncryptedPayload(pdfDocument, hasCollection, localConfig);
            boolean hasXFA = this.hasXFA(pdfDocument, metadata);
            boolean hasMarkedContent = this.hasMarkedContent(pdfDocument, metadata);
            this.extractMetadata(pdfDocument, metadata, context);
            this.extractSignatures(pdfDocument, metadata);
            this.checkIllustrator(pdfDocument, metadata);
            AccessChecker checker = localConfig.getAccessChecker();
            checker.check(metadata);
            this.renderPagesBeforeParse(tstream, handler, metadata, context, localConfig);
            if (handler != null) {
                if (this.shouldHandleXFAOnly(hasXFA, localConfig)) {
                    this.handleXFAOnly(pdfDocument, handler, metadata, context);
                } else if (localConfig.getOcrStrategy().equals((Object)PDFParserConfig.OCR_STRATEGY.OCR_ONLY)) {
                    OCR2XHTML.process(pdfDocument, handler, context, metadata, localConfig);
                } else if (hasMarkedContent && localConfig.isExtractMarkedContent()) {
                    PDFMarkedContent2XHTML.process(pdfDocument, handler, context, metadata, localConfig);
                } else {
                    PDF2XHTML.process(pdfDocument, handler, context, metadata, localConfig);
                }
            }
        }
        catch (InvalidPasswordException e) {
            metadata.set(PDF.IS_ENCRYPTED, "true");
            throw new EncryptedDocumentException(e);
        }
        finally {
            metadata.set(PDF.OCR_PAGE_COUNT, context.get(OCRPageCounter.class).getCount());
            context.set(OCRPageCounter.class, prevOCRCounter);
            context.set(IncrementalUpdateRecord.class, incomingIncrementalUpdateRecord);
            PDFRenderingState currState = context.get(PDFRenderingState.class);
            try {
                if (currState != null && currState.getRenderResults() != null) {
                    currState.getRenderResults().close();
                }
                if (pdfDocument != null) {
                    pdfDocument.close();
                }
            }
            finally {
                context.set(PDFRenderingState.class, incomingRenderingState);
                if (shouldClose && tstream != null) {
                    tstream.close();
                }
            }
        }
    }

    private void checkEncryptedPayload(PDDocument pdfDocument, boolean hasCollection, PDFParserConfig localConfig) throws IOException, EncryptedDocumentException {
        if (!localConfig.isThrowOnEncryptedPayload()) {
            return;
        }
        if (!hasCollection) {
            return;
        }
        List<COSObject> fileSpecs = pdfDocument.getDocument().getObjectsByType(COSName.FILESPEC);
        for (COSObject obj : fileSpecs) {
            COSDictionary dict;
            COSBase relationship;
            if (!(obj.getObject() instanceof COSDictionary) || (relationship = (dict = (COSDictionary)obj.getObject()).getDictionaryObject(AF_RELATIONSHIP)) == null || !relationship.equals(ENCRYPTED_PAYLOAD)) continue;
            String name = "";
            COSBase uf = dict.getDictionaryObject(COSName.UF);
            COSBase f = dict.getDictionaryObject(COSName.F);
            if (uf != null && uf instanceof COSString) {
                name = ((COSString)uf).getString();
            } else if (f != null && f instanceof COSString) {
                name = ((COSString)f).getString();
            }
            throw new EncryptedDocumentException("PDF file contains an encrypted payload: '" + name + "'");
        }
    }

    private void scanXRefOffsets(PDFParserConfig localConfig, TikaInputStream tikaInputStream, Metadata metadata, ParseContext parseContext) {
        if (!localConfig.isParseIncrementalUpdates() && !localConfig.isExtractIncrementalUpdateInfo()) {
            return;
        }
        if (parseContext.get(IsIncrementalUpdate.class) != null) {
            parseContext.set(IsIncrementalUpdate.class, null);
            return;
        }
        ArrayList<StartXRefOffset> xRefOffsets = new ArrayList<StartXRefOffset>();
        try (RandomAccessReadBufferedFile ra2 = new RandomAccessReadBufferedFile(tikaInputStream.getFile());){
            StartXRefScanner xRefScanner = new StartXRefScanner(ra2);
            xRefOffsets.addAll(xRefScanner.scan());
        }
        catch (IOException ra2) {
            // empty catch block
        }
        int startXrefs = 0;
        for (StartXRefOffset offset : xRefOffsets) {
            if (offset.getStartxref() == 0L) continue;
            ++startXrefs;
            metadata.add(PDF.EOF_OFFSETS, Long.toString(offset.getEndEofOffset()));
        }
        if (startXrefs > 0) {
            --startXrefs;
        }
        metadata.set(PDF.PDF_INCREMENTAL_UPDATE_COUNT, startXrefs);
        if (localConfig.isParseIncrementalUpdates()) {
            try {
                parseContext.set(IncrementalUpdateRecord.class, new IncrementalUpdateRecord(tikaInputStream.getPath(), xRefOffsets));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void checkIllustrator(PDDocument pdfDocument, Metadata metadata) {
        PDPage page = null;
        try {
            page = pdfDocument.getPage(0);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            return;
        }
        COSDictionary pieceInfoDict = page.getCOSObject().getCOSDictionary(COSName.PIECE_INFO);
        if (pieceInfoDict == null) {
            return;
        }
        COSDictionary illustratorDict = pieceInfoDict.getCOSDictionary(COSName.ILLUSTRATOR);
        if (illustratorDict == null) {
            return;
        }
        COSDictionary privateDict = illustratorDict.getCOSDictionary(COSName.PRIVATE);
        if (privateDict == null) {
            return;
        }
        metadata.set("Content-Type", XMPSchemaIllustrator.ILLUSTRATOR);
    }

    private void extractSignatures(PDDocument pdfDocument, Metadata metadata) {
        boolean hasSignature = false;
        for (PDSignature signature : pdfDocument.getSignatureDictionaries()) {
            if (signature == null) continue;
            PDMetadataExtractor.addNotNull(signature.getName(), metadata, TikaCoreProperties.SIGNATURE_NAME);
            Calendar date = signature.getSignDate();
            if (date != null) {
                metadata.add(TikaCoreProperties.SIGNATURE_DATE, date);
            }
            PDMetadataExtractor.addNotNull(signature.getContactInfo(), metadata, TikaCoreProperties.SIGNATURE_CONTACT_INFO);
            PDMetadataExtractor.addNotNull(signature.getFilter(), metadata, TikaCoreProperties.SIGNATURE_FILTER);
            PDMetadataExtractor.addNotNull(signature.getLocation(), metadata, TikaCoreProperties.SIGNATURE_LOCATION);
            PDMetadataExtractor.addNotNull(signature.getReason(), metadata, TikaCoreProperties.SIGNATURE_REASON);
            hasSignature = true;
        }
        if (hasSignature) {
            metadata.set(TikaCoreProperties.HAS_SIGNATURE, hasSignature);
        }
    }

    private boolean shouldSpool(PDFParserConfig localConfig) {
        if (localConfig.getImageStrategy() == PDFParserConfig.IMAGE_STRATEGY.RENDER_PAGES_BEFORE_PARSE || localConfig.getImageStrategy() == PDFParserConfig.IMAGE_STRATEGY.RENDER_PAGES_AT_PAGE_END) {
            return true;
        }
        if (localConfig.isExtractIncrementalUpdateInfo() || localConfig.isParseIncrementalUpdates()) {
            return true;
        }
        return localConfig.getOcrStrategy() != PDFParserConfig.OCR_STRATEGY.NO_OCR;
    }

    private void renderPagesBeforeParse(TikaInputStream tstream, ContentHandler xhtml, Metadata parentMetadata, ParseContext context, PDFParserConfig config) {
        if (config.getImageStrategy() != PDFParserConfig.IMAGE_STRATEGY.RENDER_PAGES_BEFORE_PARSE) {
            return;
        }
        RenderResults renderResults = null;
        try {
            renderResults = this.renderPDF(tstream, context, config);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            EmbeddedDocumentUtil.recordException(e, parentMetadata);
            return;
        }
        context.get(PDFRenderingState.class).setRenderResults(renderResults);
        EmbeddedDocumentExtractor embeddedDocumentExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(context);
        for (RenderResult result : renderResults.getResults()) {
            if (result.getStatus() != RenderResult.STATUS.SUCCESS || !embeddedDocumentExtractor.shouldParseEmbedded(result.getMetadata())) continue;
            try {
                InputStream is = result.getInputStream();
                try {
                    embeddedDocumentExtractor.parseEmbedded(is, xhtml, result.getMetadata(), false);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (Exception e) {
                EmbeddedDocumentUtil.recordException(e, parentMetadata);
            }
        }
    }

    private RenderResults renderPDF(TikaInputStream tstream, ParseContext parseContext, PDFParserConfig localConfig) throws IOException, TikaException {
        Metadata metadata = new Metadata();
        metadata.set(TikaCoreProperties.TYPE, MEDIA_TYPE.toString());
        return localConfig.getRenderer().render(tstream, metadata, parseContext, PageRangeRequest.RENDER_ALL);
    }

    protected PDDocument getPDDocument(InputStream stream, TikaInputStream tstream, String password, RandomAccessStreamCache.StreamCacheCreateFunction streamCacheCreateFunction, Metadata metadata, ParseContext context) throws IOException, EncryptedDocumentException {
        try {
            PDDocument pdDocument = null;
            pdDocument = tstream != null && tstream.hasFile() ? this.getPDDocument(tstream.getPath(), password, streamCacheCreateFunction, metadata, context) : this.getPDDocument(CloseShieldInputStream.wrap(stream), password, streamCacheCreateFunction, metadata, context);
            if (tstream != null) {
                tstream.setOpenContainer(pdDocument);
            }
            return pdDocument;
        }
        catch (IOException e) {
            if (e.getMessage() != null && e.getMessage().contains("No security handler for filter")) {
                throw new EncryptedDocumentException(e);
            }
            throw e;
        }
    }

    protected PDDocument getPDDocument(InputStream inputStream, String password, RandomAccessStreamCache.StreamCacheCreateFunction streamCacheCreateFunction, Metadata metadata, ParseContext parseContext) throws IOException {
        return Loader.loadPDF(new RandomAccessReadBuffer(inputStream), password, streamCacheCreateFunction);
    }

    protected PDDocument getPDDocument(Path path, String password, RandomAccessStreamCache.StreamCacheCreateFunction streamCacheCreateFunction, Metadata metadata, ParseContext parseContext) throws IOException {
        return Loader.loadPDF(path.toFile(), password, streamCacheCreateFunction);
    }

    private boolean hasMarkedContent(PDDocument pdDocument, Metadata metadata) {
        boolean hasMarkedContent = this.hasMarkedContent(pdDocument);
        metadata.set(PDF.HAS_MARKED_CONTENT, hasMarkedContent);
        return hasMarkedContent;
    }

    private boolean hasMarkedContent(PDDocument pdDocument) {
        PDStructureTreeRoot root = pdDocument.getDocumentCatalog().getStructureTreeRoot();
        if (root == null) {
            return false;
        }
        COSBase base = root.getK();
        if (base == null) {
            return false;
        }
        return base instanceof COSDictionary ? ((COSDictionary)base).keySet().size() > 0 : base instanceof COSArray && ((COSArray)base).size() > 0;
    }

    private boolean hasCollection(PDDocument pdDocument, Metadata metadata) {
        boolean hasCollection = this.hasCollection(pdDocument);
        metadata.set(PDF.HAS_COLLECTION, hasCollection);
        return hasCollection;
    }

    private boolean hasCollection(PDDocument pdfDocument) {
        COSDictionary cosDict = pdfDocument.getDocumentCatalog().getCOSObject();
        return cosDict.containsKey(COSName.COLLECTION);
    }

    private String getPassword(Metadata metadata, ParseContext context) {
        String password = null;
        PasswordProvider passwordProvider = context.get(PasswordProvider.class);
        if (passwordProvider != null) {
            password = passwordProvider.getPassword(metadata);
        }
        if (password == null) {
            password = "";
        }
        return password;
    }

    private void extractMetadata(PDDocument document, Metadata metadata, ParseContext context) throws TikaException {
        metadata.set("Content-Type", MEDIA_TYPE.toString());
        AccessPermission ap = document.getCurrentAccessPermission();
        metadata.set(AccessPermissions.EXTRACT_FOR_ACCESSIBILITY, Boolean.toString(ap.canExtractForAccessibility()));
        metadata.set(AccessPermissions.EXTRACT_CONTENT, Boolean.toString(ap.canExtractContent()));
        metadata.set(AccessPermissions.ASSEMBLE_DOCUMENT, Boolean.toString(ap.canAssembleDocument()));
        metadata.set(AccessPermissions.FILL_IN_FORM, Boolean.toString(ap.canFillInForm()));
        metadata.set(AccessPermissions.CAN_MODIFY, Boolean.toString(ap.canModify()));
        metadata.set(AccessPermissions.CAN_MODIFY_ANNOTATIONS, Boolean.toString(ap.canModifyAnnotations()));
        metadata.set(AccessPermissions.CAN_PRINT, Boolean.toString(ap.canPrint()));
        metadata.set(AccessPermissions.CAN_PRINT_FAITHFUL, Boolean.toString(ap.canPrintFaithful()));
        metadata.set(PDF.IS_ENCRYPTED, Boolean.toString(document.isEncrypted()));
        if (document.getDocumentCatalog().getLanguage() != null) {
            metadata.set(TikaCoreProperties.LANGUAGE, document.getDocumentCatalog().getLanguage());
        }
        TikaAcroFormFixup fixup = new TikaAcroFormFixup(document);
        PDAcroForm acroForm = document.getDocumentCatalog().getAcroForm(fixup);
        if (acroForm != null && acroForm.getFields() != null && !acroForm.getFields().isEmpty()) {
            metadata.set(PDF.HAS_ACROFORM_FIELDS, "true");
        }
        PDMetadataExtractor.extract(document.getDocumentCatalog().getMetadata(), metadata, context);
        PDDocumentInformation info = document.getDocumentInformation();
        metadata.set(PagedText.N_PAGES, document.getNumberOfPages());
        PDMetadataExtractor.addMetadata(metadata, PDF.DOC_INFO_TITLE, info.getTitle());
        PDMetadataExtractor.addMetadata(metadata, PDF.DOC_INFO_CREATOR, info.getAuthor());
        if (metadata.get(TikaCoreProperties.CREATOR) == null) {
            PDMetadataExtractor.addMetadata(metadata, TikaCoreProperties.CREATOR, info.getAuthor());
        }
        if (metadata.get(TikaCoreProperties.TITLE) == null) {
            PDMetadataExtractor.addMetadata(metadata, TikaCoreProperties.TITLE, info.getTitle());
        }
        PDMetadataExtractor.addMetadata(metadata, PDF.DOC_INFO_CREATOR_TOOL, info.getCreator());
        PDMetadataExtractor.addMetadata(metadata, TikaCoreProperties.CREATOR_TOOL, info.getCreator());
        PDMetadataExtractor.addMetadata(metadata, PDF.DOC_INFO_KEY_WORDS, info.getKeywords());
        PDMetadataExtractor.addMetadata(metadata, PDF.DOC_INFO_PRODUCER, info.getProducer());
        PDMetadataExtractor.addMetadata(metadata, PDF.PRODUCER, info.getProducer());
        PDMetadataExtractor.addMetadata(metadata, PDF.DOC_INFO_SUBJECT, info.getSubject());
        PDMetadataExtractor.addMetadata(metadata, TikaCoreProperties.SUBJECT, info.getKeywords());
        PDMetadataExtractor.addMetadata(metadata, TikaCoreProperties.SUBJECT, info.getSubject());
        PDMetadataExtractor.addMetadata(metadata, PDF.DOC_INFO_TRAPPED, info.getTrapped());
        Calendar created = info.getCreationDate();
        PDMetadataExtractor.addMetadata(metadata, PDF.DOC_INFO_CREATED, created);
        PDMetadataExtractor.addMetadata(metadata, TikaCoreProperties.CREATED, created);
        Calendar modified = info.getModificationDate();
        PDMetadataExtractor.addMetadata(metadata, TikaCoreProperties.MODIFIED, modified);
        PDMetadataExtractor.addMetadata(metadata, PDF.DOC_INFO_MODIFICATION_DATE, modified);
        List<String> handledMetadata = Arrays.asList("Author", "Creator", "CreationDate", "ModDate", "Keywords", "Producer", "Subject", "Title", "Trapped");
        for (COSName key : info.getCOSObject().keySet()) {
            String name = key.getName();
            if (handledMetadata.contains(name)) continue;
            PDMetadataExtractor.addMetadata(metadata, name, info.getCOSObject().getDictionaryObject(key));
            PDMetadataExtractor.addMetadata(metadata, "pdf:docinfo:custom:" + name, info.getCOSObject().getDictionaryObject(key));
        }
        metadata.set(PDF.PDF_VERSION, Float.toString(document.getDocument().getVersion()));
        metadata.add(TikaCoreProperties.FORMAT.getName(), MEDIA_TYPE.toString() + "; version=" + Float.toString(document.getDocument().getVersion()));
        COSDictionary root = document.getDocumentCatalog().getCOSObject();
        COSDictionary extensions = (COSDictionary)root.getDictionaryObject(COSName.getPDFName("Extensions"));
        if (extensions != null) {
            for (COSName extName : extensions.keySet()) {
                if (extName.equals(COSName.getPDFName("ADBE"))) {
                    COSDictionary adobeExt = (COSDictionary)extensions.getDictionaryObject(extName);
                    if (adobeExt == null) continue;
                    String baseVersion = adobeExt.getNameAsString(COSName.getPDFName("BaseVersion"));
                    int el = adobeExt.getInt(COSName.getPDFName("ExtensionLevel"));
                    if (el == -1) continue;
                    metadata.set(PDF.PDF_EXTENSION_VERSION, baseVersion + " Adobe Extension Level " + el);
                    metadata.add(TikaCoreProperties.FORMAT.getName(), MEDIA_TYPE.toString() + "; version=\"" + baseVersion + " Adobe Extension Level " + el + "\"");
                    continue;
                }
                metadata.set("pdf:foundNonAdobeExtensionName", extName.getName());
            }
        }
    }

    private boolean hasXFA(PDDocument pdDocument, Metadata metadata) {
        boolean hasXFA = pdDocument.getDocumentCatalog() != null && pdDocument.getDocumentCatalog().getAcroForm(null) != null && pdDocument.getDocumentCatalog().getAcroForm(null).hasXFA();
        metadata.set(PDF.HAS_XFA, Boolean.toString(hasXFA));
        return hasXFA;
    }

    private boolean shouldHandleXFAOnly(boolean hasXFA, PDFParserConfig config) {
        return config.isIfXFAExtractOnlyXFA() && hasXFA;
    }

    private void handleXFAOnly(PDDocument pdDocument, ContentHandler handler, Metadata metadata, ParseContext context) throws SAXException, IOException, TikaException {
        XFAExtractor ex = new XFAExtractor();
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        try (UnsynchronizedByteArrayInputStream is = UnsynchronizedByteArrayInputStream.builder().setByteArray(pdDocument.getDocumentCatalog().getAcroForm(null).getXFA().getBytes()).get();){
            ex.extract(is, xhtml, metadata, context);
        }
        catch (XMLStreamException e) {
            throw new TikaException("XML error in XFA", e);
        }
        xhtml.endDocument();
    }

    public PDFParserConfig getPDFParserConfig() {
        return this.defaultConfig;
    }

    public void setPDFParserConfig(PDFParserConfig config) {
        this.defaultConfig = config;
    }

    public boolean isEnableAutoSpace() {
        return this.defaultConfig.isEnableAutoSpace();
    }

    @Field
    public void setEnableAutoSpace(boolean v) {
        this.defaultConfig.setEnableAutoSpace(v);
    }

    public boolean isExtractAnnotationText() {
        return this.defaultConfig.isExtractAnnotationText();
    }

    @Field
    public void setExtractAnnotationText(boolean v) {
        this.defaultConfig.setExtractAnnotationText(v);
    }

    public boolean isSuppressDuplicateOverlappingText() {
        return this.defaultConfig.isSuppressDuplicateOverlappingText();
    }

    @Field
    public void setIgnoreContentStreamSpaceGlyphs(boolean v) {
        this.defaultConfig.setIgnoreContentStreamSpaceGlyphs(v);
    }

    public boolean isIgnoreContentStreamSpaceGlyphs() {
        return this.defaultConfig.isIgnoreContentStreamSpaceGlyphs();
    }

    @Field
    public void setSuppressDuplicateOverlappingText(boolean v) {
        this.defaultConfig.setSuppressDuplicateOverlappingText(v);
    }

    public boolean isSortByPosition() {
        return this.defaultConfig.isSortByPosition();
    }

    @Field
    public void setSortByPosition(boolean v) {
        this.defaultConfig.setSortByPosition(v);
    }

    @Field
    public void setOcrStrategy(String ocrStrategyString) {
        this.defaultConfig.setOcrStrategy(ocrStrategyString);
    }

    public String getOcrStrategy() {
        return this.defaultConfig.getOcrStrategy().name();
    }

    @Field
    public void setOcrStrategyAuto(String ocrStrategyAuto) {
        this.defaultConfig.setOcrStrategyAuto(ocrStrategyAuto);
    }

    public String getOcrStrategyAuto() {
        return this.defaultConfig.getOcrStrategyAuto().toString();
    }

    @Field
    public void setOcrRenderingStrategy(String ocrRenderingStrategy) {
        this.defaultConfig.setOcrRenderingStrategy(ocrRenderingStrategy);
    }

    public String getOcrRenderingStrategy() {
        return this.defaultConfig.getOcrRenderingStrategy().name();
    }

    @Field
    public void setOcrImageType(String imageType) {
        this.defaultConfig.setOcrImageType(imageType);
    }

    public String getOcrImageType() {
        return this.defaultConfig.getOcrImageType().name();
    }

    @Field
    public void setOcrDPI(int dpi) {
        this.defaultConfig.setOcrDPI(dpi);
    }

    public int getOcrDPI() {
        return this.defaultConfig.getOcrDPI();
    }

    @Field
    public void setOcrImageQuality(float imageQuality) {
        this.defaultConfig.setOcrImageQuality(imageQuality);
    }

    public float getOcrImageQuality() {
        return this.defaultConfig.getOcrImageQuality();
    }

    @Field
    public void setOcrImageFormatName(String formatName) {
        this.defaultConfig.setOcrImageFormatName(formatName);
    }

    public String getOcrImageFormatName() {
        return this.defaultConfig.getOcrImageFormatName();
    }

    @Field
    public void setExtractBookmarksText(boolean extractBookmarksText) {
        this.defaultConfig.setExtractBookmarksText(extractBookmarksText);
    }

    public boolean isExtractBookmarksText() {
        return this.defaultConfig.isExtractBookmarksText();
    }

    @Field
    public void setExtractInlineImages(boolean extractInlineImages) {
        this.defaultConfig.setExtractInlineImages(extractInlineImages);
    }

    public boolean isExtractInlineImages() {
        return this.defaultConfig.isExtractInlineImages();
    }

    @Field
    public void setExtractInlineImageMetadataOnly(boolean extractInlineImageMetadataOnly) {
        this.defaultConfig.setExtractInlineImageMetadataOnly(extractInlineImageMetadataOnly);
    }

    public boolean isExtractInlineImageMetadataOnly() {
        return this.defaultConfig.isExtractInlineImageMetadataOnly();
    }

    @Field
    public void setAverageCharTolerance(float averageCharTolerance) {
        this.defaultConfig.setAverageCharTolerance(Float.valueOf(averageCharTolerance));
    }

    public float getAverageCharTolerance() {
        return this.defaultConfig.getAverageCharTolerance().floatValue();
    }

    @Field
    public void setSpacingTolerance(float spacingTolerance) {
        this.defaultConfig.setSpacingTolerance(Float.valueOf(spacingTolerance));
    }

    public float getSpacingTolerance() {
        return this.defaultConfig.getSpacingTolerance().floatValue();
    }

    @Field
    public void setCatchIntermediateExceptions(boolean catchIntermediateExceptions) {
        this.defaultConfig.setCatchIntermediateIOExceptions(catchIntermediateExceptions);
    }

    public boolean isCatchIntermediateExceptions() {
        return this.defaultConfig.isCatchIntermediateIOExceptions();
    }

    @Field
    public void setExtractAcroFormContent(boolean extractAcroFormContent) {
        this.defaultConfig.setExtractAcroFormContent(extractAcroFormContent);
    }

    public boolean isExtractAcroFormContent() {
        return this.defaultConfig.isExtractAcroFormContent();
    }

    @Field
    public void setIfXFAExtractOnlyXFA(boolean ifXFAExtractOnlyXFA) {
        this.defaultConfig.setIfXFAExtractOnlyXFA(ifXFAExtractOnlyXFA);
    }

    public boolean isIfXFAExtractOnlyXFA() {
        return this.defaultConfig.isIfXFAExtractOnlyXFA();
    }

    @Field
    public void setAllowExtractionForAccessibility(boolean allowExtractionForAccessibility) {
        this.defaultConfig.setAccessChecker(new AccessChecker(allowExtractionForAccessibility));
    }

    public boolean isAllowExtractionForAccessibility() {
        return this.defaultConfig.getAccessChecker().isAllowExtractionForAccessibility();
    }

    @Field
    public void setExtractUniqueInlineImagesOnly(boolean extractUniqueInlineImagesOnly) {
        this.defaultConfig.setExtractUniqueInlineImagesOnly(extractUniqueInlineImagesOnly);
    }

    public boolean isExtractUniqueInlineImagesOnly() {
        return this.defaultConfig.isExtractUniqueInlineImagesOnly();
    }

    @Field
    public void setExtractActions(boolean extractActions) {
        this.defaultConfig.setExtractActions(extractActions);
    }

    public boolean isExtractActions() {
        return this.defaultConfig.isExtractActions();
    }

    @Field
    public void setExtractFontNames(boolean extractFontNames) {
        this.defaultConfig.setExtractFontNames(extractFontNames);
    }

    public boolean isExtractFontNames() {
        return this.defaultConfig.isExtractFontNames();
    }

    @Field
    public void setSetKCMS(boolean setKCMS) {
        this.defaultConfig.setSetKCMS(setKCMS);
    }

    public boolean isSetKCMS() {
        return this.defaultConfig.isSetKCMS();
    }

    @Field
    public void setDetectAngles(boolean detectAngles) {
        this.defaultConfig.setDetectAngles(detectAngles);
    }

    public boolean isDetectAngles() {
        return this.defaultConfig.isDetectAngles();
    }

    @Field
    public void setExtractMarkedContent(boolean extractMarkedContent) {
        this.defaultConfig.setExtractMarkedContent(extractMarkedContent);
    }

    public boolean isExtractMarkedContent() {
        return this.defaultConfig.isExtractMarkedContent();
    }

    @Field
    public void setDropThreshold(float dropThreshold) {
        this.defaultConfig.setDropThreshold(Float.valueOf(dropThreshold));
    }

    public float getDropThreshold() {
        return this.defaultConfig.getDropThreshold().floatValue();
    }

    @Field
    public void setMaxMainMemoryBytes(long maxMainMemoryBytes) {
        this.defaultConfig.setMaxMainMemoryBytes(maxMainMemoryBytes);
    }

    @Field
    public void setExtractIncrementalUpdateInfo(boolean setExtractIncrementalUpdateInfo) {
        this.defaultConfig.setExtractIncrementalUpdateInfo(setExtractIncrementalUpdateInfo);
    }

    public long getMaxMainMemoryBytes() {
        return this.defaultConfig.getMaxMainMemoryBytes();
    }

    public boolean isExtractIncrementalUpdateInfo() {
        return this.defaultConfig.isExtractIncrementalUpdateInfo();
    }

    @Field
    public void setParseIncrementalUpdates(boolean parseIncrementalUpdates) {
        this.defaultConfig.setParseIncrementalUpdates(parseIncrementalUpdates);
    }

    public boolean isParseIncrementalUpdates() {
        return this.defaultConfig.isParseIncrementalUpdates();
    }

    @Field
    public void setMaxIncrementalUpdates(int maxIncrementalUpdates) {
        this.defaultConfig.setMaxIncrementalUpdates(maxIncrementalUpdates);
    }

    public int getMaxIncrementalUpdates() {
        return this.defaultConfig.getMaxIncrementalUpdates();
    }

    @Field
    public void setThrowOnEncryptedPayload(boolean throwOnEncryptedPayload) {
        this.defaultConfig.setThrowOnEncryptedPayload(throwOnEncryptedPayload);
    }

    public boolean isThrowOnEncryptedPayload() {
        return this.defaultConfig.isThrowOnEncryptedPayload();
    }

    @Override
    public void initialize(Map<String, Param> params) throws TikaConfigException {
    }

    @Override
    public void checkInitialization(InitializableProblemHandler handler) throws TikaConfigException {
    }

    private void initRenderer(PDFParserConfig config, ParseContext context) {
        if (config.getRenderer() != null && config.getRenderer().getSupportedTypes(context).contains(MEDIA_TYPE)) {
            return;
        }
        PDFBoxRenderer pdfBoxRenderer = new PDFBoxRenderer();
        pdfBoxRenderer.setDPI(config.getOcrDPI());
        pdfBoxRenderer.setImageType(config.getOcrImageType().getImageType());
        pdfBoxRenderer.setImageFormatName(config.getOcrImageFormatName());
        config.setRenderer(pdfBoxRenderer);
    }

    @Override
    public void setRenderer(Renderer renderer) {
        this.defaultConfig.setRenderer(renderer);
    }

    public Renderer getRenderer() {
        return this.defaultConfig.getRenderer();
    }

    @Field
    public void setImageGraphicsEngineFactory(ImageGraphicsEngineFactory imageGraphicsEngineFactory) {
        this.defaultConfig.setImageGraphicsEngineFactory(imageGraphicsEngineFactory);
    }

    public ImageGraphicsEngineFactory getImageGraphicsEngineFactory() {
        return this.defaultConfig.getImageGraphicsEngineFactory();
    }

    @Field
    public void setImageStrategy(String imageStrategy) {
        this.defaultConfig.setImageStrategy(imageStrategy);
    }

    public String getImageStrategy() {
        return this.defaultConfig.getImageStrategy().name();
    }

    static class TikaAcroFormFixup
    extends AbstractFixup {
        TikaAcroFormFixup(PDDocument document) {
            super(document);
        }

        @Override
        public void apply() {
            new AcroFormDefaultsProcessor(this.document).process();
        }
    }
}

