/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.io.function.IOStream;

public final class CSVPrinter
implements Flushable,
Closeable {
    private final Appendable appendable;
    private final CSVFormat format;
    private boolean newRecord = true;
    private long recordCount;
    private final ReentrantLock lock = new ReentrantLock();

    public CSVPrinter(Appendable appendable, CSVFormat format) throws IOException {
        Objects.requireNonNull(appendable, "appendable");
        Objects.requireNonNull(format, "format");
        this.appendable = appendable;
        this.format = format.copy();
        String[] headerComments = format.getHeaderComments();
        if (headerComments != null) {
            for (String line : headerComments) {
                this.printComment(line);
            }
        }
        if (format.getHeader() != null && !format.getSkipHeaderRecord()) {
            this.printRecord(format.getHeader());
        }
    }

    @Override
    public void close() throws IOException {
        this.close(false);
    }

    public void close(boolean flush) throws IOException {
        if (flush || this.format.getAutoFlush()) {
            this.flush();
        }
        if (this.appendable instanceof Closeable) {
            ((Closeable)((Object)this.appendable)).close();
        }
    }

    @SuppressFBWarnings(value={"AT_NONATOMIC_OPERATIONS_ON_SHARED_VARIABLE"}, justification="https://github.com/spotbugs/spotbugs/issues/3428")
    private void endOfRecord() throws IOException {
        this.println();
        ++this.recordCount;
    }

    @Override
    public void flush() throws IOException {
        if (this.appendable instanceof Flushable) {
            ((Flushable)((Object)this.appendable)).flush();
        }
    }

    public Appendable getOut() {
        return this.appendable;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public void print(Object value) throws IOException {
        this.lock.lock();
        try {
            this.printRaw(value);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printComment(String comment) throws IOException {
        this.lock.lock();
        try {
            if (comment == null || !this.format.isCommentMarkerSet()) {
                return;
            }
            if (!this.newRecord) {
                this.println();
            }
            this.appendable.append(this.format.getCommentMarker().charValue());
            this.appendable.append(' ');
            block8: for (int i = 0; i < comment.length(); ++i) {
                char c = comment.charAt(i);
                switch (c) {
                    case '\r': {
                        if (i + 1 < comment.length() && comment.charAt(i + 1) == '\n') {
                            ++i;
                        }
                    }
                    case '\n': {
                        this.println();
                        this.appendable.append(this.format.getCommentMarker().charValue());
                        this.appendable.append(' ');
                        continue block8;
                    }
                    default: {
                        this.appendable.append(c);
                    }
                }
            }
            this.println();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printHeaders(ResultSet resultSet) throws IOException, SQLException {
        this.lock.lock();
        try {
            try (IOStream<String[]> stream = IOStream.of(this.format.builder().setHeader(resultSet).get().getHeader());){
                stream.forEachOrdered(this::print);
            }
            this.println();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void println() throws IOException {
        this.lock.lock();
        try {
            this.format.println(this.appendable);
            this.newRecord = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void printRaw(Object value) throws IOException {
        this.format.print(value, this.appendable, this.newRecord);
        this.newRecord = false;
    }

    public void printRecord(Iterable<?> values) throws IOException {
        this.lock.lock();
        try {
            IOStream.of(values).forEachOrdered(this::print);
            this.endOfRecord();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void printRecord(Object ... values) throws IOException {
        this.printRecord(Arrays.asList(values));
    }

    public void printRecord(Stream<?> stream) throws IOException {
        this.lock.lock();
        try {
            IOStream.adapt(stream).forEachOrdered(stream.isParallel() ? this::printRaw : this::print);
            this.endOfRecord();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void printRecordObject(Object value) throws IOException {
        if (value instanceof Object[]) {
            this.printRecord((Object[])value);
        } else if (value instanceof Iterable) {
            this.printRecord((Iterable)value);
        } else {
            this.printRecord(value);
        }
    }

    private void printRecords(IOStream<?> stream) throws IOException {
        this.format.limit(stream).forEachOrdered(this::printRecordObject);
    }

    public void printRecords(Iterable<?> values) throws IOException {
        this.printRecords(IOStream.of(values));
    }

    public void printRecords(Object ... values) throws IOException {
        this.printRecords(Arrays.asList(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printRecords(ResultSet resultSet) throws SQLException, IOException {
        int columnCount = resultSet.getMetaData().getColumnCount();
        while (resultSet.next() && this.format.useRow(resultSet.getRow())) {
            this.lock.lock();
            try {
                for (int i = 1; i <= columnCount; ++i) {
                    Object object = resultSet.getObject(i);
                    if (object instanceof Clob) {
                        try (Reader reader = ((Clob)object).getCharacterStream();){
                            this.print(reader);
                            continue;
                        }
                    }
                    if (object instanceof Blob) {
                        try (InputStream inputStream = ((Blob)object).getBinaryStream();){
                            this.print(inputStream);
                            continue;
                        }
                    }
                    this.print(object);
                }
                this.endOfRecord();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void printRecords(ResultSet resultSet, boolean printHeader) throws SQLException, IOException {
        if (printHeader) {
            this.printHeaders(resultSet);
        }
        this.printRecords(resultSet);
    }

    public void printRecords(Stream<?> values) throws IOException {
        this.printRecords(IOStream.adapt(values));
    }
}

