/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.DefaultResponsibleParty;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.bind.metadata.code.CI_RoleCode;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.extent.Extent;

@XmlType(name="CI_Responsibility_Type", propOrder={"role", "extent", "party"})
@XmlRootElement(name="CI_Responsibility")
@XmlSeeAlso(value={DefaultResponsibleParty.class})
@UML(identifier="CI_Responsibility", specification=Specification.ISO_19115)
public class DefaultResponsibility
extends ISOMetadata {
    private static final long serialVersionUID = -8290895980682233572L;
    private Role role;
    private Collection<Extent> extents;
    private Collection<AbstractParty> parties;

    public DefaultResponsibility() {
    }

    public DefaultResponsibility(Role role, Extent extent, AbstractParty party) {
        this.role = role;
        this.extents = this.singleton(extent, Extent.class);
        this.parties = this.singleton(party, AbstractParty.class);
    }

    public DefaultResponsibility(DefaultResponsibility object) {
        super(object);
        if (object != null) {
            this.role = object.getRole();
            this.extents = this.copyCollection(object.getExtents(), Extent.class);
            this.parties = this.copyCollection(object.getParties(), AbstractParty.class);
        }
    }

    DefaultResponsibility(ResponsibleParty object) {
        super(object);
        if (object != null) {
            this.role = object.getRole();
            if (object instanceof DefaultResponsibility) {
                DefaultResponsibility c = (DefaultResponsibility)((Object)object);
                this.extents = this.copyCollection(c.getExtents(), Extent.class);
                this.parties = this.copyCollection(c.getParties(), AbstractParty.class);
            }
        }
    }

    @XmlElement(name="role", required=true)
    @XmlJavaTypeAdapter(value=CI_RoleCode.Since2014.class)
    @UML(identifier="role", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Role getRole() {
        return this.role;
    }

    public void setRole(Role newValue) {
        this.checkWritePermission(this.role);
        this.role = newValue;
    }

    @UML(identifier="extent", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Extent> getExtents() {
        this.extents = this.nonNullCollection(this.extents, Extent.class);
        return this.extents;
    }

    public void setExtents(Collection<? extends Extent> newValues) {
        this.extents = this.writeCollection(newValues, this.extents, Extent.class);
    }

    @UML(identifier="party", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Collection<AbstractParty> getParties() {
        this.parties = this.nonNullCollection(this.parties, AbstractParty.class);
        return this.parties;
    }

    public void setParties(Collection<? extends AbstractParty> newValues) {
        this.parties = this.writeCollection(newValues, this.parties, AbstractParty.class);
    }

    @XmlElement(name="extent")
    private Collection<Extent> getExtent() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getExtents() : null;
    }

    @XmlElement(name="party", required=true)
    private Collection<AbstractParty> getParty() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getParties() : null;
    }
}

