/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.server;

import java.io.File;
import java.util.Vector;
import ojb.broker.PersistenceBroker;
import ojb.broker.metadata.DescriptorRepository;
import ojb.broker.singlevm.PersistenceBrokerImpl;

public class BrokerPool {
    private Vector brokers = new Vector();
    private Vector freeBrokerIds = new Vector();
    private static final boolean DEBUG = false;
    public static int BROKERCOUNT = 10;

    public BrokerPool(File repositoryFile) {
        try {
            DescriptorRepository repository = DescriptorRepository.getInstance(repositoryFile.getAbsolutePath());
            int i = 0;
            while (i < BROKERCOUNT) {
                PersistenceBrokerImpl broker = new PersistenceBrokerImpl(repository);
                this.brokers.add(broker);
                this.freeBrokerIds.add(new Integer(this.brokers.size() - 1));
                ++i;
            }
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            System.exit(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getFreeBrokerId() {
        Vector vector = this.freeBrokerIds;
        synchronized (vector) {
            while (this.freeBrokerIds.isEmpty()) {
                try {
                    this.freeBrokerIds.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            int result = (Integer)this.freeBrokerIds.remove(0);
            return result;
        }
    }

    void releaseBrokerId(int id) {
        Vector vector = this.freeBrokerIds;
        synchronized (vector) {
            this.freeBrokerIds.add(new Integer(id));
            this.freeBrokerIds.notifyAll();
        }
    }

    PersistenceBroker getBrokerById(int id) {
        PersistenceBroker result = (PersistenceBroker)this.brokers.get(id);
        return result;
    }
}

