/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messagelet.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.commons.collections.iterators.SingletonIterator;

public class ServletRequestImpl
implements ServletRequest {
    protected HashMap attributes = new HashMap();
    protected String authorization = null;
    protected String characterEncoding = null;
    protected int contentLength = -1;
    protected String contentType = null;
    protected static Locale defaultLocale = Locale.getDefault();
    protected InputStream input = null;
    protected ArrayList locales = new ArrayList();
    protected String protocol = null;
    protected BufferedReader reader = null;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected String scheme = null;
    protected boolean secure = false;
    protected String serverName = null;
    protected int serverPort = -1;
    protected ServletInputStream stream = null;
    protected ServletContext servletContext;

    public ServletRequestImpl(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public InputStream getStream() {
        return this.input;
    }

    public void setStream(InputStream input) {
        this.input = input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocale(Locale locale) {
        ArrayList arrayList = this.locales;
        synchronized (arrayList) {
            this.locales.add(locale);
        }
    }

    public ServletInputStream createInputStream() throws IOException {
        return null;
    }

    public void finishRequest() throws IOException {
        block5: {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.stream == null) break block5;
            try {
                this.stream.close();
            }
            catch (IOException e) {}
        }
    }

    public void setContentLength(int length) {
        this.contentLength = length;
    }

    public void setContentType(String type) {
        this.contentType = type;
        if (type.indexOf(59) >= 0) {
            // empty if block
        }
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setServerName(String name) {
        this.serverName = name;
    }

    public void setServerPort(int port) {
        this.serverPort = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return new IteratorEnumeration(this.attributes.keySet().iterator());
        }
    }

    public String getCharacterEncoding() {
        if (this.characterEncoding == null) {
            this.characterEncoding = "ISO-8859-1";
        }
        return this.characterEncoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.reader != null) {
            throw new IllegalStateException("getReader() has already been called");
        }
        if (this.stream == null) {
            this.stream = this.createInputStream();
        }
        return this.stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locale getLocale() {
        ArrayList arrayList = this.locales;
        synchronized (arrayList) {
            if (this.locales.size() > 0) {
                return (Locale)this.locales.get(0);
            }
            return defaultLocale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getLocales() {
        ArrayList arrayList = this.locales;
        synchronized (arrayList) {
            if (this.locales.size() > 0) {
                return new IteratorEnumeration(((AbstractList)this.locales).iterator());
            }
        }
        return new IteratorEnumeration((Iterator)new SingletonIterator((Object)defaultLocale));
    }

    public String getParameter(String name) {
        String[] values = (String[])this.getParameterMap().get(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public String[] getParameterValues(String name) {
        String[] values = (String[])this.getParameterMap().get(name);
        if (values != null) {
            return values;
        }
        return null;
    }

    public Map getParameterMap() {
        return new HashMap();
    }

    public Enumeration getParameterNames() {
        return new IteratorEnumeration(this.getParameterMap().keySet().iterator());
    }

    public String getProtocol() {
        return this.protocol;
    }

    public BufferedReader getReader() throws IOException {
        if (this.stream != null) {
            throw new IllegalStateException("getInputStream() has already been called");
        }
        if (this.reader == null) {
            String encoding = this.getCharacterEncoding();
            InputStreamReader isr = new InputStreamReader((InputStream)this.createInputStream(), encoding);
            this.reader = new BufferedReader(isr);
        }
        return this.reader;
    }

    public String getRealPath(String path) {
        if (this.servletContext == null) {
            return null;
        }
        try {
            return this.servletContext.getRealPath(path);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.servletContext.getRequestDispatcher(path);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public boolean isSecure() {
        return this.secure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.put(name, value);
        }
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        byte[] buffer = new byte[]{97};
        String dummy = new String(buffer, enc);
        this.characterEncoding = enc;
    }

    protected void log(String message) {
        this.servletContext.log(message);
    }

    protected void log(String message, Throwable throwable) {
        this.servletContext.log(message, throwable);
    }
}

