/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.map;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.torque.map.InheritanceMap;
import org.apache.torque.map.TableMap;

public class ColumnMap
implements Serializable {
    private static final long serialVersionUID = -5971184507395399165L;
    private Object type = null;
    private String torqueType = null;
    private boolean usePrimitive = true;
    private int size = 0;
    private int scale = 0;
    private boolean pk = false;
    private boolean notNull = false;
    private String relatedTableName = "";
    private String relatedColumnName = "";
    private TableMap table;
    private String columnName;
    private String javaName;
    private boolean autoIncrement = false;
    private String description = "";
    private boolean isProtected = false;
    private String defaultValue = null;
    private String inheritance = "false";
    private boolean useInheritance;
    private Map inheritanceMaps = Collections.synchronizedMap(new ListOrderedMap());
    private String inputValidator;
    private String javaNamingMethod;
    private String javaType;
    private int position = -1;

    public ColumnMap(String name, TableMap containingTable) {
        this.table = containingTable;
        this.columnName = this.normalizeName(name);
    }

    protected String normalizeName(String name) {
        if (name.indexOf(46) > 0) {
            return name.substring(name.lastIndexOf(46) + 1);
        }
        return name;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getFullyQualifiedName() {
        return this.table.getName() + "." + this.columnName;
    }

    public String getTableName() {
        return this.table.getName();
    }

    public void setType(Object type) {
        this.type = type;
    }

    public void setTorqueType(String torqueType) {
        this.torqueType = torqueType;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setPrimaryKey(boolean pk) {
        this.pk = pk;
    }

    public void setNotNull(boolean nn) {
        this.notNull = nn;
    }

    public void setForeignKey(String fullyQualifiedName) {
        if (fullyQualifiedName != null && fullyQualifiedName.length() > 0) {
            this.relatedTableName = fullyQualifiedName.substring(0, fullyQualifiedName.indexOf(46));
            this.relatedColumnName = fullyQualifiedName.substring(fullyQualifiedName.indexOf(46) + 1);
        } else {
            this.relatedTableName = "";
            this.relatedColumnName = "";
        }
    }

    public void setForeignKey(String tableName, String columnName) {
        if (tableName != null && tableName.length() > 0 && columnName != null && columnName.length() > 0) {
            this.relatedTableName = tableName;
            this.relatedColumnName = this.normalizeName(columnName);
        } else {
            this.relatedTableName = "";
            this.relatedColumnName = "";
        }
    }

    public Object getType() {
        return this.type;
    }

    public String getTorqueType() {
        return this.torqueType;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isPrimaryKey() {
        return this.pk;
    }

    public boolean isNotNull() {
        return this.notNull || this.isPrimaryKey();
    }

    public boolean isForeignKey() {
        return this.relatedTableName != null && this.relatedTableName.length() > 0;
    }

    public String getRelatedName() {
        return this.relatedTableName + "." + this.relatedColumnName;
    }

    public String getRelatedTableName() {
        return this.relatedTableName;
    }

    public String getRelatedColumnName() {
        return this.relatedColumnName;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setJavaName(String name) {
        this.javaName = name;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InheritanceMap[] getInheritanceMaps() {
        InheritanceMap[] iMaps = new InheritanceMap[this.inheritanceMaps.size()];
        Map map = this.inheritanceMaps;
        synchronized (map) {
            Iterator it = this.inheritanceMaps.values().iterator();
            int i = 0;
            while (it.hasNext()) {
                iMaps[i++] = (InheritanceMap)it.next();
            }
        }
        return iMaps;
    }

    public void addInheritanceMap(InheritanceMap map) {
        this.setUseInheritance(true);
        this.inheritanceMaps.put(map.getKey(), map);
    }

    public String getInheritance() {
        return this.inheritance;
    }

    public void setInheritance(String inheritanceType) {
        this.inheritance = inheritanceType;
    }

    public String getInputValidator() {
        return this.inputValidator;
    }

    public void setInputValidator(String inputValidator) {
        this.inputValidator = inputValidator;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    public boolean isPk() {
        return this.pk;
    }

    public void setPk(boolean pk) {
        this.pk = pk;
    }

    public boolean isUseInheritance() {
        return this.useInheritance;
    }

    public void setUseInheritance(boolean useInheritance) {
        this.useInheritance = useInheritance;
    }

    public InheritanceMap getInheritanceMap(String key) {
        return (InheritanceMap)this.inheritanceMaps.get(key);
    }

    public boolean isUsePrimitive() {
        return this.usePrimitive;
    }

    public void setUsePrimitive(boolean usePrimitive) {
        this.usePrimitive = usePrimitive;
    }

    public String getJavaNamingMethod() {
        return this.javaNamingMethod;
    }

    public void setJavaNamingMethod(String javaNamingMethod) {
        this.javaNamingMethod = javaNamingMethod;
    }

    public TableMap getTable() {
        return this.table;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }
}

