/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import com.workingdogs.village.Column;
import com.workingdogs.village.DataSet;
import com.workingdogs.village.DataSetException;
import com.workingdogs.village.KeyDef;
import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;
import com.workingdogs.village.Schema;
import com.workingdogs.village.TableDataSet;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.DB;
import org.apache.torque.map.ColumnMap;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.map.MapBuilder;
import org.apache.torque.map.TableMap;
import org.apache.torque.oid.IdGenerator;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Query;
import org.apache.torque.util.SQLBuilder;
import org.apache.torque.util.SqlExpression;
import org.apache.torque.util.Transaction;
import org.apache.torque.util.VillageUtils;

public abstract class BasePeer
implements Serializable {
    public static final String ORDER_BY = "ORDER BY";
    public static final String IGNORE_CASE = "IgNOrE cAsE";
    public static final String TABLE_NAME = "TABLE_NAME";
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$torque$util$BasePeer == null ? (class$org$apache$torque$util$BasePeer = BasePeer.class$("org.apache.torque.util.BasePeer")) : class$org$apache$torque$util$BasePeer));
    static /* synthetic */ Class class$org$apache$torque$util$BasePeer;

    private static void throwTorqueException(Exception e) throws TorqueException {
        if (e instanceof TorqueException) {
            throw (TorqueException)((Object)e);
        }
        throw new TorqueException(e);
    }

    public static Schema initTableSchema(String tableName) {
        return BasePeer.initTableSchema(tableName, Torque.getDefaultDB());
    }

    public static Schema initTableSchema(String tableName, String dbName) {
        Schema schema = null;
        Connection con = null;
        try {
            con = Torque.getConnection(dbName);
            schema = new Schema().schema(con, tableName);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new Error("Error in BasePeer.initTableSchema(" + tableName + "): " + e.getMessage());
        }
        finally {
            Torque.closeConnection(con);
        }
        return schema;
    }

    public static Column[] initTableColumns(Schema schema) {
        Column[] columns = null;
        try {
            int numberOfColumns = schema.numberOfColumns();
            columns = new Column[numberOfColumns];
            for (int i = 0; i < numberOfColumns; ++i) {
                columns[i] = schema.column(i + 1);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new Error("Error in BasePeer.initTableColumns(): " + e.getMessage());
        }
        return columns;
    }

    public static String[] initColumnNames(Column[] columns) {
        String[] columnNames = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            columnNames[i] = columns[i].name().toUpperCase();
        }
        return columnNames;
    }

    public static String[] initCriteriaKeys(String tableName, String[] columnNames) {
        String[] keys = new String[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            keys[i] = tableName + "." + columnNames[i].toUpperCase();
        }
        return keys;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteAll(Connection con, String table, String column, int value) throws TorqueException {
        Statement statement = null;
        try {
            try {
                statement = con.createStatement();
                StringBuffer query = new StringBuffer();
                query.append("DELETE FROM ").append(table).append(" WHERE ").append(column).append(" = ").append(value);
                statement.executeUpdate(query.toString());
            }
            catch (SQLException e) {
                throw new TorqueException(e);
            }
            Object var7_7 = null;
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new TorqueException(e);
            }
        }
        try {}
        catch (SQLException e) {
            throw new TorqueException(e);
        }
        statement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAll(String table, String column, int value) throws TorqueException {
        Connection con = null;
        try {
            con = Torque.getConnection(Torque.getDefaultDB());
            BasePeer.deleteAll(con, table, column, value);
        }
        finally {
            Torque.closeConnection(con);
        }
    }

    public static void doDelete(Criteria criteria) throws TorqueException {
        BasePeer.doDelete(criteria, (String)null);
    }

    protected static void doDelete(Criteria criteria, String tableName) throws TorqueException {
        Connection con = null;
        try {
            con = Transaction.beginOptional(criteria.getDbName(), criteria.isUseTransaction());
            BasePeer.doDelete(criteria, tableName, con);
            Transaction.commit(con);
        }
        catch (TorqueException e) {
            Transaction.safeRollback(con);
            throw e;
        }
    }

    public static void doDelete(Criteria criteria, Connection con) throws TorqueException {
        BasePeer.doDelete(criteria, null, con);
    }

    public static void doDelete(Criteria criteria, String tableName, Connection con) throws TorqueException {
        HashSet<String> tables;
        String dbName = criteria.getDbName();
        final DatabaseMap dbMap = Torque.getDatabaseMap(dbName);
        SQLBuilder.TableCallback tc = new SQLBuilder.TableCallback(){

            public void process(Set tables, String key, Criteria crit) {
                if (crit.isCascade()) {
                    TableMap[] tableMaps = dbMap.getTables();
                    for (int i = 0; i < tableMaps.length; ++i) {
                        ColumnMap[] columnMaps = tableMaps[i].getColumns();
                        for (int j = 0; j < columnMaps.length; ++j) {
                            if (!columnMaps[j].isForeignKey() || !columnMaps[j].isPrimaryKey() || !key.equals(columnMaps[j].getRelatedName())) continue;
                            tables.add(tableMaps[i].getName());
                            crit.add(columnMaps[j].getFullyQualifiedName(), crit.getValue(key));
                        }
                    }
                }
            }
        };
        if (tableName == null) {
            tables = SQLBuilder.getTableSet(criteria, tc);
        } else {
            tables = new HashSet<String>(1);
            tables.add(tableName);
        }
        try {
            BasePeer.processTables(criteria, tables, con, new ProcessCallback(){

                public void process(String table, String dbName, Record rec) throws Exception {
                    rec.markToBeDeleted();
                    rec.save();
                }
            });
        }
        catch (Exception e) {
            BasePeer.throwTorqueException(e);
        }
    }

    public static ObjectKey doInsert(Criteria criteria) throws TorqueException {
        Connection con = null;
        ObjectKey id = null;
        try {
            con = Transaction.beginOptional(criteria.getDbName(), criteria.isUseTransaction());
            id = BasePeer.doInsert(criteria, con);
            Transaction.commit(con);
        }
        catch (TorqueException e) {
            Transaction.safeRollback(con);
            throw e;
        }
        return id;
    }

    /*
     * Exception decompiling
     */
    public static ObjectKey doInsert(Criteria criteria, Connection con) throws TorqueException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static SimpleKey getId(ColumnMap pk, IdGenerator keyGen, Connection con, Object keyInfo) throws TorqueException {
        SimpleKey id = null;
        try {
            if (pk != null && keyGen != null) {
                id = pk.getType() instanceof Number ? new NumberKey(keyGen.getIdAsBigDecimal(con, keyInfo)) : new StringKey(keyGen.getIdAsString(con, keyInfo));
            }
        }
        catch (Exception e) {
            BasePeer.throwTorqueException(e);
        }
        return id;
    }

    private static void insertOrUpdateRecord(Record rec, String table, String dbName, Criteria criteria) throws TorqueException {
        DatabaseMap dbMap = Torque.getDatabaseMap(dbName);
        ColumnMap[] columnMaps = dbMap.getTable(table).getColumns();
        boolean shouldSave = false;
        for (int j = 0; j < columnMaps.length; ++j) {
            ColumnMap colMap = columnMaps[j];
            String colName = colMap.getColumnName();
            String key = colMap.getTableName() + '.' + colName;
            if (!criteria.containsKey(key)) continue;
            try {
                VillageUtils.setVillageValue(criteria, key, rec, colName);
                shouldSave = true;
                continue;
            }
            catch (Exception e) {
                BasePeer.throwTorqueException(e);
            }
        }
        if (shouldSave) {
            try {
                rec.save();
            }
            catch (Exception e) {
                BasePeer.throwTorqueException(e);
            }
        } else {
            throw new TorqueException("No changes to save");
        }
    }

    static String createQueryDisplayString(Criteria criteria) throws TorqueException {
        return BasePeer.createQuery(criteria).toString();
    }

    public static String createQueryString(Criteria criteria) throws TorqueException {
        Query query = BasePeer.createQuery(criteria);
        return query.toString();
    }

    static Query createQuery(Criteria criteria) throws TorqueException {
        return SQLBuilder.buildQueryClause(criteria, null, new SQLBuilder.QueryCallback(){

            public String process(Criteria.Criterion criterion, List params) {
                return criterion.toString();
            }
        });
    }

    public static List doSelect(Criteria criteria) throws TorqueException {
        Connection con = null;
        List results = null;
        try {
            con = Transaction.beginOptional(criteria.getDbName(), criteria.isUseTransaction());
            results = BasePeer.doSelect(criteria, con);
            Transaction.commit(con);
        }
        catch (TorqueException e) {
            Transaction.safeRollback(con);
            throw e;
        }
        return results;
    }

    public static List doSelect(Criteria criteria, Connection con) throws TorqueException {
        Query query = BasePeer.createQuery(criteria);
        DB dbadapter = Torque.getDB(criteria.getDbName());
        return BasePeer.executeQuery(query.toString(), dbadapter.supportsNativeOffset() ? 0 : criteria.getOffset(), dbadapter.supportsNativeLimit() ? -1 : criteria.getLimit(), criteria.isSingleRecord(), con);
    }

    public static List executeQuery(String queryString) throws TorqueException {
        return BasePeer.executeQuery(queryString, Torque.getDefaultDB(), false);
    }

    public static List executeQuery(String queryString, String dbName) throws TorqueException {
        return BasePeer.executeQuery(queryString, dbName, false);
    }

    public static List executeQuery(String queryString, String dbName, boolean singleRecord) throws TorqueException {
        return BasePeer.executeQuery(queryString, 0, -1, dbName, singleRecord);
    }

    public static List executeQuery(String queryString, boolean singleRecord, Connection con) throws TorqueException {
        return BasePeer.executeQuery(queryString, 0, -1, singleRecord, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List executeQuery(String queryString, int start, int numberOfResults, String dbName, boolean singleRecord) throws TorqueException {
        Connection con = null;
        List results = null;
        try {
            con = Torque.getConnection(dbName);
            results = BasePeer.executeQuery(queryString, start, numberOfResults, singleRecord, con);
        }
        finally {
            Torque.closeConnection(con);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static List executeQuery(String queryString, int start, int numberOfResults, boolean singleRecord, Connection con) throws TorqueException {
        List results;
        block8: {
            QueryDataSet qds = null;
            results = Collections.EMPTY_LIST;
            try {
                long startTime = System.currentTimeMillis();
                qds = new QueryDataSet(con, queryString);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Elapsed time=" + (System.currentTimeMillis() - startTime) + " ms"));
                }
                results = BasePeer.getSelectResults(qds, start, numberOfResults, singleRecord);
                VillageUtils.close(qds);
            }
            catch (DataSetException e) {
                BasePeer.throwTorqueException((Exception)((Object)e));
            }
            catch (SQLException e2) {
                BasePeer.throwTorqueException(e2);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                VillageUtils.close(qds);
            }
        }
        return results;
    }

    public static List getSelectResults(QueryDataSet qds) throws TorqueException {
        return BasePeer.getSelectResults(qds, 0, -1, false);
    }

    public static List getSelectResults(QueryDataSet qds, boolean singleRecord) throws TorqueException {
        return BasePeer.getSelectResults(qds, 0, -1, singleRecord);
    }

    public static List getSelectResults(QueryDataSet qds, int numberOfResults, boolean singleRecord) throws TorqueException {
        List results = null;
        if (numberOfResults != 0) {
            results = BasePeer.getSelectResults(qds, 0, numberOfResults, singleRecord);
        }
        return results;
    }

    public static List getSelectResults(QueryDataSet qds, int start, int numberOfResults, boolean singleRecord) throws TorqueException {
        ArrayList<Record> results = null;
        try {
            if (numberOfResults < 0) {
                results = new ArrayList<Record>();
                qds.fetchRecords();
            } else {
                results = new ArrayList(numberOfResults);
                qds.fetchRecords(start, numberOfResults);
            }
            int startRecord = 0;
            if (start > 0 && numberOfResults <= 0) {
                startRecord = start;
            }
            for (int i = startRecord; i < qds.size(); ++i) {
                Record rec = qds.getRecord(i);
                results.add(rec);
            }
            if (results.size() > 1 && singleRecord) {
                BasePeer.handleMultipleRecords((DataSet)qds);
            }
        }
        catch (Exception e) {
            BasePeer.throwTorqueException(e);
        }
        return results;
    }

    private static ColumnMap getPrimaryKey(Criteria criteria) throws TorqueException {
        String key = (String)criteria.keys().nextElement();
        String table = criteria.getTableName(key);
        ColumnMap pk = null;
        if (!table.equals("")) {
            DatabaseMap dbMap = Torque.getDatabaseMap(criteria.getDbName());
            if (dbMap == null) {
                throw new TorqueException("dbMap is null");
            }
            if (dbMap.getTable(table) == null) {
                throw new TorqueException("dbMap.getTable() is null");
            }
            ColumnMap[] columns = dbMap.getTable(table).getColumns();
            for (int i = 0; i < columns.length; ++i) {
                if (!columns[i].isPrimaryKey()) continue;
                pk = columns[i];
                break;
            }
        }
        return pk;
    }

    public static void doUpdate(Criteria updateValues) throws TorqueException {
        Connection con = null;
        try {
            con = Transaction.beginOptional(updateValues.getDbName(), updateValues.isUseTransaction());
            BasePeer.doUpdate(updateValues, con);
            Transaction.commit(con);
        }
        catch (TorqueException e) {
            Transaction.safeRollback(con);
            throw e;
        }
    }

    public static void doUpdate(Criteria updateValues, Connection con) throws TorqueException {
        ColumnMap pk = BasePeer.getPrimaryKey(updateValues);
        Criteria selectCriteria = null;
        if (pk == null || !updateValues.containsKey(pk.getFullyQualifiedName())) {
            throw new TorqueException("No PK specified for database update");
        }
        selectCriteria = new Criteria(2);
        selectCriteria.put(pk.getFullyQualifiedName(), updateValues.remove(pk.getFullyQualifiedName()));
        BasePeer.doUpdate(selectCriteria, updateValues, con);
    }

    public static void doUpdate(Criteria selectCriteria, Criteria updateValues) throws TorqueException {
        Connection con = null;
        try {
            con = Transaction.beginOptional(selectCriteria.getDbName(), updateValues.isUseTransaction());
            BasePeer.doUpdate(selectCriteria, updateValues, con);
            Transaction.commit(con);
        }
        catch (TorqueException e) {
            Transaction.safeRollback(con);
            throw e;
        }
    }

    public static void doUpdate(Criteria criteria, final Criteria updateValues, Connection con) throws TorqueException {
        Set tables = SQLBuilder.getTableSet(criteria, null);
        try {
            BasePeer.processTables(criteria, tables, con, new ProcessCallback(){

                public void process(String table, String dbName, Record rec) throws Exception {
                    BasePeer.insertOrUpdateRecord(rec, table, dbName, updateValues);
                }
            });
        }
        catch (Exception e) {
            BasePeer.throwTorqueException(e);
        }
    }

    public static int executeStatement(String statementString) throws TorqueException {
        return BasePeer.executeStatement(statementString, Torque.getDefaultDB());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeStatement(String statementString, String dbName) throws TorqueException {
        Connection con = null;
        int rowCount = -1;
        try {
            con = Torque.getConnection(dbName);
            rowCount = BasePeer.executeStatement(statementString, con);
        }
        finally {
            Torque.closeConnection(con);
        }
        return rowCount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int executeStatement(String statementString, Connection con) throws TorqueException {
        int rowCount = -1;
        Statement statement = null;
        try {
            try {
                statement = con.createStatement();
                rowCount = statement.executeUpdate(statementString);
            }
            catch (SQLException e) {
                throw new TorqueException(e);
            }
            Object var6_4 = null;
            if (statement == null) return rowCount;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new TorqueException(e);
            }
        }
        try {}
        catch (SQLException e) {
            throw new TorqueException(e);
        }
        statement.close();
        return rowCount;
    }

    protected static void handleMultipleRecords(DataSet ds) throws TorqueException {
        throw new TorqueException("Criteria expected single Record and Multiple Records were selected");
    }

    public static MapBuilder getMapBuilder(String name) throws TorqueException {
        return Torque.getMapBuilder(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List doPSSelect(Criteria criteria, Connection con) throws TorqueException {
        List v = null;
        StringBuffer qry = new StringBuffer();
        ArrayList params = new ArrayList(criteria.size());
        BasePeer.createPreparedStatement(criteria, qry, params);
        PreparedStatement statement = null;
        try {
            try {
                statement = con.prepareStatement(qry.toString());
                for (int i = 0; i < params.size(); ++i) {
                    Object param = params.get(i);
                    if (param instanceof Date) {
                        statement.setDate(i + 1, (Date)param);
                        continue;
                    }
                    if (param instanceof NumberKey) {
                        statement.setBigDecimal(i + 1, ((NumberKey)param).getBigDecimal());
                        continue;
                    }
                    if (param instanceof Integer) {
                        statement.setInt(i + 1, (Integer)param);
                        continue;
                    }
                    statement.setString(i + 1, param.toString());
                }
                QueryDataSet qds = null;
                try {
                    qds = new QueryDataSet(statement.executeQuery());
                    v = BasePeer.getSelectResults(qds);
                }
                catch (Throwable throwable) {
                    VillageUtils.close(qds);
                    throw throwable;
                }
                VillageUtils.close(qds);
                Object var10_12 = null;
                if (statement == null) return v;
            }
            catch (DataSetException e) {
                BasePeer.throwTorqueException((Exception)((Object)e));
                Object var10_13 = null;
                if (statement == null) return v;
                try {
                    statement.close();
                    return v;
                }
                catch (SQLException e2) {
                    throw new TorqueException(e2);
                }
            }
            catch (SQLException e) {
                BasePeer.throwTorqueException(e);
                Object var10_14 = null;
                if (statement == null) return v;
                try {}
                catch (SQLException e2) {
                    throw new TorqueException(e2);
                }
                statement.close();
                return v;
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            if (statement == null) throw throwable;
            try {}
            catch (SQLException e2) {
                throw new TorqueException(e2);
            }
            statement.close();
            throw throwable;
        }
        try {}
        catch (SQLException e2) {
            throw new TorqueException(e2);
        }
        statement.close();
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List doPSSelect(Criteria criteria) throws TorqueException {
        Connection con = Torque.getConnection(criteria.getDbName());
        List v = null;
        try {
            v = BasePeer.doPSSelect(criteria, con);
        }
        finally {
            Torque.closeConnection(con);
        }
        return v;
    }

    public static void createPreparedStatement(Criteria criteria, StringBuffer queryString, List params) throws TorqueException {
        Query query = SQLBuilder.buildQueryClause(criteria, params, new SQLBuilder.QueryCallback(){

            public String process(Criteria.Criterion criterion, List params) {
                StringBuffer sb = new StringBuffer();
                criterion.appendPsTo(sb, params);
                return sb.toString();
            }
        });
        String sql = query.toString();
        log.debug((Object)sql);
        queryString.append(sql);
    }

    public static void correctBooleans(Criteria criteria, TableMap defaultTableMap) throws TorqueException {
        Iterator keyIt = criteria.keySet().iterator();
        while (keyIt.hasNext()) {
            Criteria.Criterion criterion;
            ColumnMap columnMap;
            String columnName;
            String key = (String)keyIt.next();
            TableMap tableMap = null;
            int dotPosition = key.lastIndexOf(".");
            if (dotPosition == -1) {
                columnName = key;
                tableMap = defaultTableMap;
            } else {
                Map aliases;
                DatabaseMap databaseMap;
                columnName = key.substring(dotPosition + 1);
                String tableName = key.substring(0, dotPosition);
                String databaseName = criteria.getDbName();
                if (databaseName == null) {
                    databaseName = Torque.getDefaultDB();
                }
                if ((databaseMap = Torque.getDatabaseMap(databaseName)) != null) {
                    tableMap = databaseMap.getTable(tableName);
                }
                if (tableMap == null && (aliases = criteria.getAliases()).get(tableName) != null) {
                    tableName = (String)aliases.get(tableName);
                    tableMap = databaseMap.getTable(tableName);
                }
            }
            if (tableMap == null || (columnMap = tableMap.getColumn(columnName)) == null) continue;
            if ("BOOLEANINT".equals(columnMap.getTorqueType())) {
                criterion = criteria.getCriterion(key);
                BasePeer.replaceBooleanValues(criterion, new Integer(1), new Integer(0));
                continue;
            }
            if (!"BOOLEANCHAR".equals(columnMap.getTorqueType())) continue;
            criterion = criteria.getCriterion(key);
            BasePeer.replaceBooleanValues(criterion, "Y", "N");
        }
    }

    private static void replaceBooleanValues(Criteria.Criterion criterion, Object trueValue, Object falseValue) {
        Criteria.Criterion[] attachedCriterions = criterion.getAttachedCriterion();
        for (int i = 0; i < attachedCriterions.length; ++i) {
            Object criterionValue = attachedCriterions[i].getValue();
            if (!(criterionValue instanceof Boolean)) continue;
            Boolean booleanValue = (Boolean)criterionValue;
            attachedCriterions[i].setValue(Boolean.TRUE.equals(booleanValue) ? trueValue : falseValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTables(Criteria crit, Set tables, Connection con, ProcessCallback pc) throws Exception {
        String dbName = crit.getDbName();
        DB db = Torque.getDB(dbName);
        DatabaseMap dbMap = Torque.getDatabaseMap(dbName);
        Iterator it = tables.iterator();
        while (it.hasNext()) {
            String table = (String)it.next();
            KeyDef kd = new KeyDef();
            HashSet<String> whereClause = new HashSet<String>();
            ColumnMap[] columnMaps = dbMap.getTable(table).getColumns();
            for (int j = 0; j < columnMaps.length; ++j) {
                String key;
                ColumnMap colMap = columnMaps[j];
                if (colMap.isPrimaryKey()) {
                    kd.addAttrib(colMap.getColumnName());
                }
                if (!crit.containsKey(key = colMap.getTableName() + '.' + colMap.getColumnName())) continue;
                if (crit.getComparison(key).equals(Criteria.CUSTOM)) {
                    whereClause.add(crit.getString(key));
                    continue;
                }
                whereClause.add(SqlExpression.build(colMap.getColumnName(), crit.getValue(key), crit.getComparison(key), crit.isIgnoreCase(), db));
            }
            TableDataSet tds = null;
            try {
                String tableName = SQLBuilder.getFullTableName(table, dbName);
                tds = new TableDataSet(con, tableName, kd);
                String sqlSnippet = StringUtils.join(whereClause.iterator(), (String)" AND ");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("BasePeer: whereClause=" + sqlSnippet));
                }
                tds.where(sqlSnippet);
                tds.fetchRecords();
                if (tds.size() > 1 && crit.isSingleRecord()) {
                    BasePeer.handleMultipleRecords((DataSet)tds);
                }
                for (int j = 0; j < tds.size(); ++j) {
                    Record rec = tds.getRecord(j);
                    if (pc == null) continue;
                    pc.process(table, dbName, rec);
                }
            }
            catch (Throwable throwable) {
                VillageUtils.close(tds);
                throw throwable;
            }
            VillageUtils.close(tds);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static interface ProcessCallback {
        public void process(String var1, String var2, Record var3) throws Exception;
    }
}

