/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.pool;

public class BoundedBuffer {
    public static final int DEFAULT_CAPACITY = 1024;
    protected final Object[] buffer;
    protected int takePtr = 0;
    protected int putPtr = 0;
    protected int usedSlots = 0;
    protected int emptySlots;

    public BoundedBuffer(int capacity) throws IllegalArgumentException {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Bounded Buffer must have capacity > 0!");
        }
        this.buffer = new Object[capacity];
        this.emptySlots = capacity;
    }

    public BoundedBuffer() {
        this(1024);
    }

    public synchronized int size() {
        return this.usedSlots;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public synchronized Object peek() {
        return this.usedSlots > 0 ? this.buffer[this.takePtr] : null;
    }

    public synchronized boolean offer(Object x) {
        if (x == null) {
            throw new IllegalArgumentException("Bounded Buffer cannot store a null object");
        }
        if (this.emptySlots > 0) {
            --this.emptySlots;
            this.buffer[this.putPtr] = x;
            if (++this.putPtr >= this.buffer.length) {
                this.putPtr = 0;
            }
            ++this.usedSlots;
            return true;
        }
        return false;
    }

    public synchronized Object poll() {
        if (this.usedSlots > 0) {
            --this.usedSlots;
            Object old = this.buffer[this.takePtr];
            this.buffer[this.takePtr] = null;
            if (++this.takePtr >= this.buffer.length) {
                this.takePtr = 0;
            }
            ++this.emptySlots;
            return old;
        }
        return null;
    }
}

