/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.pull.tools;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.om.security.User;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.services.ui.TurbineUI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.ServerData;

public class UITool
implements ApplicationTool {
    private static Log log = LogFactory.getLog(UITool.class);
    public static final String SKIN_ATTRIBUTE = UITool.class.getName() + ".skin";
    private String skinName;

    @Override
    public void refresh() {
        TurbineUI.refresh(this.getSkin());
        log.debug((Object)("UITool refreshed for skin: " + this.getSkin()));
    }

    public String[] getSkinNames() {
        return TurbineUI.getSkinNames();
    }

    public String getWebappSkinName() {
        return TurbineUI.getWebappSkinName();
    }

    public String get(String key) {
        return TurbineUI.get(this.getSkin(), key);
    }

    public String getSkin() {
        return this.skinName;
    }

    public void setSkin() {
        this.skinName = TurbineUI.getWebappSkinName();
    }

    public void setSkin(String skinName) {
        this.skinName = skinName;
    }

    protected void setSkin(RunData data) {
        this.setSkin();
    }

    protected void setSkin(User user) {
        if (user.getTemp(SKIN_ATTRIBUTE) == null) {
            this.setSkin();
        } else {
            this.setSkin((String)user.getTemp(SKIN_ATTRIBUTE));
        }
    }

    public static void setSkin(User user, String skin) {
        user.setTemp(SKIN_ATTRIBUTE, skin);
    }

    public String image(String imageId, RunData data) {
        return this.image(imageId, data.getServerData());
    }

    public String image(String imageId, ServerData serverData) {
        return TurbineUI.image(this.getSkin(), imageId, serverData);
    }

    public String image(String imageId) {
        return TurbineUI.image(this.getSkin(), imageId);
    }

    public String getStylecss(RunData data) {
        return this.getStylecss(data.getServerData());
    }

    public String getStylecss(ServerData serverData) {
        return TurbineUI.getStylecss(this.getSkin(), serverData);
    }

    public String getStylecss() {
        return TurbineUI.getStylecss(this.getSkin());
    }

    public String getScript(String filename, RunData data) {
        return this.getScript(filename, data.getServerData());
    }

    public String getScript(String filename, ServerData serverData) {
        return TurbineUI.getScript(this.getSkin(), filename, serverData);
    }

    public String getScript(String filename) {
        return TurbineUI.getScript(this.getSkin(), filename);
    }

    @Override
    public void init(Object data) {
        if (data == null) {
            log.debug((Object)"UITool scope is global");
            this.setSkin();
        } else if (data instanceof RunData) {
            log.debug((Object)"UITool scope is request");
            this.setSkin((RunData)data);
        } else if (data instanceof PipelineData) {
            PipelineData pipelineData = (PipelineData)data;
            RunData runData = (RunData)pipelineData;
            log.debug((Object)"UITool scope is request");
            this.setSkin(runData);
        } else if (data instanceof User) {
            log.debug((Object)"UITool scope is session");
            this.setSkin((User)data);
        }
    }
}

