/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.actions.sessionvalidator;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.actions.sessionvalidator.SessionValidator;
import org.apache.turbine.om.security.User;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.util.RunData;

public class TemplateSessionValidator
extends SessionValidator {
    private static Log log = LogFactory.getLog(TemplateSessionValidator.class);

    @Override
    public void doPerform(PipelineData pipelineData) throws Exception {
        RunData data = this.getRunData(pipelineData);
        data.populate();
        if (data.getUser() == null) {
            log.debug((Object)"Fixing up empty User Object!");
            Object anonymousUser = this.security.getAnonymousUser();
            data.setUser(anonymousUser);
            data.save();
        }
        if (!data.hasScreen() && StringUtils.isEmpty((String)data.getTemplateInfo().getScreenTemplate())) {
            if (StringUtils.isNotEmpty((String)this.templateHomepage)) {
                data.getTemplateInfo().setScreenTemplate(this.templateHomepage);
            } else {
                data.setScreen(this.screenHomepage);
            }
        } else {
            this.handleFormCounterToken(data, false);
        }
        if (data.getTemplateInfo().getScreenTemplate() != null) {
            data.setScreen(null);
        }
        pipelineData.get(Turbine.class).put(User.class, data.getUser());
    }
}

