/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.intake.validator.DefaultValidator;
import org.apache.fulcrum.intake.validator.ValidationException;

public class BooleanValidator
extends DefaultValidator<Boolean> {
    private static String[] trueValues = new String[]{"TRUE", "T", "YES", "Y", "1", "ON"};
    private static String[] falseValues = new String[]{"FALSE", "F", "NO", "N", "0", "OFF"};

    @Override
    public void assertValidity(String testValue) throws ValidationException {
        super.assertValidity(testValue);
        if (this.required || StringUtils.isNotEmpty((CharSequence)testValue)) {
            try {
                this.parse(testValue);
            }
            catch (ParseException e) {
                throw new ValidationException(e.getMessage());
            }
        }
    }

    public Boolean parse(String stringValue) throws ParseException {
        Boolean result = null;
        for (int cnt = 0; cnt < Math.max(trueValues.length, falseValues.length); ++cnt) {
            if (cnt < trueValues.length && stringValue.equalsIgnoreCase(trueValues[cnt])) {
                result = Boolean.TRUE;
                break;
            }
            if (cnt >= falseValues.length || !stringValue.equalsIgnoreCase(falseValues[cnt])) continue;
            result = Boolean.FALSE;
            break;
        }
        if (result == null) {
            throw new ParseException(stringValue + " could not be converted to a Boolean", 0);
        }
        return result;
    }
}

