/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.datastore;

import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.exception.IllegalStateOfArgumentException;
import net.sf.uadetector.datareader.DataReader;
import net.sf.uadetector.datastore.DataStore;
import net.sf.uadetector.datastore.RefreshableDataStore;
import net.sf.uadetector.datastore.UpdateOperation;
import net.sf.uadetector.datastore.UpdateOperationTask;
import net.sf.uadetector.exception.CanNotOpenStreamException;
import net.sf.uadetector.internal.data.Data;
import net.sf.uadetector.internal.util.UrlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRefreshableDataStore
implements RefreshableDataStore {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRefreshableDataStore.class);
    private final Charset charset;
    private Data data;
    private final URL dataUrl;
    private final DataStore fallback;
    private final DataReader reader;
    private UpdateOperation updateOperation = new UpdateOperationTask(this);
    private final URL versionUrl;

    private static Data checkData(Data data) {
        if (Data.EMPTY.equals(data)) {
            throw new IllegalStateOfArgumentException("Argument 'data' must not be empty.");
        }
        return data;
    }

    protected AbstractRefreshableDataStore(@Nonnull DataReader reader, @Nonnull String dataUrl, @Nonnull String versionUrl, @Nonnull Charset charset, @Nonnull DataStore fallback) {
        this(reader, UrlUtil.build(dataUrl), UrlUtil.build(versionUrl), charset, fallback);
    }

    protected AbstractRefreshableDataStore(@Nonnull DataReader reader, @Nonnull URL dataUrl, @Nonnull URL versionUrl, @Nonnull Charset charset, DataStore fallback) {
        Check.notNull((Object)reader, (String)"reader");
        Check.notNull((Object)charset, (String)"charset");
        Check.notNull((Object)dataUrl, (String)"dataUrl");
        Check.notNull((Object)versionUrl, (String)"versionUrl");
        Check.notNull((Object)fallback, (String)"fallback");
        this.reader = reader;
        this.dataUrl = dataUrl;
        this.versionUrl = versionUrl;
        this.charset = charset;
        this.fallback = fallback;
        this.data = AbstractRefreshableDataStore.checkData(fallback.getData());
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public Data getData() {
        return this.data;
    }

    @Override
    public DataReader getDataReader() {
        return this.reader;
    }

    @Override
    public URL getDataUrl() {
        return this.dataUrl;
    }

    @Override
    public DataStore getFallback() {
        return this.fallback;
    }

    @Override
    public UpdateOperation getUpdateOperation() {
        return this.updateOperation;
    }

    @Override
    public URL getVersionUrl() {
        return this.versionUrl;
    }

    @Override
    public void refresh() {
        try {
            this.updateOperation.run();
        }
        catch (CanNotOpenStreamException e) {
            LOG.warn(String.format("The data can not be read from the specified URL: %s", e.getLocalizedMessage()));
        }
        catch (IllegalArgumentException e) {
            LOG.warn("The read content is faulty and can not be processed correctly. " + e.getLocalizedMessage());
        }
        catch (RuntimeException e) {
            LOG.warn("The read content is faulty and can not be processed correctly.", (Throwable)e);
        }
    }

    protected void setData(@Nonnull Data data) {
        Check.notNull((Object)data, (String)"data");
        this.data = AbstractRefreshableDataStore.checkData(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug(data.toStats());
        }
    }

    protected void setUpdateOperation(@Nonnull UpdateOperation updateOperation) {
        Check.notNull((Object)updateOperation, (String)"updateOperation");
        this.updateOperation = updateOperation;
    }
}

