/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.data.domain;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.OperatingSystemFamily;
import net.sf.uadetector.UserAgent;
import net.sf.uadetector.VersionNumber;
import net.sf.uadetector.internal.data.domain.Identifiable;
import net.sf.uadetector.internal.data.domain.OperatingSystemPattern;

@Immutable
public final class OperatingSystem
implements Identifiable,
Serializable {
    private static final long serialVersionUID = -5330180544816352323L;
    @Nonnull
    private final String family;
    private final int hash;
    @Nonnull
    private final String icon;
    @Nonnegative
    private final int id;
    @Nonnull
    private final String infoUrl;
    @Nonnull
    private final String name;
    @Nonnull
    private final SortedSet<OperatingSystemPattern> patterns;
    @Nonnull
    private final String producer;
    @Nonnull
    private final String producerUrl;
    @Nonnull
    private final String url;

    private static int buildHashCode(@Nonnegative int id, @Nonnull String name, @Nonnull String family, @Nonnull String infoUrl, @Nonnull SortedSet<OperatingSystemPattern> patterns, @Nonnull String producer, @Nonnull String producerUrl, @Nonnull String url, @Nonnull String icon) {
        int prime = 31;
        int result = 1;
        result = 31 * result + id;
        result = 31 * result + name.hashCode();
        result = 31 * result + family.hashCode();
        result = 31 * result + infoUrl.hashCode();
        result = 31 * result + patterns.hashCode();
        result = 31 * result + producer.hashCode();
        result = 31 * result + producerUrl.hashCode();
        result = 31 * result + url.hashCode();
        result = 31 * result + icon.hashCode();
        return result;
    }

    public OperatingSystem(@Nonnegative int id, @Nonnull String name, @Nonnull String family, @Nonnull String infoUrl, @Nonnull SortedSet<OperatingSystemPattern> patterns, @Nonnull String producer, @Nonnull String producerUrl, @Nonnull String url, @Nonnull String icon) {
        this.id = Check.notNegative((int)id, (String)"id");
        this.name = (String)Check.notNull((Object)name, (String)"name");
        this.family = (String)Check.notNull((Object)family, (String)"family");
        this.infoUrl = (String)Check.notNull((Object)infoUrl, (String)"infoUrl");
        this.patterns = Collections.unmodifiableSortedSet(new TreeSet((SortedSet)Check.notNull(patterns, (String)"patterns")));
        this.producer = (String)Check.notNull((Object)producer, (String)"producer");
        this.producerUrl = (String)Check.notNull((Object)producerUrl, (String)"producerUrl");
        this.url = (String)Check.notNull((Object)url, (String)"url");
        this.icon = (String)Check.notNull((Object)icon, (String)"icon");
        this.hash = OperatingSystem.buildHashCode(id, name, family, infoUrl, patterns, producer, producerUrl, url, icon);
    }

    public void copyTo(@Nonnull UserAgent.Builder builder) {
        OperatingSystemFamily f = OperatingSystemFamily.evaluate(this.family);
        VersionNumber version = VersionNumber.parseOperatingSystemVersion(f, builder.getUserAgentString());
        builder.setOperatingSystem(new net.sf.uadetector.OperatingSystem(f, this.family, this.icon, this.name, this.producer, this.producerUrl, this.url, version));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperatingSystem other = (OperatingSystem)obj;
        if (this.id != other.id) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.family.equals(other.family)) {
            return false;
        }
        if (!this.infoUrl.equals(other.infoUrl)) {
            return false;
        }
        if (!this.patterns.equals(other.patterns)) {
            return false;
        }
        if (!this.producer.equals(other.producer)) {
            return false;
        }
        if (!this.producerUrl.equals(other.producerUrl)) {
            return false;
        }
        if (!this.url.equals(other.url)) {
            return false;
        }
        return this.icon.equals(other.icon);
    }

    @Nonnull
    public String getFamily() {
        return this.family;
    }

    @Nonnull
    public String getIcon() {
        return this.icon;
    }

    @Override
    @Nonnegative
    public int getId() {
        return this.id;
    }

    @Nonnull
    public String getInfoUrl() {
        return this.infoUrl;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public SortedSet<OperatingSystemPattern> getPatterns() {
        return this.patterns;
    }

    @Nonnull
    public String getProducer() {
        return this.producer;
    }

    @Nonnull
    public String getProducerUrl() {
        return this.producerUrl;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OperatingSystem [id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", family=");
        builder.append(this.family);
        builder.append(", infoUrl=");
        builder.append(this.infoUrl);
        builder.append(", patterns=");
        builder.append(this.patterns);
        builder.append(", producer=");
        builder.append(this.producer);
        builder.append(", producerUrl=");
        builder.append(this.producerUrl);
        builder.append(", url=");
        builder.append(this.url);
        builder.append(", icon=");
        builder.append(this.icon);
        builder.append("]");
        return builder.toString();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nonnull
        private String family = "";
        @Nonnull
        private String icon = "";
        private int id = Integer.MIN_VALUE;
        @Nonnull
        private String infoUrl = "";
        @Nonnull
        private String name = "";
        @Nonnull
        private SortedSet<OperatingSystemPattern> patterns = new TreeSet<OperatingSystemPattern>();
        @Nonnull
        private String producer = "";
        @Nonnull
        private String producerUrl = "";
        @Nonnull
        private String url = "";

        public Builder() {
        }

        protected Builder(@Nonnull Builder builder) {
            Check.notNull((Object)builder, (String)"builder");
            this.family = builder.family;
            this.icon = builder.icon;
            this.id = builder.id;
            this.infoUrl = builder.infoUrl;
            this.name = builder.name;
            this.patterns.addAll(builder.patterns);
            this.producer = builder.producer;
            this.producerUrl = builder.producerUrl;
            this.url = builder.url;
        }

        public Builder(@Nonnull OperatingSystem operatingSystem) {
            Check.notNull((Object)operatingSystem, (String)"operatingSystem");
            this.id = Check.notNegative((int)operatingSystem.getId(), (String)"operatingSystem.getId()");
            this.name = (String)Check.notNull((Object)operatingSystem.getName(), (String)"operatingSystem.getName()");
            this.family = (String)Check.notNull((Object)operatingSystem.getFamily(), (String)"operatingSystem.getFamily()");
            this.infoUrl = (String)Check.notNull((Object)operatingSystem.getInfoUrl(), (String)"operatingSystem.getInfoUrl()");
            this.patterns = new TreeSet<OperatingSystemPattern>((SortedSet)Check.notNull(operatingSystem.getPatterns(), (String)"operatingSystem.getPatterns()"));
            this.producer = (String)Check.notNull((Object)operatingSystem.getProducer(), (String)"operatingSystem.getProducer()");
            this.producerUrl = (String)Check.notNull((Object)operatingSystem.getProducerUrl(), (String)"operatingSystem.getProducerUrl()");
            this.url = (String)Check.notNull((Object)operatingSystem.getUrl(), (String)"operatingSystem.getUrl()");
            this.icon = (String)Check.notNull((Object)operatingSystem.getIcon(), (String)"operatingSystem.getIcon()");
        }

        @Nonnull
        public Builder addPatterns(@Nonnull Set<OperatingSystemPattern> patterns) {
            Check.notNull(patterns, (String)"patterns");
            this.patterns.addAll(patterns);
            return this;
        }

        @Nonnull
        public OperatingSystem build() {
            return new OperatingSystem(this.id, this.name, this.family, this.infoUrl, this.patterns, this.producer, this.producerUrl, this.url, this.icon);
        }

        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public String getFamily() {
            return this.family;
        }

        @Nonnull
        public String getIcon() {
            return this.icon;
        }

        public int getId() {
            return this.id;
        }

        @Nonnull
        public String getInfoUrl() {
            return this.infoUrl;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public SortedSet<OperatingSystemPattern> getPatterns() {
            return this.patterns;
        }

        @Nonnull
        public String getProducer() {
            return this.producer;
        }

        @Nonnull
        public String getProducerUrl() {
            return this.producerUrl;
        }

        @Nonnull
        public String getUrl() {
            return this.url;
        }

        @Nonnull
        public Builder setFamily(@Nonnull String family) {
            this.family = (String)Check.notNull((Object)family, (String)"family");
            return this;
        }

        @Nonnull
        public Builder setIcon(@Nonnull String icon) {
            this.icon = (String)Check.notNull((Object)icon, (String)"icon");
            return this;
        }

        @Nonnull
        public Builder setId(@Nonnegative int id) {
            this.id = Check.notNegative((int)id, (String)"id");
            return this;
        }

        @Nonnull
        public Builder setId(@Nonnull String id) {
            Check.notEmpty((CharSequence)id, (String)"id");
            this.setId(Integer.parseInt(id.trim()));
            return this;
        }

        @Nonnull
        public Builder setInfoUrl(@Nonnull String infoUrl) {
            this.infoUrl = (String)Check.notNull((Object)infoUrl, (String)"infoUrl");
            return this;
        }

        @Nonnull
        public Builder setName(@Nonnull String name) {
            this.name = (String)Check.notNull((Object)name, (String)"name");
            return this;
        }

        @Nonnull
        public Builder setPatterns(@Nonnull SortedSet<OperatingSystemPattern> patterns) {
            this.patterns = new TreeSet<OperatingSystemPattern>((SortedSet)Check.notNull(patterns, (String)"patterns"));
            return this;
        }

        @Nonnull
        public Builder setProducer(@Nonnull String producer) {
            this.producer = (String)Check.notNull((Object)producer, (String)"producer");
            return this;
        }

        @Nonnull
        public Builder setProducerUrl(@Nonnull String producerUrl) {
            this.producerUrl = (String)Check.notNull((Object)producerUrl, (String)"producerUrl");
            return this;
        }

        @Nonnull
        public Builder setUrl(@Nonnull String url) {
            this.url = (String)Check.notNull((Object)url, (String)"url");
            return this;
        }
    }
}

