/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.buffer;

import java.nio.ByteBuffer;
import org.python.core.PyBuffer;
import org.python.core.PyException;
import org.python.core.buffer.Base1DBuffer;

public abstract class BaseArrayBuffer
extends Base1DBuffer {
    protected byte[] storage;

    protected BaseArrayBuffer(byte[] storage, int featureFlags, int index0, int size, int stride) {
        super(featureFlags | 0x10000000, index0, size, stride);
        this.storage = storage;
    }

    @Override
    protected byte byteAtImpl(int byteIndex) throws IndexOutOfBoundsException {
        return this.storage[byteIndex];
    }

    @Override
    protected void storeAtImpl(byte value, int byteIndex) throws IndexOutOfBoundsException, PyException {
        this.checkWritable();
        this.storage[byteIndex] = value;
    }

    @Override
    public int byteIndex(int ... indices) throws IndexOutOfBoundsException {
        this.checkDimension(indices.length);
        return this.byteIndex(indices[0]);
    }

    @Override
    public void copyTo(int srcIndex, byte[] dest, int destPos, int count2) throws IndexOutOfBoundsException {
        block7: {
            int s;
            if (count2 <= 0) break block7;
            int itemsize = this.getItemsize();
            int stride = this.getStrides()[0];
            int skip = stride - itemsize;
            if (skip == 0) {
                System.arraycopy(this.storage, s, dest, destPos, count2 * itemsize);
            } else {
                int limit = s + count2 * stride;
                int d = destPos;
                if (itemsize == 1) {
                    for (s = this.byteIndex(srcIndex); s != limit; s += stride) {
                        dest[d++] = this.storage[s];
                    }
                } else {
                    while (s != limit) {
                        int t = s + itemsize;
                        while (s < t) {
                            dest[d++] = this.storage[s++];
                        }
                        s += skip;
                    }
                }
            }
        }
    }

    @Override
    public void copyFrom(byte[] src, int srcPos, int destIndex, int count2) throws IndexOutOfBoundsException, PyException {
        this.copyFrom(src, srcPos, 1, destIndex, count2);
    }

    protected void copyFrom(byte[] src, int srcPos, int srcStride, int destIndex, int count2) throws IndexOutOfBoundsException, PyException {
        block7: {
            int d;
            this.checkWritable();
            if (count2 <= 0) break block7;
            int itemsize = this.getItemsize();
            int stride = this.getStrides()[0];
            int skip = stride - itemsize;
            int srcSkip = srcStride - itemsize;
            if (skip == 0 && srcSkip == 0) {
                System.arraycopy(src, srcPos, this.storage, d, count2 * itemsize);
            } else {
                int limit = d + count2 * stride;
                int s = srcPos;
                if (itemsize == 1) {
                    for (d = this.byteIndex(destIndex); d != limit; d += stride) {
                        this.storage[d] = src[s];
                        s += srcStride;
                    }
                } else {
                    while (d != limit) {
                        int t = d + itemsize;
                        while (d < t) {
                            this.storage[d++] = src[s++];
                        }
                        s += srcSkip;
                        d += skip;
                    }
                }
            }
        }
    }

    @Override
    public void copyFrom(PyBuffer src) throws IndexOutOfBoundsException, PyException {
        if (src instanceof BaseArrayBuffer && !this.overlaps((BaseArrayBuffer)src)) {
            this.copyFromArrayBuffer((BaseArrayBuffer)src);
        } else {
            super.copyFrom(src);
        }
    }

    private boolean overlaps(BaseArrayBuffer src) {
        if (src.storage != this.storage) {
            return false;
        }
        int low = this.calcLeastIndex();
        int high = this.calcGreatestIndex();
        int srcLow = src.calcLeastIndex();
        int srcHigh = src.calcGreatestIndex();
        return srcHigh >= low && high >= srcLow;
    }

    private void copyFromArrayBuffer(BaseArrayBuffer src) throws IndexOutOfBoundsException, PyException {
        src.checkDimension(1);
        int itemsize = this.getItemsize();
        int count2 = this.getSize();
        if (src.getItemsize() != itemsize || src.getSize() != count2) {
            throw BaseArrayBuffer.differentStructure();
        }
        this.copyFrom(src.storage, src.index0, src.strides[0], 0, count2);
    }

    @Override
    protected ByteBuffer getNIOByteBufferImpl() {
        ByteBuffer b = ByteBuffer.wrap(this.storage);
        return this.isReadonly() ? b.asReadOnlyBuffer() : b;
    }

    @Override
    public PyBuffer.Pointer getBuf() {
        return new PyBuffer.Pointer(this.storage, this.index0);
    }
}

