/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.avaloncomponent;

import java.io.File;
import java.io.IOException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.commons.configuration2.Configuration;
import org.apache.fulcrum.yaafi.framework.container.ServiceContainer;
import org.apache.fulcrum.yaafi.framework.factory.ServiceContainerConfiguration;
import org.apache.fulcrum.yaafi.framework.factory.ServiceContainerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.InstantiationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.avaloncomponent.AvalonComponentService;
import org.apache.turbine.services.avaloncomponent.Log4j2Logger;

public class TurbineYaafiComponentService
extends TurbineBaseService
implements AvalonComponentService,
Initializable,
Disposable {
    private static Logger log = LogManager.getLogger((String)"avalon");
    public static final String CONTAINER_CONFIGURATION_KEY = "containerConfiguration";
    public static final String CONTAINER_CONFIGURATION_VALUE = "/WEB-INF/conf/containerConfiguration.xml";
    public static final String COMPONENT_PARAMETERS_KEY = "parameters";
    public static final String COMPONENT_PARAMETERS_VALUE = "/WEB-INF/conf/parameters.properties";
    private ServiceContainer container;

    @Override
    public void init() throws InitializationException {
        try {
            log.info("Initializing TurbineYaafiComponentService ...");
            this.initialize();
            this.setInit(true);
        }
        catch (Exception e) {
            log.error("Exception caught initialising service: ", (Throwable)e);
            throw new InitializationException("Initializing TurbineYaafiComponentService failed", e);
        }
    }

    @Override
    public void shutdown() {
        log.info("Disposing TurbineYaafiComponentService ...");
        this.dispose();
        this.setInit(false);
    }

    public void initialize() throws Exception {
        Configuration conf = this.getConfiguration();
        File home = new File(this.getServiceBroker().getApplicationRoot());
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = home::getAbsolutePath;
        log.info("Using the following home : {}", supplierArray);
        ServiceContainerConfiguration config = this.createServiceContainerConfiguration(conf, home);
        try {
            this.container = ServiceContainerFactory.create((ServiceContainerConfiguration)config);
        }
        catch (Exception e) {
            log.error("Initializing YAAFI failed", (Throwable)e);
            throw e;
        }
    }

    public void dispose() {
        if (this.container != null) {
            this.container.dispose();
            this.container = null;
        }
    }

    public Object lookup(String roleName) throws ServiceException {
        return this.container.lookup(roleName);
    }

    @Override
    public void release(Object component) {
        this.container.release(component);
    }

    public boolean hasService(String roleName) {
        return this.container.hasService(roleName);
    }

    protected ServiceContainerConfiguration createServiceContainerConfiguration(Configuration conf, File applicationRoot) throws IOException {
        ServiceContainerConfiguration result = new ServiceContainerConfiguration();
        result.setApplicationRootDir(applicationRoot.getAbsolutePath());
        result.setLogger(this.createAvalonLogger());
        if (conf.containsKey(CONTAINER_CONFIGURATION_KEY)) {
            String containerConfiguration = conf.getString(CONTAINER_CONFIGURATION_KEY);
            result.loadContainerConfiguration(containerConfiguration);
        } else if (conf.containsKey("componentRoles")) {
            String roleConfigurationFileName = conf.getString("componentRoles", "/WEB-INF/conf/roleConfiguration.xml");
            String componentConfigurationFileName = conf.getString("componentConfiguration", "/WEB-INF/conf/componentConfiguration.xml");
            String parametersFileName = conf.getString(COMPONENT_PARAMETERS_KEY, COMPONENT_PARAMETERS_VALUE);
            result.setComponentRolesLocation(roleConfigurationFileName);
            result.setComponentConfigurationLocation(componentConfigurationFileName);
            result.setParametersLocation(parametersFileName);
        } else {
            String containerConfiguration = conf.getString(CONTAINER_CONFIGURATION_KEY, CONTAINER_CONFIGURATION_VALUE);
            result.loadContainerConfiguration(containerConfiguration);
        }
        return result;
    }

    protected org.apache.avalon.framework.logger.Logger createAvalonLogger() {
        return new Log4j2Logger(log);
    }

    @Override
    public boolean exists(String roleName) {
        return this.hasService(roleName);
    }

    @Override
    public Object get(String roleName) throws InstantiationException {
        try {
            return this.lookup(roleName);
        }
        catch (Throwable t) {
            String msg = "Unable to get the following service : " + roleName;
            log.error(msg, t);
            throw new InstantiationException(msg, t);
        }
    }
}

