/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.torque.Column;

public class ColumnImpl
implements Column,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String[] FUNCTION_DELIMITERS = new String[]{" ", ",", "(", ")", "<", ">"};
    private static final String DOT = ".";
    private String columnName;
    private String tableName;
    private String schemaName;
    private String sqlExpression;

    public ColumnImpl(String tableName, String columnName) {
        if (columnName == null) {
            throw new NullPointerException("columnName must not be null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName must not be null");
        }
        this.setColumnName(columnName);
        this.setTableName(tableName);
        this.sqlExpression = tableName + DOT + columnName;
    }

    public ColumnImpl(String schemaName, String tableName, String columnName) {
        if (columnName == null) {
            throw new NullPointerException("columnName must not be null");
        }
        this.setColumnName(columnName);
        this.setTableName(tableName);
        this.setSchemaName(schemaName);
        this.sqlExpression = this.tableName == null ? this.columnName : this.tableName + DOT + this.columnName;
    }

    public ColumnImpl(String schemaName, String tableName, String columnName, String sqlExpression) {
        this.setColumnName(columnName);
        this.setTableName(tableName);
        this.setSchemaName(schemaName);
        this.setSqlExpression(sqlExpression);
    }

    public ColumnImpl(String sqlExpression) {
        this.setSqlExpression(sqlExpression);
        int dotIndex = sqlExpression.lastIndexOf(DOT);
        if (dotIndex == -1) {
            if (StringUtils.contains((CharSequence)sqlExpression, (CharSequence)"*")) {
                return;
            }
            if (StringUtils.indexOfAny((CharSequence)sqlExpression, (CharSequence[])FUNCTION_DELIMITERS) != -1) {
                throw new IllegalArgumentException("sqlExpression " + sqlExpression + " is unparseable, it does not contain a dot (.)  but function delimiters.");
            }
            this.setColumnName(sqlExpression);
            return;
        }
        String pre = sqlExpression.substring(0, dotIndex);
        String post = sqlExpression.substring(dotIndex + 1, sqlExpression.length());
        if (StringUtils.isBlank((CharSequence)pre)) {
            throw new IllegalArgumentException("sqlExpression " + sqlExpression + " is blank before the dot (.)");
        }
        int startIndex = StringUtils.lastIndexOfAny((CharSequence)pre, (CharSequence[])FUNCTION_DELIMITERS);
        int endIndex = StringUtils.indexOfAny((CharSequence)post, (CharSequence[])FUNCTION_DELIMITERS);
        endIndex = endIndex < 0 ? sqlExpression.length() : (endIndex += dotIndex + 1);
        if (startIndex + 1 == dotIndex) {
            throw new IllegalArgumentException("sqlExpression " + sqlExpression + " is blank between the last function delimiter (" + StringUtils.join((Object[])FUNCTION_DELIMITERS) + ") and the dot");
        }
        this.setColumnName(sqlExpression.substring(dotIndex + 1, endIndex));
        String fullTableName = sqlExpression.substring(startIndex + 1, dotIndex);
        this.setTableName(fullTableName);
        if (fullTableName.contains(DOT)) {
            int fullTableNameDotIndex = fullTableName.lastIndexOf(DOT);
            String extractedSchemaName = fullTableName.substring(0, fullTableNameDotIndex);
            this.setSchemaName(extractedSchemaName);
            StringBuilder sqlExpressionBuilder = new StringBuilder();
            if (startIndex != -1) {
                sqlExpressionBuilder.append(sqlExpression.substring(0, startIndex + 1));
            }
            sqlExpressionBuilder.append(this.getTableName()).append(DOT).append(post);
            this.setSqlExpression(sqlExpressionBuilder.toString());
        }
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    private void setColumnName(String columnName) {
        if (columnName != null && StringUtils.isBlank((CharSequence)columnName)) {
            throw new IllegalArgumentException("columnName must not be blank");
        }
        this.columnName = "*".equals(columnName) ? null : columnName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getFullTableName() {
        if (this.schemaName != null) {
            return this.schemaName + DOT + this.tableName;
        }
        return this.tableName;
    }

    private void setTableName(String tableName) {
        if (tableName != null && StringUtils.isBlank((CharSequence)tableName)) {
            throw new IllegalArgumentException("tableName must not be blank");
        }
        if (StringUtils.contains((CharSequence)tableName, (CharSequence)DOT)) {
            int dotIndex = tableName.lastIndexOf(DOT);
            this.schemaName = tableName.substring(0, dotIndex);
            this.tableName = tableName.substring(dotIndex + 1);
            return;
        }
        this.tableName = tableName;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    private void setSchemaName(String schemaName) {
        if (schemaName == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)schemaName)) {
            throw new IllegalArgumentException("schemaName must not be blank");
        }
        this.schemaName = schemaName;
    }

    @Override
    public String getSqlExpression() {
        return this.sqlExpression;
    }

    private void setSqlExpression(String sqlExpression) {
        if (sqlExpression == null) {
            throw new IllegalArgumentException("sqlExpression must not be null");
        }
        if (StringUtils.isBlank((CharSequence)sqlExpression)) {
            throw new IllegalArgumentException("sqlExpression must not be blank");
        }
        this.sqlExpression = sqlExpression;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.sqlExpression).append((Object)this.columnName).append((Object)this.tableName).append((Object)this.schemaName).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnImpl other = (ColumnImpl)obj;
        return new EqualsBuilder().append((Object)this.sqlExpression, (Object)other.sqlExpression).append((Object)this.columnName, (Object)other.columnName).append((Object)this.tableName, (Object)other.tableName).append((Object)this.schemaName, (Object)other.schemaName).isEquals();
    }

    public String toString() {
        return "ColumnImpl [columnName=" + this.columnName + ", tableName=" + this.tableName + ", schemaName=" + this.schemaName + ", sqlExpression=" + this.sqlExpression + "]";
    }
}

