/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import org.apache.uima.taeconfigurator.StandardStrings;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.MultiPageEditorContributor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.ContentAssistField32;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.SelectTypeDialog;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.TypesWithNameSpaces;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractDialog
extends Dialog
implements Listener,
StandardStrings {
    private static final boolean contentAssistAvailable;
    protected MultiPageEditor editor;
    protected AbstractSection section;
    protected Button okButton;
    protected Label errorMessageUI;
    protected String title;
    protected String dialogDescription;
    public static final String[] stringArray0;

    protected AbstractDialog(AbstractSection section, String title, String description) {
        super(section.getSection().getShell());
        this.commonInit(section, title, description);
    }

    protected AbstractDialog(Shell shell, String title, String description) {
        super(shell);
        this.commonInit(null, title, description);
    }

    private void commonInit(AbstractSection aSection, String aTitle, String aDescription) {
        this.section = aSection;
        this.editor = null == this.section ? null : this.section.editor;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = aTitle;
        this.dialogDescription = aDescription;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMessage(String msg) {
        this.dialogDescription = msg;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createWideLabel(composite, this.dialogDescription);
        return composite;
    }

    protected Control createDialogArea(Composite parent, Object existing) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createWideLabel(composite, this.dialogDescription);
        if (null != existing) {
            this.getShell().setText(this.getShell().getText().replaceFirst("Add", "Edit"));
        }
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Label createWideLabel(Composite parent, String message) {
        Label label = null;
        label = new Label(parent, 64);
        label.setText(null != message ? message : "");
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        return label;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.okButton = this.getButton(0);
        this.okButton.setEnabled(false);
    }

    protected void setTextAndTip(Button c, String label, String tip) {
        c.setText(label);
        c.setToolTipText(tip);
    }

    protected void setTextAndTip(CCombo c, String label, String tip) {
        c.setText(label);
        c.setToolTipText(tip);
    }

    protected void setTextAndTip(Label c, String label, String tip) {
        c.setText(label);
        c.setToolTipText(tip);
    }

    protected void setTextAndTip(Label c, String label, String tip, int horizStyle, boolean horizGrab) {
        this.setTextAndTip(c, label, tip);
        c.setLayoutData((Object)new GridData(horizStyle, 1, horizGrab, false));
    }

    protected Composite new2ColumnComposite(Composite parent) {
        Composite twoCol = new Composite(parent, 0);
        twoCol.setLayout((Layout)new GridLayout(2, false));
        ((GridLayout)twoCol.getLayout()).marginHeight = 0;
        ((GridLayout)twoCol.getLayout()).marginWidth = 0;
        twoCol.setLayoutData((Object)new GridData(1808));
        return twoCol;
    }

    protected Text newDescription(Composite twoCol, String tip) {
        this.setTextAndTip(new Label(twoCol, 0), "Description:", tip);
        Text t = new Text(twoCol, 2626);
        t.setLayoutData((Object)new GridData(1808));
        ((GridData)t.getLayoutData()).heightHint = 100;
        t.setToolTipText(tip);
        return t;
    }

    protected CCombo newLabeledCCombo(Composite parent, String label, String tip) {
        this.setTextAndTip(new Label(parent, 0), label, tip);
        return this.newCCombo(parent, tip);
    }

    protected CCombo newCCombo(Composite parent, String tip) {
        final CCombo cc = new CCombo(parent, 0x800808);
        cc.setBackground(this.getShell().getDisplay().getSystemColor(1));
        cc.setLayoutData((Object)new GridData(768));
        FontData[] fontData = cc.getFont().getFontData();
        ((GridData)cc.getLayoutData()).heightHint = 2 * fontData[0].getHeight();
        cc.addListener(13, (Listener)this);
        cc.setToolTipText(tip);
        cc.addKeyListener(new KeyListener(){
            private final StringBuffer b = new StringBuffer();

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 8) {
                    if (this.b.length() > 0) {
                        this.b.deleteCharAt(this.b.length() - 1);
                    }
                } else if (Character.isJavaIdentifierPart(e.character) || e.character == '.') {
                    this.b.append(e.character);
                } else {
                    return;
                }
                String[] ccItems = cc.getItems();
                String partial = this.b.toString();
                int iBefore = -1;
                for (int i = 0; i < ccItems.length; ++i) {
                    if (!ccItems[i].startsWith(partial)) continue;
                    iBefore = i;
                    break;
                }
                if (iBefore >= 0) {
                    cc.setText(cc.getItem(iBefore));
                }
            }
        });
        return cc;
    }

    protected Button newButton(Composite parent, int style, String name, String tip) {
        Button b = new Button(parent, style);
        this.setTextAndTip(b, name, tip);
        b.addListener(13, (Listener)this);
        return b;
    }

    protected Text newText(Composite parent, int style, String tip) {
        Text t = new Text(parent, style | 0x800);
        t.setToolTipText(tip);
        t.setLayoutData((Object)new GridData(768));
        t.addListener(2, (Listener)this);
        t.addListener(4, (Listener)this);
        return t;
    }

    protected Text newLabeledText(Composite parent, int style, String label, String tip) {
        this.setTextAndTip(new Label(parent, 0), label, tip);
        return this.newText(parent, style, tip);
    }

    protected Tree newTree(Composite parent, int style) {
        Tree tree = new Tree(parent, style | 0x800);
        GridData gd = new GridData(1808);
        tree.setLayoutData((Object)gd);
        tree.addListener(13, (Listener)this);
        tree.addListener(2, (Listener)this);
        return tree;
    }

    protected Table newTable(Composite parent, int style) {
        Table table = new Table(parent, style | 0x800);
        GridData gd = new GridData(1808);
        table.setLayoutData((Object)gd);
        table.addListener(13, (Listener)this);
        table.addListener(2, (Listener)this);
        return table;
    }

    public int getHitColumn(TreeItem item, Point p) {
        for (int i = item.getParent().getColumnCount() - 1; i >= 0; --i) {
            Rectangle columnBounds = item.getBounds(i);
            if (!columnBounds.contains(p)) continue;
            return i;
        }
        return -1;
    }

    public Composite newButtonContainer(Composite parent) {
        Composite buttonContainer = new Composite(parent, 0);
        buttonContainer.setLayout((Layout)new GridLayout());
        buttonContainer.setLayoutData((Object)new GridData(258));
        return buttonContainer;
    }

    public Button newPushButton(Composite parent, String label, String tip) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setLayoutData((Object)new GridData(258));
        button.setToolTipText(tip);
        button.addListener(13, (Listener)this);
        return button;
    }

    protected void newErrorMessage(Composite c) {
        this.newErrorMessage(c, 1);
    }

    protected void newErrorMessage(Composite twoCol, int span) {
        Label m = new Label(twoCol, 64);
        m.setLayoutData((Object)new GridData(768));
        ((GridData)m.getLayoutData()).horizontalSpan = span;
        ((GridData)m.getLayoutData()).widthHint = this.convertHorizontalDLUsToPixels(300);
        this.errorMessageUI = m;
    }

    protected void setErrorMessage(String msg) {
        this.errorMessageUI.setText(msg);
        Composite shell = this.errorMessageUI.getParent();
        while (!(shell instanceof Shell)) {
            shell = shell.getParent();
        }
        shell.setSize(shell.computeSize(-1, -1));
    }

    public void handleEvent(Event event) {
        if (this.okButton != null) {
            this.enableOK();
        }
    }

    protected void superButtonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.copyValuesFromGUI();
            if (!this.isValid()) {
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    public abstract void copyValuesFromGUI();

    public abstract boolean isValid();

    protected Control createButtonBar(Composite c) {
        Control returnValue = super.createButtonBar(c);
        this.enableOK();
        return returnValue;
    }

    public abstract void enableOK();

    public boolean useQualifiedTypes() {
        return MultiPageEditorContributor.getUseQualifiedTypes();
    }

    protected String[] getAllTypesAsSortedArray() {
        String[] allTypes = this.section.editor.allTypes.get().keySet().toArray(stringArray0);
        Arrays.sort(allTypes, new Comparator(){

            public int compare(Object o1, Object o2) {
                String shortName2;
                String shortName1 = AbstractSection.getShortName((String)o1);
                if (!shortName1.equals(shortName2 = AbstractSection.getShortName((String)o2))) {
                    return shortName1.compareTo(shortName2);
                }
                String namespace1 = AbstractSection.getNameSpace((String)o1);
                String namespace2 = AbstractSection.getNameSpace((String)o2);
                return namespace1.compareTo(namespace2);
            }
        });
        return allTypes;
    }

    protected Text newLabeledTypeInput(AbstractSection aSection, Composite parent, String label, String tip) {
        this.setTextAndTip(new Label(parent, 0), label, tip);
        return this.newTypeInput(aSection, parent);
    }

    protected Text newTypeInput(AbstractSection aSection, Composite twoCol) {
        Text text;
        Composite tc = this.new2ColumnComposite(twoCol);
        final TypesWithNameSpaces candidatesToPickFrom = this.getTypeSystemInfoList();
        if (contentAssistAvailable) {
            ContentAssistField32 caf = new ContentAssistField32(tc, candidatesToPickFrom);
            text = caf.getControl();
        } else {
            text = this.newText(tc, 2048, "");
        }
        text.setToolTipText("Enter a Type name." + (contentAssistAvailable ? "Content Assist is available (press Ctrl + Space)" : ""));
        text.getParent().setLayoutData((Object)new GridData(768));
        text.addListener(2, (Listener)this);
        text.addListener(4, (Listener)this);
        text.addListener(24, (Listener)this);
        Button browseButton = this.newPushButton(tc, "Browse", "Click here to browse possible types");
        browseButton.removeListener(13, (Listener)this);
        final AbstractSection finalSection = aSection;
        browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AbstractDialog.this.errorMessageUI.setText("");
                SelectTypeDialog dialog = new SelectTypeDialog(finalSection, candidatesToPickFrom);
                if (dialog.open() != 0) {
                    return;
                }
                text.setText(null == dialog.nameSpaceName || "".equals(dialog.nameSpaceName) ? dialog.typeName : dialog.nameSpaceName + "." + dialog.typeName);
                if (AbstractDialog.this.okButton != null) {
                    AbstractDialog.this.enableOK();
                }
            }
        });
        return text;
    }

    public void textModifyCallback(Event e) {
    }

    public TypesWithNameSpaces getTypeSystemInfoList() {
        return new TypesWithNameSpaces();
    }

    protected boolean typeContainedInTypeSystemInfoList(String fullTypeName, TypesWithNameSpaces types) {
        String key = AbstractSection.getShortName(fullTypeName);
        String nameSpace = AbstractSection.getNameSpace(fullTypeName);
        Set s = (Set)types.sortedNames.get(key);
        if (null == s) {
            return false;
        }
        return s.contains(nameSpace);
    }

    public static String nullIf0lengthString(String v) {
        if ("".equals(v)) {
            return null;
        }
        return v;
    }

    public static String convertNull(String v) {
        if (null == v) {
            return "";
        }
        return v;
    }

    static {
        boolean contentAssistIsOK = false;
        try {
            Class.forName("org.eclipse.ui.fieldassist.ContentAssistField");
            contentAssistIsOK = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        contentAssistAvailable = contentAssistIsOK;
        stringArray0 = new String[0];
    }
}

