/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.bool.SimpleBooleanExpression;
import org.apache.uima.ruta.expression.string.SimpleStringExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.type.RutaColoring;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ColorAction
extends AbstractRutaAction {
    private StringExpression bgcolor;
    private StringExpression fgcolor;
    private BooleanExpression selected;
    private TypeExpression type;

    public ColorAction(TypeExpression type, StringExpression bgcolor, StringExpression fgcolor, BooleanExpression selected) {
        this.type = type;
        this.bgcolor = bgcolor == null ? new SimpleStringExpression("red") : bgcolor;
        this.fgcolor = fgcolor == null ? new SimpleStringExpression("red") : fgcolor;
        this.selected = selected == null ? new SimpleBooleanExpression(false) : selected;
    }

    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        Type casType = stream.getJCas().getCasType(RutaColoring.type);
        FeatureStructure newAnnotationFS = stream.getCas().createFS(casType);
        RutaColoring coloring = null;
        if (newAnnotationFS instanceof RutaColoring) {
            coloring = (RutaColoring)newAnnotationFS;
            coloring.setBgColor(this.bgcolor.getStringValue(element.getParent()));
            coloring.setFgColor(this.fgcolor.getStringValue(element.getParent()));
            coloring.setSelected(this.selected.getBooleanValue(element.getParent()));
            coloring.setTargetType(this.type.getType(element.getParent()).getName());
            coloring.addToIndexes();
        }
    }

    public StringExpression getFgColor() {
        return this.fgcolor;
    }

    public StringExpression getBgColor() {
        return this.bgcolor;
    }

    public BooleanExpression getSelected() {
        return this.selected;
    }

    public TypeExpression getType() {
        return this.type;
    }
}

