/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.resource.WordTableExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.resource.RutaTable;
import org.apache.uima.ruta.resource.RutaWordList;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkTableAction
extends AbstractRutaAction {
    private final TypeExpression typeExpr;
    private final WordTableExpression tableExpr;
    private final Map<StringExpression, NumberExpression> featureMap;
    private final NumberExpression indexExpr;
    private final BooleanExpression ignoreCase;
    private final NumberExpression ignoreLength;
    private final StringExpression ignoreChar;
    private final NumberExpression maxIgnoreChar;

    public MarkTableAction(TypeExpression typeExpr, NumberExpression indexExpr, WordTableExpression tableExpr, Map<StringExpression, NumberExpression> featureMap, BooleanExpression ignoreCase, NumberExpression ignoreLength, StringExpression ignoreChar, NumberExpression maxIgnoreChar) {
        this.typeExpr = typeExpr;
        this.indexExpr = indexExpr;
        this.tableExpr = tableExpr;
        this.featureMap = featureMap;
        this.ignoreCase = ignoreCase;
        this.ignoreLength = ignoreLength;
        this.ignoreChar = ignoreChar;
        this.maxIgnoreChar = maxIgnoreChar;
    }

    @Override
    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        RutaBlock block = element.getParent();
        RutaTable table = this.tableExpr.getTable(block);
        int index = this.indexExpr.getIntegerValue(block);
        Type type = this.typeExpr.getType(block);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (StringExpression each : this.featureMap.keySet()) {
            map.put(each.getStringValue(block), this.featureMap.get(each).getIntegerValue(block));
        }
        boolean ignoreCaseValue = this.ignoreCase != null ? this.ignoreCase.getBooleanValue(element.getParent()) : false;
        int ignoreLengthValue = this.ignoreLength != null ? this.ignoreLength.getIntegerValue(element.getParent()) : 0;
        String ignoreCharValue = this.ignoreChar != null ? this.ignoreChar.getStringValue(element.getParent()) : "";
        int maxIgnoreCharValue = this.maxIgnoreChar != null ? this.maxIgnoreChar.getIntegerValue(element.getParent()) : 0;
        RutaWordList wordList = table.getWordList(index);
        Collection<AnnotationFS> found = wordList.find(stream, ignoreCaseValue, ignoreLengthValue, ignoreCharValue.toCharArray(), maxIgnoreCharValue, true);
        for (AnnotationFS annotationFS : found) {
            List<String> rowWhere = table.getRowWhere(index - 1, annotationFS.getCoveredText());
            FeatureStructure newFS = stream.getCas().createFS(type);
            if (newFS instanceof Annotation) {
                Annotation a = (Annotation)newFS;
                a.setBegin(annotationFS.getBegin());
                a.setEnd(annotationFS.getEnd());
                stream.addAnnotation((AnnotationFS)a, match);
            }
            TOP newStructure = null;
            if (!(newFS instanceof TOP)) continue;
            newStructure = (TOP)newFS;
            this.fillFeatures(newStructure, map, annotationFS, element, rowWhere, stream);
            newStructure.addToIndexes();
        }
    }

    private void fillFeatures(TOP structure, Map<String, Integer> map, AnnotationFS annotationFS, RuleElement element, List<String> row, RutaStream stream) {
        List featuresList = structure.getType().getFeatures();
        for (int i = 0; i < featuresList.size(); ++i) {
            Number d;
            Feature targetFeature = (Feature)featuresList.get(i);
            String name = targetFeature.getName();
            String shortFName = name.substring(name.indexOf(":") + 1, name.length());
            Integer entryIndex = map.get(shortFName);
            Type range = targetFeature.getRange();
            if (entryIndex == null || row.size() < entryIndex) continue;
            String value = row.get(entryIndex - 1);
            if (range.getName().equals("uima.cas.String")) {
                structure.setStringValue(targetFeature, value);
                continue;
            }
            if (range.getName().equals("uima.cas.Integer")) {
                Integer integer = Integer.parseInt(value);
                structure.setIntValue(targetFeature, integer.intValue());
                continue;
            }
            if (range.getName().equals("uima.cas.Double")) {
                d = Double.parseDouble(value);
                structure.setDoubleValue(targetFeature, ((Double)d).doubleValue());
                continue;
            }
            if (range.getName().equals("uima.cas.Float")) {
                d = Float.valueOf(Float.parseFloat(value));
                structure.setFloatValue(targetFeature, ((Float)d).floatValue());
                continue;
            }
            if (range.getName().equals("uima.cas.Byte")) {
                d = Byte.parseByte(value);
                structure.setByteValue(targetFeature, ((Byte)d).byteValue());
                continue;
            }
            if (range.getName().equals("uima.cas.Short")) {
                d = Short.parseShort(value);
                structure.setShortValue(targetFeature, ((Short)d).shortValue());
                continue;
            }
            if (range.getName().equals("uima.cas.Long")) {
                d = Long.parseLong(value);
                structure.setLongValue(targetFeature, ((Long)d).longValue());
                continue;
            }
            if (!range.getName().equals("uima.cas.Boolean")) continue;
            Boolean b = Boolean.parseBoolean(value);
            structure.setBooleanValue(targetFeature, b.booleanValue());
        }
    }

    public TypeExpression getTypeExpr() {
        return this.typeExpr;
    }

    public WordTableExpression getTableExpr() {
        return this.tableExpr;
    }

    public Map<StringExpression, NumberExpression> getFeatureMap() {
        return this.featureMap;
    }

    public NumberExpression getIndexExpr() {
        return this.indexExpr;
    }

    public BooleanExpression getIgnoreCase() {
        return this.ignoreCase;
    }

    public NumberExpression getIgnoreLength() {
        return this.ignoreLength;
    }

    public StringExpression getIgnoreChar() {
        return this.ignoreChar;
    }

    public NumberExpression getMaxIgnoreChar() {
        return this.maxIgnoreChar;
    }
}

