/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.TypeSensitiveAction;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmarkAction
extends TypeSensitiveAction {
    private List<NumberExpression> list;
    private BooleanExpression allAnchor;

    public UnmarkAction(TypeExpression type, List<NumberExpression> list, BooleanExpression b) {
        super(type);
        this.list = list;
        this.allAnchor = b;
    }

    @Override
    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        Type t = this.type.getType(element.getParent());
        boolean allAtAnchor = false;
        if (this.allAnchor != null) {
            allAtAnchor = this.allAnchor.getBooleanValue(element.getParent());
        }
        List<Integer> indexList = this.getIndexList(element, this.list);
        List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotations(stream, indexList, element.getContainer());
        for (AnnotationFS annotationFS : matchedAnnotations) {
            RutaBasic beginAnchor = stream.getBeginAnchor(annotationFS.getBegin());
            Set<AnnotationFS> beginAnchors = beginAnchor.getBeginAnchors(t);
            if (beginAnchors == null) continue;
            for (AnnotationFS each : new ArrayList<AnnotationFS>(beginAnchors)) {
                if (!allAtAnchor && each.getEnd() != annotationFS.getEnd()) continue;
                stream.removeAnnotation(each, t);
            }
        }
    }

    public List<NumberExpression> getList() {
        return this.list;
    }

    public BooleanExpression getAllAnchor() {
        return this.allAnchor;
    }

    protected List<Integer> getIndexList(RuleElement element, List<NumberExpression> list) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        if (list == null || list.isEmpty()) {
            int self = element.getContainer().getRuleElements().indexOf(element) + 1;
            indexList.add(self);
            return indexList;
        }
        int last = 0x7FFFFFFE;
        for (NumberExpression each : list) {
            int value = each.getIntegerValue(element.getParent());
            for (int i = Math.min(value, last + 1); i < value; ++i) {
                indexList.add(i);
            }
            indexList.add(value);
        }
        return indexList;
    }
}

