/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.engine;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.JCas;
import org.apache.uima.ruta.type.RutaColoring;
import org.apache.uima.tools.stylemap.ColorParser;
import org.apache.uima.tools.stylemap.StyleMapEntry;
import org.apache.uima.tools.stylemap.StyleMapXmlParser;
import org.apache.uima.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleMapFactory {
    private Map<String, String> colorNameMap;

    public StyleMapFactory() {
        this.initializeColorNameMap();
    }

    private void initializeColorNameMap() {
        this.colorNameMap = new HashMap<String, String>();
        this.colorNameMap.put("#000000", "black");
        this.colorNameMap.put("#c0c0c0", "silver");
        this.colorNameMap.put("#808080", "gray");
        this.colorNameMap.put("#ffffff", "white");
        this.colorNameMap.put("#800000", "maroon");
        this.colorNameMap.put("#ff0000", "red");
        this.colorNameMap.put("#800080", "purple");
        this.colorNameMap.put("#ff00ff", "fuchsia");
        this.colorNameMap.put("#008000", "green");
        this.colorNameMap.put("#00ff00", "lime");
        this.colorNameMap.put("#808000", "olive");
        this.colorNameMap.put("#ffff00", "yellow");
        this.colorNameMap.put("#000080", "navy");
        this.colorNameMap.put("#0000ff", "blue");
        this.colorNameMap.put("#00ffff", "aqua");
        this.colorNameMap.put("#000000", "black");
        this.colorNameMap.put("#add8e6", "lightblue");
        this.colorNameMap.put("#90ee90", "lightgreen");
        this.colorNameMap.put("#ffa500", "orange");
        this.colorNameMap.put("#ffc0cb", "pink");
        this.colorNameMap.put("#fa8072", "salmon");
        this.colorNameMap.put("#00ffff", "cyan");
        this.colorNameMap.put("#ee82ee", "violet");
        this.colorNameMap.put("#d2b48c", "tan");
        this.colorNameMap.put("#a52a2a", "brown");
        this.colorNameMap.put("#ffffff", "white");
        this.colorNameMap.put("#9370db", "mediumpurple");
        this.colorNameMap.put("black", "#000000");
        this.colorNameMap.put("silver", "#c0c0c0");
        this.colorNameMap.put("gray", "#808080");
        this.colorNameMap.put("white", "#ffffff");
        this.colorNameMap.put("maroon", "#800000");
        this.colorNameMap.put("red", "#ff0000");
        this.colorNameMap.put("purple", "#800080");
        this.colorNameMap.put("fuchsia", "#ff00ff");
        this.colorNameMap.put("green", "#008000");
        this.colorNameMap.put("lime", "#00ff00");
        this.colorNameMap.put("olive", "#808000");
        this.colorNameMap.put("yellow", "#ffff00");
        this.colorNameMap.put("navy", "#000080");
        this.colorNameMap.put("blue", "#0000ff");
        this.colorNameMap.put("aqua", "#00ffff");
        this.colorNameMap.put("black", "#000000");
        this.colorNameMap.put("lightblue", "#add8e6");
        this.colorNameMap.put("lightgreen", "#90ee90");
        this.colorNameMap.put("orange", "#ffa500");
        this.colorNameMap.put("pink", "#ffc0cb");
        this.colorNameMap.put("salmon", "#fa8072");
        this.colorNameMap.put("cyan", "#00ffff");
        this.colorNameMap.put("violet", "#ee82ee");
        this.colorNameMap.put("tan", "#d2b48c");
        this.colorNameMap.put("brown", "#a52a2a");
        this.colorNameMap.put("white", "#ffffff");
        this.colorNameMap.put("mediumpurple", "#9370db");
    }

    public void createStyleMap(String styleMapLocation, JCas jcas) throws IOException {
        List<StyleMapEntry> styleList = this.createStyleList(jcas);
        String styleXml = this.createStyleXml(styleList);
        this.writeStyleFile(styleXml, styleMapLocation);
    }

    private String createStyleXml(List<StyleMapEntry> styleList) {
        StringBuffer result = new StringBuffer();
        result.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        result.append("<styleMap>\n");
        for (StyleMapEntry e : styleList) {
            result.append("<rule>\n");
            result.append("<pattern>");
            result.append(e.getPattern());
            result.append("</pattern>\n");
            result.append("<label>");
            String label = e.getLabel();
            if (label != null) {
                if (!StringUtils.isEmpty(label)) {
                    result.append(label);
                } else {
                    result.append(e.getAnnotationTypeName());
                }
            } else {
                result.append(e.getAnnotationTypeName());
            }
            result.append("</label>\n");
            result.append("<style>");
            String foregroundColor = "#" + Integer.toHexString(e.getForeground().getRGB()).substring(2);
            String backgroundColor = "#" + Integer.toHexString(e.getBackground().getRGB()).substring(2);
            if (this.colorNameMap.containsKey(foregroundColor)) {
                result.append("color:" + this.colorNameMap.get(foregroundColor) + ";");
            } else {
                result.append("color:" + foregroundColor + ";");
            }
            if (this.colorNameMap.containsKey(backgroundColor)) {
                result.append("background:" + this.colorNameMap.get(backgroundColor) + ";");
            } else {
                result.append("background:" + backgroundColor + ";");
            }
            Boolean ck = e.getChecked();
            String ckString = ck.toString();
            Boolean hid = Boolean.FALSE;
            String hidString = hid.toString();
            if (hidString.equals("true")) {
                ckString = "false";
            }
            result.append("checked:" + ckString + ";");
            result.append("hidden:" + hidString + ";");
            result.append("</style>\n");
            result.append("</rule>\n");
        }
        result.append("</styleMap>\n");
        return result.toString();
    }

    private void writeStyleFile(String output, String styleMapLocation) throws IOException {
        File file = new File(styleMapLocation);
        FileUtils.saveString2File((String)output, (File)file);
    }

    private List<StyleMapEntry> createStyleList(JCas jcas) {
        ArrayList<StyleMapEntry> result = new ArrayList<StyleMapEntry>();
        Type type = jcas.getCasType(RutaColoring.type);
        FSIterator iterator = jcas.getFSIndexRepository().getAllIndexedFS(type);
        while (iterator.hasNext()) {
            RutaColoring each = (RutaColoring)((Object)iterator.next());
            StyleMapEntry entry = new StyleMapEntry();
            entry.setAnnotationTypeName(each.getTargetType());
            String fgColor = each.getFgColor();
            entry.setForeground(this.parseColorBackground(fgColor));
            String bgColor = each.getBgColor();
            entry.setBackground(this.parseColorBackground(bgColor));
            entry.setChecked(Boolean.valueOf(each.getSelected()));
            result.add(entry);
        }
        return result;
    }

    private Color parseColorBackground(String color) {
        if (color == null) {
            return Color.BLACK;
        }
        if (color.startsWith("#")) {
            return Color.decode(color);
        }
        String string = this.colorNameMap.get(color);
        if (string != null) {
            return Color.decode(string);
        }
        return Color.LIGHT_GRAY;
    }

    private Color parseColorForeground(String color) {
        if (color.startsWith("#")) {
            return Color.decode(color);
        }
        String string = this.colorNameMap.get(color);
        if (string != null) {
            return Color.decode(string);
        }
        return Color.BLACK;
    }

    public Map<String, StyleMapEntry> parseStyleMap(String styleFileString) {
        HashMap<String, StyleMapEntry> result = new HashMap<String, StyleMapEntry>();
        StyleMapXmlParser smxp = new StyleMapXmlParser(styleFileString);
        ColorParser cp = new ColorParser();
        for (int i = 0; i < smxp.annotType.size(); ++i) {
            String typeName = (String)smxp.annotType.elementAt(i);
            String labelString = (String)smxp.styleLabel.elementAt(i);
            String featureValue = (String)smxp.featureValue.elementAt(i);
            String styleColor = smxp.styleColor.elementAt(i).toString();
            StyleMapEntry e = cp.parseAndAssignColors(typeName, featureValue, labelString, styleColor);
            result.put(typeName, e);
        }
        return result;
    }

    public Map<String, StyleMapEntry> parseStyleMapDOM(String styleFileString) {
        HashMap<String, StyleMapEntry> result = new HashMap<String, StyleMapEntry>();
        if (styleFileString == null) {
            return result;
        }
        File styleMapFile = new File(styleFileString);
        Document parse = null;
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            FileInputStream stream = new FileInputStream(styleMapFile);
            parse = db.parse(stream);
            stream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        Element root = parse.getDocumentElement();
        NodeList nodeList = root.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if (!nodeName.equals("rule")) continue;
            NodeList childrenList = node.getChildNodes();
            String type = "";
            String label = "";
            String colorText = "";
            for (int j = 0; j < childrenList.getLength(); ++j) {
                Node child = childrenList.item(j);
                String childName = child.getNodeName();
                if (childName.equals("pattern")) {
                    type = this.getTextValue(child);
                    continue;
                }
                if (childName.equals("label")) {
                    label = this.getTextValue(child);
                    continue;
                }
                if (!childName.equals("style")) continue;
                colorText = this.getTextValue(child);
            }
            StyleMapEntry styleMapEntry = this.getStyleMapEntry(type, label, colorText);
            result.put(styleMapEntry.getAnnotationTypeName(), styleMapEntry);
        }
        return result;
    }

    protected StyleMapEntry getStyleMapEntry(String type, String label, String styleColor) {
        StyleMapEntry result = new StyleMapEntry();
        result.setAnnotationTypeName(type);
        result.setLabel(label);
        StringTokenizer token = new StringTokenizer(styleColor, ":;");
        if (!token.hasMoreTokens()) {
            return null;
        }
        token.nextToken();
        String fgString = token.nextToken().toLowerCase().trim();
        result.setForeground(this.parseColorForeground(fgString));
        token.nextToken();
        String bgString = token.nextToken().toLowerCase().trim();
        result.setBackground(this.parseColorBackground(bgString));
        boolean checked = false;
        if (token.hasMoreTokens()) {
            String ck = token.nextToken();
            String tf = token.nextToken();
            if (ck.equals("checked")) {
                if (tf.equals("false")) {
                    checked = false;
                } else if (tf.equals("true")) {
                    checked = true;
                }
            }
        }
        result.setChecked(Boolean.valueOf(checked));
        boolean hidden = false;
        if (token.hasMoreTokens()) {
            String ck = token.nextToken();
            String tf = token.nextToken();
            if (ck.equals("hidden") && tf.equals("true")) {
                hidden = true;
            }
        }
        result.setHidden(Boolean.valueOf(hidden));
        return result;
    }

    private String getTextValue(Node node) {
        Node first = node.getFirstChild();
        if (first != null) {
            return ((Text)first).getNodeValue().trim();
        }
        return null;
    }
}

