/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.ConstraintFactory;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.FSTypeConstraint;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.rule.AbstractRuleElement;
import org.apache.uima.ruta.rule.ComposedRuleElement;
import org.apache.uima.ruta.rule.ComposedRuleElementMatch;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleApply;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementContainer;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.rule.RutaDisjunctiveMatcher;
import org.apache.uima.ruta.rule.RutaLiteralMatcher;
import org.apache.uima.ruta.rule.RutaMatcher;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.rule.RutaTypeMatcher;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.type.RutaFrame;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildCardRuleElement
extends AbstractRuleElement {
    public WildCardRuleElement(List<AbstractRutaCondition> conditions, List<AbstractRutaAction> actions, RuleElementContainer container, RutaBlock parent) {
        super(null, conditions, actions, container, parent);
    }

    @Override
    public void startMatch(RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        this.continueMatch(true, null, ruleMatch, ruleApply, containerMatch, null, entryPoint, stream, crowd);
    }

    @Override
    public void continueMatch(boolean after, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RutaRuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        RuleElement nextElement = this.getContainer().getNextElement(after, this);
        this.tryWithNextRuleElement(nextElement, after, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
    }

    private void tryWithNextRuleElement(RuleElement nextElement, boolean after, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RutaRuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        if (nextElement == null) {
            AnnotationFS afs = this.getCoveredByWildCard(after, annotation, null, stream);
            this.doMatch(afs, ruleMatch, containerMatch, annotation == null, stream, crowd);
            ComposedRuleElement composed = (ComposedRuleElement)this.getContainer();
            composed.fallbackContinue(after, ruleMatch.matched(), afs, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
        } else if (nextElement instanceof RutaRuleElement) {
            RutaRuleElement re = (RutaRuleElement)nextElement;
            RutaMatcher matcher = re.getMatcher();
            if (matcher instanceof RutaTypeMatcher) {
                this.tryWithNextType(after, annotation, nextElement, null, ruleMatch, ruleApply, containerMatch, sideStepOrigin, stream, crowd);
            } else if (matcher instanceof RutaLiteralMatcher) {
                this.tryWithNextLiteral(after, annotation, re, ruleMatch, ruleApply, containerMatch, sideStepOrigin, stream, crowd);
            } else if (matcher instanceof RutaDisjunctiveMatcher) {
                this.tryWithNextType(after, annotation, re, null, ruleMatch, ruleApply, containerMatch, sideStepOrigin, stream, crowd);
            }
        } else if (nextElement instanceof ComposedRuleElement) {
            ComposedRuleElement cre = (ComposedRuleElement)nextElement;
            this.tryWithNextComposed(after, annotation, cre, ruleMatch, ruleApply, containerMatch, sideStepOrigin, stream, crowd);
            RuleElement nextInnerRuleElement = null;
            nextInnerRuleElement = after ? cre.getFirstElement() : cre.getLastElement();
            ComposedRuleElementMatch composedMatch = new ComposedRuleElementMatch(cre, containerMatch);
            if (containerMatch == null) {
                ruleMatch.setRootMatch(composedMatch);
            } else {
                containerMatch.addInnerMatch(this, composedMatch, false);
            }
            this.tryWithNextRuleElement(nextInnerRuleElement, after, annotation, ruleMatch, ruleApply, composedMatch, sideStepOrigin, entryPoint, stream, crowd);
        } else if (nextElement instanceof WildCardRuleElement) {
            CAS cas = stream.getCas();
            this.tryWithNextType(after, annotation, nextElement, cas.getAnnotationType(), ruleMatch, ruleApply, containerMatch, sideStepOrigin, stream, crowd);
        }
    }

    private void tryWithNextComposed(boolean after, AnnotationFS annotation, ComposedRuleElement cre, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RutaRuleElement sideStepOrigin, RutaStream stream, InferenceCrowd crowd) {
        Object nextOne = annotation;
        boolean doneHere = false;
        while (!doneHere && (nextOne = this.getNextPositionForComposed(cre, after, (AnnotationFS)nextOne, stream)) != null) {
            RutaBasic endAnchor = stream.getEndAnchor(nextOne.getBegin());
            ComposedRuleElementMatch extendedContainerMatch = containerMatch.copy();
            RuleMatch extendedMatch = ruleMatch.copy(extendedContainerMatch);
            AnnotationFS coveredByWildCard = this.getCoveredByWildCard(after, annotation, (AnnotationFS)nextOne, stream);
            this.doMatch(coveredByWildCard, extendedMatch, extendedContainerMatch, annotation == null, stream, crowd);
            if (extendedMatch.matched()) {
                cre.continueMatch(after, (AnnotationFS)endAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, cre, stream, crowd);
                List<RuleElementMatch> nextList = extendedContainerMatch.getInnerMatches().get(cre);
                boolean matched = this.hasMatched(nextList);
                if (!matched) {
                    nextOne = stream.getAnchor(after, this.getNextPointer(!after, (AnnotationFS)nextOne));
                    continue;
                }
                doneHere = true;
                continue;
            }
            nextOne = annotation;
        }
        if (!doneHere) {
            cre.continueMatch(after, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, null, stream, crowd);
        }
    }

    private boolean hasMatched(List<RuleElementMatch> nextList) {
        if (nextList == null || nextList.isEmpty()) {
            return false;
        }
        boolean result = true;
        for (RuleElementMatch each : nextList) {
            result &= each.matched();
        }
        return result;
    }

    private AnnotationFS getNextPositionForComposed(ComposedRuleElement cre, boolean after, AnnotationFS annotation, RutaStream stream) {
        RuleElement element = this.getNextAtomicRuleElement(cre, after);
        AnnotationFS result = null;
        if (element instanceof WildCardRuleElement) {
            if (after) {
                return stream.getAnchor(after, annotation.getEnd());
            }
            return stream.getAnchor(after, annotation.getBegin());
        }
        RutaRuleElement re = (RutaRuleElement)element;
        RutaMatcher matcher = re.getMatcher();
        if (matcher instanceof RutaTypeMatcher) {
            FSIterator<AnnotationFS> iterator = this.getIterator(after, annotation, re, null, stream);
            if (iterator.isValid()) {
                result = (AnnotationFS)iterator.get();
            }
        } else if (matcher instanceof RutaLiteralMatcher) {
            int pointer;
            RutaLiteralMatcher lm = (RutaLiteralMatcher)matcher;
            StringExpression expression = lm.getExpression();
            String stringValue = expression.getStringValue(this.parent);
            AnnotationFS documentAnnotation = stream.getDocumentAnnotation();
            int delta = documentAnnotation.getBegin();
            String document = documentAnnotation.getCoveredText();
            int indexOf = document.indexOf(stringValue, pointer = annotation.getEnd() - delta);
            if (indexOf < 0) {
                return null;
            }
            return stream.getAnchor(after, indexOf);
        }
        return result;
    }

    private RuleElement getNextAtomicRuleElement(ComposedRuleElement cre, boolean after) {
        if (after) {
            RuleElement firstElement = cre.getFirstElement();
            if (firstElement instanceof ComposedRuleElement) {
                return this.getNextAtomicRuleElement((ComposedRuleElement)firstElement, after);
            }
            return firstElement;
        }
        RuleElement lastElement = cre.getLastElement();
        if (lastElement instanceof ComposedRuleElement) {
            return this.getNextAtomicRuleElement((ComposedRuleElement)lastElement, after);
        }
        return lastElement;
    }

    private void tryWithNextType(boolean after, AnnotationFS annotation, RuleElement nextElement, Type defaultType, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RutaRuleElement sideStepOrigin, RutaStream stream, InferenceCrowd crowd) {
        FSIterator<AnnotationFS> iterator = this.getIterator(after, annotation, nextElement, defaultType, stream);
        boolean doneHere = false;
        while (!doneHere && iterator.isValid() && stream.isVisible((AnnotationFS)iterator.get())) {
            AnnotationFS nextOne = (AnnotationFS)iterator.get();
            RutaBasic endAnchor = stream.getEndAnchor(nextOne.getBegin());
            ComposedRuleElementMatch extendedContainerMatch = containerMatch.copy();
            RuleMatch extendedMatch = ruleMatch.copy(extendedContainerMatch);
            AnnotationFS coveredByWildCard = this.getCoveredByWildCard(after, annotation, nextOne, stream);
            this.doMatch(coveredByWildCard, extendedMatch, extendedContainerMatch, annotation == null, stream, crowd);
            if (extendedMatch.matched()) {
                nextElement.continueMatch(after, (AnnotationFS)endAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, nextElement, stream, crowd);
                List<RuleElementMatch> nextList = extendedContainerMatch.getInnerMatches().get(nextElement);
                if (nextList == null || nextList.isEmpty()) {
                    this.moveOn(after, iterator);
                    continue;
                }
                doneHere = true;
                continue;
            }
            this.moveOn(after, iterator);
        }
    }

    private FSIterator<AnnotationFS> getIterator(boolean after, AnnotationFS annotation, RuleElement nextElement, Type defaultType, RutaStream stream) {
        CAS cas = stream.getCas();
        FSIterator<AnnotationFS> iterator = null;
        if (defaultType == null) {
            RutaRuleElement re = (RutaRuleElement)nextElement;
            RutaMatcher matcher = re.getMatcher();
            if (matcher instanceof RutaTypeMatcher) {
                RutaTypeMatcher typeMatcher = (RutaTypeMatcher)re.getMatcher();
                List<Type> types = typeMatcher.getTypes(this.parent, stream);
                Type type = types.get(0);
                iterator = this.getIteratorOfType(type, annotation, stream);
            } else if (matcher instanceof RutaDisjunctiveMatcher) {
                List<Type> types = matcher.getTypes(this.parent, stream);
                iterator = this.getIteratorForDisjunctive(cas, types, after, annotation, stream);
            }
        } else {
            iterator = this.getIteratorOfType(defaultType, annotation, stream);
        }
        return iterator;
    }

    private FSIterator<AnnotationFS> getIteratorOfType(Type type, AnnotationFS annotation, RutaStream stream) {
        CAS cas = stream.getCas();
        FSIterator result = null;
        if (stream.getDocumentAnnotation().equals(cas.getDocumentAnnotation())) {
            result = annotation == null ? cas.getAnnotationIndex(type).iterator() : cas.getAnnotationIndex(type).iterator((FeatureStructure)annotation);
        } else {
            JCas jcas = null;
            try {
                jcas = cas.getJCas();
            }
            catch (CASException e) {
                e.printStackTrace();
            }
            RutaFrame window = new RutaFrame(jcas, stream.getDocumentAnnotation().getBegin(), stream.getDocumentAnnotation().getEnd());
            if (annotation == null) {
                result = cas.getAnnotationIndex(type).subiterator((AnnotationFS)window);
            } else {
                result = cas.getAnnotationIndex(type).subiterator((AnnotationFS)window);
                result.moveTo((FeatureStructure)annotation);
            }
        }
        return result;
    }

    private void tryWithNextLiteral(boolean after, AnnotationFS annotation, RutaRuleElement nextElement, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RutaRuleElement sideStepOrigin, RutaStream stream, InferenceCrowd crowd) {
        RutaLiteralMatcher matcher = (RutaLiteralMatcher)nextElement.getMatcher();
        StringExpression expression = matcher.getExpression();
        String stringValue = expression.getStringValue(this.parent);
        AnnotationFS documentAnnotation = stream.getDocumentAnnotation();
        int delta = documentAnnotation.getBegin();
        String document = documentAnnotation.getCoveredText();
        int pointer = 0;
        if (annotation != null) {
            pointer = annotation.getEnd() - delta;
        }
        int indexOf = 0;
        boolean doneHere = false;
        while (!doneHere && (indexOf = document.indexOf(stringValue, pointer)) < document.length()) {
            if (indexOf < 0) {
                nextElement.continueMatch(after, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, null, stream, crowd);
                doneHere = true;
                break;
            }
            RutaBasic anchor = stream.getAnchor(after, indexOf + delta);
            RutaBasic endAnchor = stream.getAnchor(!after, indexOf + delta);
            ComposedRuleElementMatch extendedContainerMatch = containerMatch.copy();
            RuleMatch extendedMatch = ruleMatch.copy(extendedContainerMatch);
            AnnotationFS coveredByWildCard = this.getCoveredByWildCard(after, annotation, (AnnotationFS)anchor, stream);
            this.doMatch(coveredByWildCard, extendedMatch, extendedContainerMatch, annotation == null, stream, crowd);
            if (extendedMatch.matched()) {
                nextElement.continueMatch(after, (AnnotationFS)endAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, nextElement, stream, crowd);
                List<RuleElementMatch> nextList = extendedContainerMatch.getInnerMatches().get(nextElement);
                if (nextList == null || nextList.isEmpty()) {
                    pointer = this.getNextPointer(after, (AnnotationFS)anchor);
                    continue;
                }
                doneHere = true;
                continue;
            }
            pointer = this.getNextPointer(after, (AnnotationFS)anchor);
        }
    }

    private int getNextPointer(boolean after, AnnotationFS anchor) {
        if (after) {
            return anchor.getEnd();
        }
        return anchor.getBegin();
    }

    private FSIterator<AnnotationFS> getIteratorForDisjunctive(CAS cas, List<Type> types, boolean after, AnnotationFS annotation, RutaStream stream) {
        ConstraintFactory cf = cas.getConstraintFactory();
        FSTypeConstraint typeConstraint = cf.createTypeConstraint();
        for (Type each : types) {
            typeConstraint.add(each);
        }
        FSIterator windowIt = cas.getAnnotationIndex().subiterator(stream.getDocumentAnnotation());
        FSIterator iterator = cas.createFilteredIterator(windowIt, (FSMatchConstraint)typeConstraint);
        if (annotation != null) {
            iterator.moveTo((FeatureStructure)annotation);
            if (!after) {
                iterator.moveToPrevious();
            }
        } else if (after) {
            iterator.moveToFirst();
        } else {
            iterator.moveToLast();
        }
        return iterator;
    }

    private void moveOn(boolean after, FSIterator<AnnotationFS> iterator) {
        if (after) {
            iterator.moveToNext();
        } else {
            iterator.moveToPrevious();
        }
    }

    private AnnotationFS getCoveredByWildCard(boolean after, AnnotationFS last, AnnotationFS next, RutaStream stream) {
        CAS cas = stream.getCas();
        Type type = cas.getAnnotationType();
        AnnotationFS documentAnnotation = stream.getDocumentAnnotation();
        AnnotationFS before = last;
        AnnotationFS later = next;
        if (!after) {
            before = next;
            later = last;
        }
        int begin = documentAnnotation.getBegin();
        int end = documentAnnotation.getEnd();
        if (before != null) {
            begin = before.getEnd();
        }
        if (later != null) {
            end = later.getBegin();
        }
        AnnotationFS afs = cas.createAnnotation(type, begin, end);
        return afs;
    }

    private void doMatch(AnnotationFS annotation, RuleMatch ruleMatch, ComposedRuleElementMatch containerMatch, boolean ruleAnchor, RutaStream stream, InferenceCrowd crowd) {
        RuleElementMatch result = new RuleElementMatch(this, containerMatch);
        result.setRuleAnchor(ruleAnchor);
        ArrayList<EvaluatedCondition> evaluatedConditions = new ArrayList<EvaluatedCondition>(this.conditions.size());
        boolean base = true;
        ArrayList<AnnotationFS> textsMatched = new ArrayList<AnnotationFS>(1);
        if (base) {
            for (AbstractRutaCondition condition : this.conditions) {
                crowd.beginVisit(condition, null);
                EvaluatedCondition eval = condition.eval(annotation, this, stream, crowd);
                crowd.endVisit(condition, null);
                evaluatedConditions.add(eval);
            }
        }
        if (annotation != null) {
            textsMatched.add(annotation);
        }
        result.setMatchInfo(base, textsMatched, evaluatedConditions);
        ruleMatch.setMatched(ruleMatch.matched() && result.matched());
        ArrayList<RuleElementMatch> rems = new ArrayList<RuleElementMatch>();
        rems.add(result);
        ruleMatch.processMatchInfo(this, rems, stream);
    }

    @Override
    public void continueOwnMatch(boolean after, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RutaRuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
    }

    @Override
    public Collection<AnnotationFS> getAnchors(RutaStream symbolStream) {
        return Collections.emptyList();
    }

    @Override
    public int estimateAnchors(RutaStream stream) {
        return Integer.MAX_VALUE;
    }

    public String toString() {
        return "#" + (this.conditions.isEmpty() ? "" : "(" + this.conditions.toString() + ")" + "\\n") + (this.actions.isEmpty() ? "" : "{" + this.actions.toString() + "}");
    }
}

