/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.verbalize;

import java.util.Iterator;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.bool.BooleanNumberExpression;
import org.apache.uima.ruta.expression.bool.BooleanTypeExpression;
import org.apache.uima.ruta.expression.bool.ReferenceBooleanExpression;
import org.apache.uima.ruta.expression.bool.SimpleBooleanExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.list.ReferenceBooleanListExpression;
import org.apache.uima.ruta.expression.list.ReferenceNumberListExpression;
import org.apache.uima.ruta.expression.list.ReferenceStringListExpression;
import org.apache.uima.ruta.expression.list.ReferenceTypeListExpression;
import org.apache.uima.ruta.expression.list.SimpleBooleanListExpression;
import org.apache.uima.ruta.expression.list.SimpleNumberListExpression;
import org.apache.uima.ruta.expression.list.SimpleStringListExpression;
import org.apache.uima.ruta.expression.list.SimpleTypeListExpression;
import org.apache.uima.ruta.expression.number.ComposedNumberExpression;
import org.apache.uima.ruta.expression.number.NegativeNumberExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.number.ReferenceNumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.expression.resource.ReferenceWordListExpression;
import org.apache.uima.ruta.expression.resource.ReferenceWordTableExpression;
import org.apache.uima.ruta.expression.resource.WordListExpression;
import org.apache.uima.ruta.expression.resource.WordTableExpression;
import org.apache.uima.ruta.expression.string.ComposedStringExpression;
import org.apache.uima.ruta.expression.string.LiteralStringExpression;
import org.apache.uima.ruta.expression.string.ReferenceStringExpression;
import org.apache.uima.ruta.expression.string.SimpleStringExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.ReferenceTypeExpression;
import org.apache.uima.ruta.expression.type.SimpleTypeExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.verbalize.RutaVerbalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionVerbalizer {
    private RutaVerbalizer verbalizer;

    public ExpressionVerbalizer(RutaVerbalizer verbalizer) {
        this.verbalizer = verbalizer;
    }

    public String verbalize(RutaExpression expression) {
        if (expression instanceof TypeExpression) {
            return this.verbalize((TypeExpression)expression);
        }
        if (expression instanceof BooleanExpression) {
            return this.verbalize((BooleanExpression)expression);
        }
        if (expression instanceof NumberExpression) {
            return this.verbalize((NumberExpression)expression);
        }
        if (expression instanceof WordListExpression) {
            return this.verbalize((WordListExpression)expression);
        }
        if (expression instanceof WordTableExpression) {
            return this.verbalize((WordTableExpression)expression);
        }
        if (expression instanceof ListExpression) {
            return this.verbalize((ListExpression)expression);
        }
        if (expression instanceof StringExpression) {
            return this.verbalize((StringExpression)expression);
        }
        return expression.getClass().getSimpleName();
    }

    public String verbalize(WordTableExpression expression) {
        if (expression instanceof ReferenceWordTableExpression) {
            ReferenceWordTableExpression e = (ReferenceWordTableExpression)expression;
            return e.getRef();
        }
        return expression.getClass().getSimpleName();
    }

    public String verbalize(WordListExpression expression) {
        if (expression instanceof ReferenceWordListExpression) {
            ReferenceWordListExpression e = (ReferenceWordListExpression)expression;
            return e.getRef();
        }
        return expression.getClass().getSimpleName();
    }

    public String verbalize(ListExpression<?> expression) {
        if (expression instanceof SimpleBooleanListExpression) {
            SimpleBooleanListExpression e = (SimpleBooleanListExpression)expression;
            return "{" + this.verbalizer.verbalizeExpressionList(e.getList()) + "}";
        }
        if (expression instanceof ReferenceBooleanListExpression) {
            ReferenceBooleanListExpression e = (ReferenceBooleanListExpression)expression;
            return e.getVar();
        }
        if (expression instanceof SimpleNumberListExpression) {
            SimpleNumberListExpression e = (SimpleNumberListExpression)expression;
            return "{" + this.verbalizer.verbalizeExpressionList(e.getList()) + "}";
        }
        if (expression instanceof ReferenceNumberListExpression) {
            ReferenceNumberListExpression e = (ReferenceNumberListExpression)expression;
            return e.getVar();
        }
        if (expression instanceof SimpleStringListExpression) {
            SimpleStringListExpression e = (SimpleStringListExpression)expression;
            return "{" + this.verbalizer.verbalizeExpressionList(e.getList()) + "}";
        }
        if (expression instanceof ReferenceStringListExpression) {
            ReferenceStringListExpression e = (ReferenceStringListExpression)expression;
            return e.getVar();
        }
        if (expression instanceof SimpleTypeListExpression) {
            SimpleTypeListExpression e = (SimpleTypeListExpression)expression;
            return "{" + this.verbalizer.verbalizeExpressionList(e.getList()) + "}";
        }
        if (expression instanceof ReferenceTypeListExpression) {
            ReferenceTypeListExpression e = (ReferenceTypeListExpression)expression;
            return e.getVar();
        }
        return expression.getClass().getSimpleName();
    }

    public String verbalize(NumberExpression expression) {
        if (expression == null) {
            return "";
        }
        if (expression instanceof NegativeNumberExpression) {
            NegativeNumberExpression e = (NegativeNumberExpression)expression;
            return "-(" + e.getExpression() + ")";
        }
        if (expression instanceof ReferenceNumberExpression) {
            ReferenceNumberExpression e = (ReferenceNumberExpression)expression;
            return e.getVar();
        }
        if (expression instanceof SimpleNumberExpression) {
            SimpleNumberExpression e = (SimpleNumberExpression)expression;
            return e.getNumber().toString();
        }
        if (expression instanceof ComposedNumberExpression) {
            ComposedNumberExpression e = (ComposedNumberExpression)expression;
            NumberExpression ne = e.getExpressions().get(0);
            if (ne == null) {
                return "";
            }
            StringBuilder result = new StringBuilder(this.verbalize(ne));
            for (int i = 0; i < e.getOperators().size(); ++i) {
                result.append(" " + e.getOperators().get(i) + " ");
                if (e.getExpressions().size() <= i + 1) continue;
                result.append(this.verbalize(e.getExpressions().get(i + 1)));
            }
            return result.toString();
        }
        return expression.getClass().getSimpleName();
    }

    public String verbalize(BooleanExpression expression) {
        if (expression == null) {
            return "";
        }
        if (expression instanceof BooleanNumberExpression) {
            BooleanNumberExpression e = (BooleanNumberExpression)expression;
            return this.verbalize(e.getFristExpression()) + " " + e.getOperator() + " " + this.verbalize(e.getSecondExpression());
        }
        if (expression instanceof BooleanTypeExpression) {
            BooleanTypeExpression e = (BooleanTypeExpression)expression;
            return this.verbalize(e.getFristExpression()) + " " + e.getOperator() + " " + this.verbalize(e.getSecondExpression());
        }
        if (expression instanceof ReferenceBooleanExpression) {
            ReferenceBooleanExpression e = (ReferenceBooleanExpression)expression;
            return e.getVar();
        }
        if (expression instanceof SimpleBooleanExpression) {
            SimpleBooleanExpression e = (SimpleBooleanExpression)expression;
            return e.getPrimitiveValue() ? "true" : "false";
        }
        return expression.getClass().getSimpleName();
    }

    public String verbalize(StringExpression expression) {
        if (expression == null) {
            return "";
        }
        if (expression instanceof NumberExpression) {
            return this.verbalize((NumberExpression)expression);
        }
        if (expression instanceof TypeExpression) {
            return this.verbalize((TypeExpression)expression);
        }
        if (expression instanceof BooleanExpression) {
            return this.verbalize((BooleanExpression)expression);
        }
        if (expression instanceof ListExpression) {
            return this.verbalize((ListExpression)expression);
        }
        if (expression instanceof LiteralStringExpression) {
            return this.verbalize((LiteralStringExpression)expression);
        }
        return expression.getClass().getSimpleName();
    }

    public String verbalize(LiteralStringExpression expression) {
        if (expression == null) {
            return "";
        }
        if (expression instanceof ComposedStringExpression) {
            ComposedStringExpression e = (ComposedStringExpression)expression;
            StringBuilder sb = new StringBuilder();
            Iterator<StringExpression> it = e.getExpressions().iterator();
            while (it.hasNext()) {
                StringExpression each = it.next();
                sb.append(this.verbalize(each));
                if (!it.hasNext()) continue;
                sb.append(" + ");
            }
            return sb.toString();
        }
        if (expression instanceof ReferenceStringExpression) {
            ReferenceStringExpression e = (ReferenceStringExpression)expression;
            return e.getVar();
        }
        if (expression instanceof SimpleStringExpression) {
            SimpleStringExpression e = (SimpleStringExpression)expression;
            return "\"" + e.getValue() + "\"";
        }
        return expression.getClass().getSimpleName();
    }

    public String verbalize(TypeExpression expression) {
        if (expression instanceof SimpleTypeExpression) {
            SimpleTypeExpression e = (SimpleTypeExpression)expression;
            String type = e.getTypeString();
            int indexOf = type.lastIndexOf(".");
            if (indexOf != -1) {
                type = type.substring(indexOf + 1, type.length());
            }
            if (type.equals("DocumentAnnotation")) {
                type = "Document";
            }
            return type;
        }
        if (expression instanceof ReferenceTypeExpression) {
            ReferenceTypeExpression e = (ReferenceTypeExpression)expression;
            return e.getVar();
        }
        return expression.getClass().getSimpleName();
    }
}

