/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.whisk.generic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.textruler.core.TextRulerAnnotation;
import org.apache.uima.ruta.textruler.core.TextRulerBasicLearner;
import org.apache.uima.ruta.textruler.core.TextRulerExample;
import org.apache.uima.ruta.textruler.core.TextRulerExampleDocument;
import org.apache.uima.ruta.textruler.core.TextRulerRule;
import org.apache.uima.ruta.textruler.core.TextRulerRuleItem;
import org.apache.uima.ruta.textruler.core.TextRulerRuleList;
import org.apache.uima.ruta.textruler.core.TextRulerSlotPattern;
import org.apache.uima.ruta.textruler.core.TextRulerStatisticsCollector;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.extension.TextRulerLearner;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerDelegate;
import org.apache.uima.ruta.textruler.learner.whisk.generic.WhiskRule;
import org.apache.uima.ruta.textruler.learner.whisk.generic.WhiskRuleItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Whisk
extends TextRulerBasicLearner {
    public static final String WINDOWSIZE_KEY = "windowSize";
    public static final String ERROR_THRESHOLD_KEY = "errorThreshold";
    public static final String POSTAG_ROOTTYPE_KEY = "posTagRootType";
    public static final int STANDARD_WINDOWSIZE = 5;
    public static final float STANDARD_ERROR_THRESHOLD = 0.1f;
    public static final String STANDARD_POSTAG_ROOTTYPE = "org.apache.uima.ml.ML.postag";
    TextRulerRuleList ruleList;
    protected Set<TextRulerExample> coveredExamples;
    protected int windowSize = 5;
    protected double errorThreshold = 0.1f;
    protected String posTagRootTypeName = "org.apache.uima.ml.ML.postag";
    int roundNumber = 0;
    int allExamplesCount = 0;
    private Map<String, TextRulerStatisticsCollector> cachedTestedRuleStatistics = new HashMap<String, TextRulerStatisticsCollector>();

    public Whisk(String inputDir, String prePropTmFile, String tmpDir, String[] slotNames, Set<String> filterSet, TextRulerLearnerDelegate delegate) {
        super(inputDir, prePropTmFile, tmpDir, slotNames, filterSet, delegate);
    }

    @Override
    public boolean collectNegativeCoveredInstancesWhenTesting() {
        return false;
    }

    @Override
    protected void doRun() {
        this.cachedTestedRuleStatistics.clear();
        this.ruleList = new TextRulerRuleList();
        this.coveredExamples = new HashSet<TextRulerExample>();
        this.sendStatusUpdateToDelegate("Creating examples...", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
        for (int i = 0; i < this.slotNames.length; ++i) {
            TextRulerTarget target = new TextRulerTarget(this.slotNames[i], (TextRulerBasicLearner)this);
            this.exampleDocuments.createExamplesForTarget(target);
            TextRulerExampleDocument[] docs = this.exampleDocuments.getSortedDocumentsInCacheOptimizedOrder();
            this.allExamplesCount = this.exampleDocuments.getAllPositiveExamples().size();
            for (TextRulerExampleDocument inst : docs) {
                List<TextRulerExample> tags = inst.getPositiveExamples();
                for (TextRulerExample tag : tags) {
                    if (this.coveredExamples.contains(tag)) continue;
                    ++this.roundNumber;
                    WhiskRule newRule = this.growRule(inst, tag);
                    if (this.shouldAbort()) break;
                    if (newRule == null || newRule.getCoveringStatistics().getCoveredNegativesCount() != 0 && !(newRule.getLaplacian() <= this.errorThreshold)) continue;
                    this.ruleList.addRule(newRule);
                    this.coveredExamples.addAll(newRule.getCoveringStatistics().getCoveredPositiveExamples());
                    this.sendStatusUpdateToDelegate("New Rule added...", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
                }
                if (!this.shouldAbort()) continue;
                return;
            }
        }
        this.sendStatusUpdateToDelegate("Done", TextRulerLearner.TextRulerLearnerState.ML_DONE, true);
        this.cachedTestedRuleStatistics.clear();
    }

    protected WhiskRule growRule(TextRulerExampleDocument doc, TextRulerExample example) {
        int i;
        this.sendStatusUpdateToDelegate("Creating new rule from seed...", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
        WhiskRule theRule = new WhiskRule(this, example.getTarget(), example);
        int numberOfSlotsInTag = example.getAnnotations().length;
        for (i = 0; i < numberOfSlotsInTag; ++i) {
            theRule.getPatterns().add(new TextRulerSlotPattern());
        }
        this.sendStatusUpdateToDelegate("Creating new rule: anchoring...", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
        for (i = 0; i < numberOfSlotsInTag; ++i) {
            theRule = this.anchor(theRule, doc, example, i);
            if (!this.shouldAbort()) continue;
            return null;
        }
        this.sendStatusUpdateToDelegate("Creating new rule: extending...", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
        if (theRule != null) {
            WhiskRule extendedRule;
            double oldLaplacian = theRule.getLaplacian();
            int subRoundNumber = 0;
            while (theRule.getCoveringStatistics().getCoveredNegativesCount() > 0 && (extendedRule = this.extendRule(theRule, doc, example, subRoundNumber)) != null) {
                theRule = extendedRule;
                TextRulerToolkit.log("----------------------------");
                TextRulerToolkit.log("BEST EXTENSION IS: " + theRule.getRuleString());
                TextRulerToolkit.log("Laplacian: " + theRule.getLaplacian() + "    ; " + theRule.getCoveringStatistics());
                ++subRoundNumber;
                double newLaplacian = theRule.getLaplacian();
                if (newLaplacian >= oldLaplacian) break;
                oldLaplacian = newLaplacian;
            }
            TextRulerToolkit.log("----------------------------");
            TextRulerToolkit.log("FINAL RULE IS : " + theRule.getRuleString());
        }
        return theRule;
    }

    protected WhiskRule extendRule(WhiskRule rule, TextRulerExampleDocument doc, TextRulerExample example, int subRoundNumber) {
        WhiskRule bestRule = null;
        double bestL = 1.0;
        int bestRuleConstraintPoints = -1;
        if (rule.getLaplacian() <= this.errorThreshold) {
            bestRule = rule;
            bestL = rule.getLaplacian();
        }
        List<List<WhiskRuleItem>> slotTerms = this.getTermsWithinBounds(example.getAnnotations()[0].getBegin(), example.getAnnotations()[0].getEnd(), example);
        List<List<WhiskRuleItem>> windowTerms = this.getTermsWithinWindow(slotTerms, example, 0);
        ArrayList<TextRulerRule> rulesToTest = new ArrayList<TextRulerRule>();
        for (List<WhiskRuleItem> eachList : windowTerms) {
            for (WhiskRuleItem term : eachList) {
                AnnotationFS posTag;
                List<AnnotationFS> posTagAnnotations;
                WhiskRule proposedRule;
                if (rule.containsTerm(term) || (proposedRule = this.createNewRuleByAddingTerm(rule, term)) == null) continue;
                WhiskRuleItem t = term;
                if (!rulesToTest.contains(proposedRule)) {
                    rulesToTest.add(proposedRule);
                }
                WhiskRule proposedRule2 = null;
                WhiskRuleItem t2 = null;
                if (t.getWordConstraint().isRegExpConstraint()) {
                    proposedRule2 = proposedRule.copy();
                    t2 = term;
                    t2.setHideRegExp(true);
                    proposedRule2.setNeedsCompile(true);
                    if (!rulesToTest.contains(proposedRule2)) {
                        rulesToTest.add(proposedRule2);
                    }
                }
                if (this.posTagRootTypeName == null || this.posTagRootTypeName.length() <= 0) continue;
                TextRulerAnnotation tokenAnnotation = term.getWordConstraint().getTokenAnnotation();
                CAS cas = example.getDocumentCAS();
                TypeSystem ts = cas.getTypeSystem();
                Type posTagsRootType = ts.getType(this.posTagRootTypeName);
                if (ts == null || (posTagAnnotations = TextRulerToolkit.getAnnotationsWithinBounds(cas, tokenAnnotation.getBegin(), tokenAnnotation.getEnd(), null, posTagsRootType)).size() <= 0 || (posTag = posTagAnnotations.get(0)).getBegin() != tokenAnnotation.getBegin() || posTag.getEnd() != tokenAnnotation.getEnd()) continue;
                TextRulerAnnotation posTagAnnotation = new TextRulerAnnotation(posTag, doc);
                WhiskRule proposedRule3 = proposedRule.copy();
                WhiskRuleItem t3 = term;
                t3.addOtherConstraint(new WhiskRuleItem.MLWhiskOtherConstraint(tokenAnnotation, posTagAnnotation));
                proposedRule3.setNeedsCompile(true);
                if (!rulesToTest.contains(proposedRule3)) {
                    rulesToTest.add(proposedRule3);
                }
                if (proposedRule2 != null) {
                    WhiskRule proposedRule4 = proposedRule2.copy();
                    WhiskRuleItem t4 = term;
                    t4.addOtherConstraint(new WhiskRuleItem.MLWhiskOtherConstraint(tokenAnnotation, posTagAnnotation));
                    proposedRule4.setNeedsCompile(true);
                    if (!rulesToTest.contains(proposedRule4)) {
                        rulesToTest.add(proposedRule4);
                    }
                }
                WhiskRule proposedRule5 = proposedRule.copy();
                WhiskRuleItem t5 = term;
                t5.addOtherConstraint(new WhiskRuleItem.MLWhiskOtherConstraint(tokenAnnotation, posTagAnnotation));
                t5.setWordConstraint(null);
                proposedRule5.setNeedsCompile(true);
                if (rulesToTest.contains(proposedRule5)) continue;
                rulesToTest.add(proposedRule5);
            }
        }
        if (rulesToTest.size() == 0) {
            return bestRule;
        }
        this.sendStatusUpdateToDelegate("Round " + this.roundNumber + "." + subRoundNumber + " - Testing " + rulesToTest.size() + " rules... " + " - uncovered examples: " + (this.allExamplesCount - this.coveredExamples.size()) + " / " + this.allExamplesCount + " ; cs=" + this.cachedTestedRuleStatistics.size(), TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
        TextRulerToolkit.log("Testing " + rulesToTest.size() + " rules on training set...");
        for (TextRulerRule r : rulesToTest) {
            TextRulerToolkit.log(r.getRuleString());
        }
        this.testRulesIfNotCached(rulesToTest);
        if (this.shouldAbort()) {
            return null;
        }
        for (TextRulerRule r : rulesToTest) {
            WhiskRule wr = (WhiskRule)r;
            if (wr.getLaplacian() < bestL) {
                bestL = wr.getLaplacian();
                bestRule = wr;
                bestRuleConstraintPoints = bestRule.totalConstraintPoints();
                continue;
            }
            if (wr.getLaplacian() != bestL || bestRuleConstraintPoints < 0) continue;
            TextRulerToolkit.log("Same Laplacian! So prefer more general rule!");
            if (wr.totalConstraintPoints() >= bestRuleConstraintPoints) continue;
            TextRulerToolkit.log("\tYes, prefered!");
            bestL = wr.getLaplacian();
            bestRule = wr;
            bestRuleConstraintPoints = bestRule.totalConstraintPoints();
        }
        return bestRule;
    }

    private List<List<WhiskRuleItem>> getTermsWithinWindow(List<List<WhiskRuleItem>> slotTerms, TextRulerExample example, int steps) {
        if (steps == this.windowSize) {
            return slotTerms;
        }
        List<List<WhiskRuleItem>> result = new ArrayList<List<WhiskRuleItem>>();
        for (List<WhiskRuleItem> list : slotTerms) {
            List<WhiskRuleItem> termsBefore = this.getTermsBefore(list.get(0), example);
            List<WhiskRuleItem> termsAfter = this.getTermsAfter(list.get(list.size() - 1), example);
            if (!termsBefore.isEmpty()) {
                for (WhiskRuleItem before : termsBefore) {
                    for (WhiskRuleItem after : termsAfter) {
                        ArrayList<WhiskRuleItem> newList = new ArrayList<WhiskRuleItem>();
                        newList.add(before);
                        newList.addAll(list);
                        newList.add(after);
                        result.add(newList);
                    }
                }
                continue;
            }
            for (WhiskRuleItem after : termsAfter) {
                ArrayList<WhiskRuleItem> newList = new ArrayList<WhiskRuleItem>();
                newList.addAll(list);
                newList.add(after);
                result.add(newList);
            }
        }
        result = this.getTermsWithinWindow(result, example, ++steps);
        return result;
    }

    protected WhiskRule createNewRuleByAddingTerm(WhiskRule baseRule, WhiskRuleItem term) {
        if (term == null) {
            return null;
        }
        if (term.isStarWildCard() || term.getWordConstraint() == null) {
            return null;
        }
        WhiskRule newRule = baseRule.copy();
        int termBeginNumber = term.getWordConstraint().getTokenAnnotation().getBegin();
        int termEndNumber = term.getWordConstraint().getTokenAnnotation().getEnd();
        ArrayList targetPattern = null;
        ArrayList previousSlotPostFillerPattern = null;
        for (int i = 0; i < newRule.getPatterns().size(); ++i) {
            TextRulerSlotPattern slotPattern = newRule.getPatterns().get(i);
            WhiskRuleItem it = (WhiskRuleItem)slotPattern.preFillerPattern.lastItem();
            if (it != null && it.getWordConstraint() != null && termEndNumber <= it.getWordConstraint().getTokenAnnotation().getBegin()) {
                targetPattern = slotPattern.preFillerPattern;
            }
            if (targetPattern == null && slotPattern.fillerPattern.size() > 0) {
                it = (WhiskRuleItem)slotPattern.fillerPattern.firstItem();
                if (it.getWordConstraint() != null && termEndNumber <= it.getWordConstraint().getTokenAnnotation().getBegin()) {
                    targetPattern = slotPattern.preFillerPattern;
                } else {
                    it = (WhiskRuleItem)slotPattern.fillerPattern.lastItem();
                    if (it.getWordConstraint() != null && termEndNumber <= it.getWordConstraint().getTokenAnnotation().getBegin()) {
                        targetPattern = slotPattern.fillerPattern;
                    }
                }
            }
            if (targetPattern == null && slotPattern.postFillerPattern.size() > 0) {
                it = (WhiskRuleItem)slotPattern.postFillerPattern.firstItem();
                if (it.getWordConstraint() != null && termEndNumber <= it.getWordConstraint().getTokenAnnotation().getBegin()) {
                    targetPattern = slotPattern.fillerPattern;
                } else {
                    it = (WhiskRuleItem)slotPattern.postFillerPattern.lastItem();
                    if (it.getWordConstraint() != null && termEndNumber <= it.getWordConstraint().getTokenAnnotation().getBegin()) {
                        targetPattern = slotPattern.postFillerPattern;
                    }
                }
            }
            if (targetPattern == null) {
                targetPattern = previousSlotPostFillerPattern;
            }
            previousSlotPostFillerPattern = slotPattern.postFillerPattern;
        }
        if (targetPattern == null) {
            targetPattern = previousSlotPostFillerPattern;
        }
        if (targetPattern == null) {
            TextRulerToolkit.log("ERROR, NO TARGET PATTERN FOR NEW RULE TERM FOUND !");
        } else {
            boolean isValid;
            WhiskRuleItem right;
            boolean isValid2;
            int indexInPattern = -1;
            if (targetPattern.size() == 0) {
                targetPattern.add(term.copy());
                indexInPattern = 0;
            } else {
                WhiskRuleItem right2;
                WhiskRuleItem left;
                WhiskRuleItem wildCard = null;
                for (TextRulerRuleItem i : newRule.getPatterns().get((int)0).preFillerPattern) {
                    if (!((WhiskRuleItem)i).isStarWildCard()) continue;
                    left = newRule.searchNeighborOfItem((WhiskRuleItem)i, true);
                    right2 = newRule.searchNeighborOfItem((WhiskRuleItem)i, false);
                    if (left.getWordConstraint().getTokenAnnotation().getEnd() > termBeginNumber || right2.getWordConstraint().getTokenAnnotation().getBegin() < termEndNumber) continue;
                    wildCard = (WhiskRuleItem)i;
                }
                if (wildCard == null) {
                    for (TextRulerRuleItem i : newRule.getPatterns().get((int)0).fillerPattern) {
                        if (!((WhiskRuleItem)i).isStarWildCard()) continue;
                        left = newRule.searchNeighborOfItem((WhiskRuleItem)i, true);
                        right2 = newRule.searchNeighborOfItem((WhiskRuleItem)i, false);
                        if (left == null || left.getWordConstraint().getTokenAnnotation().getEnd() > termBeginNumber || right2.getWordConstraint().getTokenAnnotation().getBegin() < termEndNumber) continue;
                        wildCard = (WhiskRuleItem)i;
                    }
                }
                if (wildCard == null) {
                    for (TextRulerRuleItem i : newRule.getPatterns().get((int)0).postFillerPattern) {
                        if (!((WhiskRuleItem)i).isStarWildCard()) continue;
                        left = newRule.searchNeighborOfItem((WhiskRuleItem)i, true);
                        right2 = newRule.searchNeighborOfItem((WhiskRuleItem)i, false);
                        if (left.getWordConstraint().getTokenAnnotation().getEnd() > termBeginNumber || right2.getWordConstraint().getTokenAnnotation().getBegin() < termEndNumber) continue;
                        wildCard = (WhiskRuleItem)i;
                    }
                }
                if (wildCard != null) {
                    if (!wildCard.isStarWildCard()) {
                        TextRulerToolkit.log("ERROR, FOUND A TERM WITH THE SAME NUMBER THAT IS NOT A WILDCARD! HOW IS THAT???");
                        return null;
                    }
                    if (!targetPattern.contains(wildCard)) {
                        TextRulerToolkit.log("EVEN WORSE, THAT MUST NOT BE AT ALL!");
                        return null;
                    }
                    indexInPattern = targetPattern.indexOf(wildCard);
                    targetPattern.set(indexInPattern, term.copy());
                } else {
                    for (int i = 0; i < targetPattern.size(); ++i) {
                        WhiskRuleItem it = (WhiskRuleItem)targetPattern.get(i);
                        if (it.getWordConstraint() == null || termEndNumber > it.getWordConstraint().getTokenAnnotation().getBegin()) continue;
                        indexInPattern = i;
                        break;
                    }
                    if (indexInPattern < 0) {
                        indexInPattern = targetPattern.size();
                        targetPattern.add(term.copy());
                    } else {
                        targetPattern.add(indexInPattern, term.copy());
                    }
                }
            }
            WhiskRuleItem newTerm = (WhiskRuleItem)targetPattern.get(indexInPattern);
            WhiskRuleItem left = newRule.searchNeighborOfItem(newTerm, true);
            if (left != null && left.getWordConstraint() != null && !left.isStarWildCard() && !(isValid2 = this.isNextValidNeighbor(left, newTerm, newRule.getSeedExample()))) {
                targetPattern.add(indexInPattern, WhiskRuleItem.newWildCardItem(this.getElementIndex(newRule, left) + 1));
                ++indexInPattern;
            }
            if ((right = newRule.searchNeighborOfItem(newTerm, false)) != null && right.getWordConstraint() != null && !right.isStarWildCard() && !(isValid = this.isNextValidNeighbor(newTerm, right, newRule.getSeedExample()))) {
                WhiskRuleItem wc = WhiskRuleItem.newWildCardItem(this.getElementIndex(newRule, newTerm) + 1);
                if (indexInPattern + 1 < targetPattern.size()) {
                    targetPattern.add(indexInPattern + 1, wc);
                } else {
                    targetPattern.add(wc);
                }
            }
            newRule.setNeedsCompile(true);
        }
        if (newRule.getRuleString().equals(baseRule.getRuleString())) {
            return null;
        }
        return newRule;
    }

    protected WhiskRule anchor(WhiskRule rule, TextRulerExampleDocument doc, TextRulerExample example, int slotIndex) {
        ArrayList<WhiskRule> result = new ArrayList<WhiskRule>();
        TextRulerAnnotation slotAnnotation = example.getAnnotations()[slotIndex];
        List<List<WhiskRuleItem>> window = this.getTermsWithinBounds(slotAnnotation.getBegin(), slotAnnotation.getEnd(), example);
        for (List<WhiskRuleItem> inside : window) {
            TextRulerSlotPattern textRulerSlotPattern;
            WhiskRule copy;
            if (rule == null || inside.isEmpty()) {
                return null;
            }
            WhiskRule base1 = rule.copy();
            TextRulerSlotPattern slotPattern = base1.getPatterns().get(slotIndex);
            for (int i = 0; i < inside.size(); ++i) {
                if (i == 0 || i == inside.size() - 1) {
                    slotPattern.fillerPattern.add(inside.get(i).copy());
                    continue;
                }
                if (inside.size() <= 2 || i >= 2) continue;
                slotPattern.fillerPattern.add(WhiskRuleItem.newWildCardItem(this.getElementIndex(base1, inside.get(i))));
            }
            List<WhiskRuleItem> beforeList = this.getTermsBefore(inside.get(0), example);
            List<WhiskRuleItem> afterList = this.getTermsAfter(inside.get(inside.size() - 1), example);
            HashSet<WhiskRule> tempRules = new HashSet<WhiskRule>();
            if (!beforeList.isEmpty()) {
                if (!afterList.isEmpty()) {
                    for (WhiskRuleItem eachBefore : beforeList) {
                        for (WhiskRuleItem eachAfter : afterList) {
                            WhiskRule copy2 = rule.copy();
                            TextRulerSlotPattern textRulerSlotPattern2 = copy2.getPatterns().get(slotIndex);
                            textRulerSlotPattern2.preFillerPattern.add(eachBefore);
                            textRulerSlotPattern2.fillerPattern.add(WhiskRuleItem.newWildCardItem(this.getElementIndex(copy2, inside.get(0))));
                            textRulerSlotPattern2.postFillerPattern.add(eachAfter);
                            tempRules.add(copy2);
                        }
                    }
                } else {
                    for (WhiskRuleItem eachBefore : beforeList) {
                        copy = rule.copy();
                        textRulerSlotPattern = copy.getPatterns().get(slotIndex);
                        textRulerSlotPattern.fillerPattern.add(WhiskRuleItem.newWildCardItem(this.getElementIndex(copy, inside.get(0))));
                        textRulerSlotPattern.preFillerPattern.add(eachBefore);
                        tempRules.add(copy);
                    }
                }
            } else {
                for (WhiskRuleItem eachAfter : afterList) {
                    copy = rule.copy();
                    textRulerSlotPattern = copy.getPatterns().get(slotIndex);
                    textRulerSlotPattern.fillerPattern.add(WhiskRuleItem.newWildCardItem(this.getElementIndex(copy, inside.get(0))));
                    textRulerSlotPattern.postFillerPattern.add(eachAfter);
                    tempRules.add(copy);
                }
            }
            ArrayList<TextRulerRule> rules = new ArrayList<TextRulerRule>(tempRules);
            this.testRulesIfNotCached(rules);
            TextRulerRule best = null;
            for (TextRulerRule each : rules) {
                if (best == null) {
                    best = each;
                    continue;
                }
                if (each.getCoveringStatistics().getCoveredPositivesCount() <= best.getCoveringStatistics().getCoveredPositivesCount()) continue;
                best = each;
            }
            WhiskRule base2 = (WhiskRule)best;
            TextRulerToolkit.log("base1: " + base1.getRuleString());
            TextRulerToolkit.log("base2: " + base2.getRuleString());
            ArrayList<TextRulerRule> testRules = new ArrayList<TextRulerRule>();
            testRules.add(base1);
            testRules.add(base2);
            this.testRulesIfNotCached(testRules);
            if (this.shouldAbort()) {
                return null;
            }
            TextRulerToolkit.log("\tbase1: " + base1.getCoveringStatistics() + " --> laplacian = " + base1.getLaplacian());
            TextRulerToolkit.log("\tbase2: " + base2.getCoveringStatistics() + " --> laplacian = " + base2.getLaplacian());
            if (base2.getCoveringStatistics().getCoveredPositivesCount() > base1.getCoveringStatistics().getCoveredPositivesCount()) {
                result.add(base2);
                continue;
            }
            result.add(base1);
        }
        WhiskRule best = null;
        for (WhiskRule each : result) {
            if (best == null) {
                best = each;
                continue;
            }
            if (each.getCoveringStatistics().getCoveredPositivesCount() <= best.getCoveringStatistics().getCoveredPositivesCount()) continue;
            best = each;
        }
        return best;
    }

    private List<WhiskRuleItem> getTermsAfter(WhiskRuleItem whiskRuleItem, TextRulerExample example) {
        ArrayList<WhiskRuleItem> result = new ArrayList<WhiskRuleItem>();
        int end = whiskRuleItem.getWordConstraint().getTokenAnnotation().getEnd();
        CAS cas = example.getDocumentCAS();
        Type frameType = cas.getTypeSystem().getType("org.apache.uima.ruta.type.RutaFrame");
        AnnotationFS pointer = cas.createAnnotation(frameType, end, Integer.MAX_VALUE);
        FSIterator iterator = cas.getAnnotationIndex().iterator((FeatureStructure)pointer);
        int nextBegin = -1;
        while (iterator.isValid()) {
            AnnotationFS a;
            FeatureStructure fs = iterator.get();
            if (fs instanceof AnnotationFS && !this.filterSetWithSlotNames.contains((a = (AnnotationFS)fs).getType().getName())) {
                if (nextBegin == -1) {
                    nextBegin = a.getBegin();
                }
                if (a.getBegin() <= nextBegin && a.getBegin() >= end) {
                    WhiskRuleItem term = new WhiskRuleItem(new TextRulerAnnotation(a, example.getDocument()));
                    result.add(term);
                }
            }
            iterator.moveToNext();
        }
        return result;
    }

    private List<WhiskRuleItem> getTermsBefore(WhiskRuleItem whiskRuleItem, TextRulerExample example) {
        ArrayList<WhiskRuleItem> result = new ArrayList<WhiskRuleItem>();
        int begin = whiskRuleItem.getWordConstraint().getTokenAnnotation().getBegin();
        CAS cas = example.getDocumentCAS();
        Type frameType = cas.getTypeSystem().getType("org.apache.uima.ruta.type.RutaFrame");
        AnnotationFS pointer = cas.createAnnotation(frameType, begin, begin);
        FSIterator iterator = cas.getAnnotationIndex().iterator((FeatureStructure)pointer);
        int nextEnd = -1;
        iterator.moveToPrevious();
        iterator.moveToPrevious();
        while (iterator.isValid()) {
            AnnotationFS a;
            FeatureStructure fs = iterator.get();
            if (fs instanceof AnnotationFS && !this.filterSetWithSlotNames.contains((a = (AnnotationFS)fs).getType().getName())) {
                if (a.getEnd() > example.getAnnotation().getEnd()) {
                    iterator.moveToPrevious();
                    continue;
                }
                if (nextEnd == -1) {
                    nextEnd = a.getEnd();
                }
                if (a.getEnd() >= nextEnd && a.getEnd() <= begin) {
                    WhiskRuleItem term = new WhiskRuleItem(new TextRulerAnnotation(a, example.getDocument()));
                    result.add(term);
                }
            }
            iterator.moveToPrevious();
        }
        return result;
    }

    @Override
    public String getResultString() {
        if (this.ruleList != null) {
            return this.getTMFileHeaderString() + this.ruleList.getRulesString("");
        }
        return "No results available yet!";
    }

    @Override
    public void setParameters(Map<String, Object> params) {
        if (params.containsKey(WINDOWSIZE_KEY)) {
            this.windowSize = (Integer)params.get(WINDOWSIZE_KEY);
        }
        if (params.containsKey(ERROR_THRESHOLD_KEY)) {
            this.errorThreshold = ((Float)params.get(ERROR_THRESHOLD_KEY)).floatValue();
        }
        if (params.containsKey(POSTAG_ROOTTYPE_KEY)) {
            this.posTagRootTypeName = (String)params.get(POSTAG_ROOTTYPE_KEY);
        }
    }

    public List<List<WhiskRuleItem>> getTermsWithinBounds(int startPos, int endPos, TextRulerExample example) {
        List<List<WhiskRuleItem>> result = new ArrayList<List<WhiskRuleItem>>();
        CAS cas = example.getDocumentCAS();
        Type frameType = cas.getTypeSystem().getType("org.apache.uima.ruta.type.RutaFrame");
        AnnotationFS pointer = cas.createAnnotation(frameType, startPos, endPos);
        FSIterator iterator = cas.getAnnotationIndex().iterator((FeatureStructure)pointer);
        ArrayList<AnnotationFS> startAs = new ArrayList<AnnotationFS>();
        int firstBegin = -1;
        while (iterator.isValid()) {
            FeatureStructure fs = iterator.get();
            AnnotationFS a = (AnnotationFS)fs;
            if (a.getBegin() >= startPos && a.getEnd() <= endPos) {
                if (!this.filterSetWithSlotNames.contains(a.getType().getName())) {
                    if (firstBegin == -1) {
                        firstBegin = a.getBegin();
                    }
                    if (a.getBegin() == firstBegin) {
                        startAs.add(a);
                    }
                }
                iterator.moveToNext();
                continue;
            }
            iterator.moveToNext();
        }
        for (AnnotationFS annotation : startAs) {
            ArrayList<WhiskRuleItem> startList = new ArrayList<WhiskRuleItem>();
            WhiskRuleItem term = new WhiskRuleItem(new TextRulerAnnotation(annotation, example.getDocument()));
            startList.add(term);
            result.add(startList);
        }
        result = this.addFollowing(result, endPos, example);
        return result;
    }

    private List<List<WhiskRuleItem>> addFollowing(List<List<WhiskRuleItem>> lists, int till, TextRulerExample example) {
        List<List<WhiskRuleItem>> result = new ArrayList<List<WhiskRuleItem>>();
        for (List<WhiskRuleItem> list : lists) {
            WhiskRuleItem last = list.get(list.size() - 1);
            List<WhiskRuleItem> termsAfter = this.getTermsAfter(last, example);
            if (termsAfter.isEmpty()) {
                return lists;
            }
            for (WhiskRuleItem eachAfter : termsAfter) {
                if (eachAfter.getWordConstraint().getTokenAnnotation().getEnd() <= till) {
                    ArrayList<WhiskRuleItem> newList = new ArrayList<WhiskRuleItem>();
                    newList.addAll(list);
                    newList.add(eachAfter);
                    result.add(newList);
                    result = this.addFollowing(result, till, example);
                    continue;
                }
                return lists;
            }
        }
        return result;
    }

    protected void testRulesIfNotCached(List<TextRulerRule> rules) {
        String key;
        ArrayList<TextRulerRule> rulesToTest = new ArrayList<TextRulerRule>();
        for (TextRulerRule r : rules) {
            key = r.getRuleString();
            if (this.cachedTestedRuleStatistics.containsKey(key)) {
                r.setCoveringStatistics(this.cachedTestedRuleStatistics.get(key).copy());
                TextRulerToolkit.log("CACHE HIT !");
                continue;
            }
            rulesToTest.add(r);
        }
        if (rulesToTest.size() > 0) {
            this.testRulesOnDocumentSet(rulesToTest, this.exampleDocuments);
            if (this.shouldAbort()) {
                return;
            }
            for (TextRulerRule r : rulesToTest) {
                key = r.getRuleString();
                this.cachedTestedRuleStatistics.put(key, r.getCoveringStatistics().copy());
            }
        }
    }

    private int getElementIndex(WhiskRule proposedRule, WhiskRuleItem term) {
        if (term == null) {
            return -1;
        }
        int index = 0;
        int result = -1;
        for (TextRulerRuleItem i : proposedRule.getPatterns().get((int)0).preFillerPattern) {
            if (((WhiskRuleItem)i).equals(term)) {
                result = index;
            }
            ++index;
        }
        for (TextRulerRuleItem i : proposedRule.getPatterns().get((int)0).fillerPattern) {
            if (((WhiskRuleItem)i).equals(term)) {
                result = index;
            }
            ++index;
        }
        for (TextRulerRuleItem i : proposedRule.getPatterns().get((int)0).postFillerPattern) {
            if (((WhiskRuleItem)i).equals(term)) {
                result = index;
            }
            ++index;
        }
        return result;
    }

    private boolean isNextValidNeighbor(WhiskRuleItem left, WhiskRuleItem right, TextRulerExample example) {
        CAS cas = example.getDocumentCAS();
        Type frameType = cas.getTypeSystem().getType("org.apache.uima.ruta.type.RutaFrame");
        int begin = left.getWordConstraint().getTokenAnnotation().getEnd();
        int end = right.getWordConstraint().getTokenAnnotation().getBegin();
        AnnotationFS pointer = cas.createAnnotation(frameType, begin, end);
        FSIterator iterator = cas.getAnnotationIndex().iterator((FeatureStructure)pointer);
        while (iterator.isValid()) {
            FeatureStructure fs = iterator.get();
            AnnotationFS a = (AnnotationFS)fs;
            if (a.getBegin() >= begin && a.getEnd() <= end && !this.filterSetWithSlotNames.contains(a.getType().getName())) {
                return false;
            }
            iterator.moveToNext();
        }
        return true;
    }
}

