/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.extension;

import java.util.Map;
import java.util.Set;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.extension.TextRulerController;
import org.apache.uima.ruta.textruler.extension.TextRulerControllerDelegate;
import org.apache.uima.ruta.textruler.extension.TextRulerLearner;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerDelegate;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextRulerLearnerController
implements TextRulerLearnerDelegate {
    protected String name;
    protected TextRulerLearnerFactory algoritmFactory;
    protected String id;
    protected boolean enabled;
    protected TextRulerLearner algorithm;
    protected Thread thread;
    protected TextRulerControllerDelegate delegate;
    protected String currentStatusString;
    protected TextRulerLearner.TextRulerLearnerState algorithmState = TextRulerLearner.TextRulerLearnerState.ML_UNDEFINED;
    protected String resultString;

    public TextRulerLearnerController(String id, String name, TextRulerLearnerFactory factory) {
        this.id = id;
        this.name = name;
        this.algoritmFactory = factory;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        if (this.currentStatusString != null) {
            return this.getName() + " - " + this.currentStatusString;
        }
        return this.getName();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public boolean isRunning() {
        return this.thread != null;
    }

    private void sendUpdateToDelegate(boolean ruleBaseChanged) {
        if (this.delegate != null) {
            this.delegate.algorithmStatusUpdate(this, this.currentStatusString, this.algorithmState, ruleBaseChanged);
        }
    }

    @Override
    public boolean shouldAbort() {
        return TextRulerController.shouldAbort();
    }

    @Override
    public void algorithmStatusUpdate(TextRulerLearner alg, String statusString, TextRulerLearner.TextRulerLearnerState state, boolean ruleBaseChanged) {
        this.resultString = alg.getResultString();
        this.algorithmState = state;
        this.currentStatusString = statusString;
        this.sendUpdateToDelegate(ruleBaseChanged);
    }

    public String getCurrentResultString() {
        if (this.algorithm != null) {
            this.resultString = this.algorithm.getResultString();
        }
        return this.resultString;
    }

    private void algorithmDidEnd() {
        this.thread = null;
        if (this.delegate != null) {
            this.delegate.algorithmDidEnd(this);
        }
        this.delegate = null;
        this.algorithm = null;
        TextRulerController.anAlgorithmDidEnd(this);
    }

    public boolean runInNewThread(final String inputFolderPath, final String additionalFolderPath, final String preprocessorTMfile, final String[] slotNames, final Set<String> filters, final String tempBaseDirectory, TextRulerControllerDelegate delegate, final boolean skip, final Map<String, Object> algorithmParams) {
        if (this.thread == null) {
            final TextRulerLearnerController algDelegate = this;
            this.delegate = delegate;
            this.thread = new Thread(new Runnable(){

                public void run() {
                    String tmpDir = TextRulerToolkit.addTrailingSlashToPath(tempBaseDirectory + TextRulerLearnerController.this.getID());
                    TextRulerLearnerController.this.algorithm = TextRulerLearnerController.this.algoritmFactory.createAlgorithm(inputFolderPath, additionalFolderPath, preprocessorTMfile, tmpDir, slotNames, filters, skip, algDelegate);
                    TextRulerLearnerController.this.algorithm.setParameters(algorithmParams);
                    TextRulerLearnerController.this.algorithm.run();
                    TextRulerLearnerController.this.algorithmDidEnd();
                    System.gc();
                }
            });
            this.thread.setPriority(5);
            this.thread.start();
            return true;
        }
        return false;
    }

    public void resetStatusString() {
        this.currentStatusString = null;
    }

    public TextRulerLearnerFactory getFactory() {
        return this.algoritmFactory;
    }
}

