/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.lp2;

import org.apache.uima.ruta.textruler.core.TextRulerBasicLearner;
import org.apache.uima.ruta.textruler.core.TextRulerRuleItem;
import org.apache.uima.ruta.textruler.core.TextRulerSingleSlotRule;
import org.apache.uima.ruta.textruler.core.TextRulerStatisticsCollector;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.learner.lp2.LP2RuleItem;

public class LP2Rule
extends TextRulerSingleSlotRule {
    protected float errorRate;
    protected boolean setIsPreFillerStartRule = false;
    protected boolean isContextualRule = false;

    public LP2Rule(TextRulerBasicLearner parentAlgorithm, TextRulerTarget target) {
        super(parentAlgorithm, target);
    }

    protected LP2Rule(LP2Rule copyFrom) {
        super(copyFrom);
        this.errorRate = copyFrom.errorRate;
        this.setIsPreFillerStartRule = copyFrom.setIsPreFillerStartRule;
        this.isContextualRule = copyFrom.isContextualRule;
    }

    public LP2Rule copy() {
        return new LP2Rule(this);
    }

    public void setCoveringStatistics(TextRulerStatisticsCollector c) {
        super.setCoveringStatistics(c);
        int p = c.getCoveredPositivesCount();
        int n = c.getCoveredNegativesCount();
        if (p < 1) {
            TextRulerToolkit.log("ERROR, A RULE MAY NOT COVER ZERO POSITIVE EXAMPLES! WHAT'S WRONG ?");
            TextRulerToolkit.log("\tRULE: " + this.getRuleString());
            this.errorRate = Float.MAX_VALUE;
        } else {
            this.errorRate = (float)n / (float)p;
        }
    }

    public float getErrorRate() {
        return this.errorRate;
    }

    public int totalConstraintCount() {
        int result = 0;
        for (TextRulerRuleItem i : this.slotPattern.preFillerPattern) {
            result += 1 + ((LP2RuleItem)i).totalConstraintCount();
        }
        for (TextRulerRuleItem i : this.slotPattern.postFillerPattern) {
            result += 1 + ((LP2RuleItem)i).totalConstraintCount();
        }
        return result;
    }

    public int totalInnerConstraintCount() {
        int result = 0;
        for (TextRulerRuleItem i : this.slotPattern.preFillerPattern) {
            result += ((LP2RuleItem)i).totalConstraintCount();
        }
        for (TextRulerRuleItem i : this.slotPattern.postFillerPattern) {
            result += ((LP2RuleItem)i).totalConstraintCount();
        }
        return result;
    }

    public boolean isPreFillerStartRule() {
        return this.setIsPreFillerStartRule;
    }

    public void setIsPreFillerStartRule(boolean flag) {
        this.setIsPreFillerStartRule = flag;
    }

    public LP2RuleItem getMarkingRuleItem() {
        if (this.target.type == TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY) {
            return (LP2RuleItem)this.slotPattern.postFillerPattern.get(0);
        }
        return (LP2RuleItem)this.slotPattern.preFillerPattern.get(this.slotPattern.preFillerPattern.size() - 1);
    }

    public boolean isContextualRule() {
        return this.isContextualRule;
    }

    public void setIsContextualRule(boolean flag) {
        if (flag != this.isContextualRule) {
            this.isContextualRule = flag;
            this.setNeedsCompile(true);
        }
    }
}

