/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TypeSentiveCondition;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationListExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.bool.IBooleanListExpression;
import org.apache.uima.ruta.expression.bool.SimpleBooleanExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.number.INumberListExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.string.IStringListExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.expression.type.ITypeListExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ContainsCondition
extends TypeSentiveCondition {
    private final INumberExpression min;
    private final INumberExpression max;
    private final IBooleanExpression percent;
    private IRutaExpression arg;
    private ListExpression argList;

    public ContainsCondition(ITypeExpression type, INumberExpression min, INumberExpression max, IBooleanExpression percent) {
        super(type);
        this.min = min == null ? new SimpleNumberExpression(1) : min;
        this.max = max == null ? new SimpleNumberExpression(Integer.MAX_VALUE) : max;
        this.percent = percent == null ? new SimpleBooleanExpression(false) : percent;
    }

    public ContainsCondition(ListExpression list, IRutaExpression a, INumberExpression min, INumberExpression max, IBooleanExpression percent) {
        super((ITypeExpression)null);
        this.min = min == null ? new SimpleNumberExpression(1) : min;
        this.max = max == null ? new SimpleNumberExpression(Integer.MAX_VALUE) : max;
        this.percent = percent == null ? new SimpleBooleanExpression(false) : percent;
        this.argList = list;
        this.arg = a;
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        boolean usePredefinedBoundaries;
        AnnotationFS annotation = context.getAnnotation();
        boolean usePercentage = this.percent.getBooleanValue(context, stream);
        int minIntValue = this.min.getIntegerValue(context, stream);
        int maxIntValue = this.max.getIntegerValue(context, stream);
        int basicCount = 0;
        int anchorCount = 0;
        int totalCount = 0;
        boolean bl = usePredefinedBoundaries = minIntValue != 1 || maxIntValue != Integer.MAX_VALUE;
        if (this.type != null) {
            Type t = this.type.getType(context, stream);
            if (annotation != null && t != null) {
                if (!usePredefinedBoundaries && !usePercentage) {
                    boolean annotationExsits = this.checkExistingAnnotation(t, annotation, stream);
                    return new EvaluatedCondition(this, annotationExsits);
                }
                List<RutaBasic> annotations = stream.getBasicsInWindow(annotation);
                for (RutaBasic each : annotations) {
                    ++totalCount;
                    if (each.beginsWith(t) || stream.getCas().getTypeSystem().subsumes(t, each.getType())) {
                        Collection beginAnchors = each.getBeginAnchors(t);
                        anchorCount = this.incrementAnchorsWithinStrictBoundaries(annotation, anchorCount, beginAnchors);
                        ++basicCount;
                        continue;
                    }
                    if (!each.isPartOf(t)) continue;
                    ++basicCount;
                }
            }
        } else {
            IStringExpression e;
            List list = this.argList.getList(context, stream);
            totalCount = list.size();
            Object sniff = null;
            if (totalCount > 0) {
                sniff = list.get(0);
            }
            if (this.check(sniff, Boolean.class) && this.arg instanceof IBooleanExpression && this.argList instanceof IBooleanListExpression) {
                e = (IBooleanExpression)this.arg;
                IBooleanListExpression le = (IBooleanListExpression)((Object)this.argList);
                boolean v = e.getBooleanValue(context, stream);
                ArrayList<Boolean> l = new ArrayList<Boolean>(le.getBooleanList(context, stream));
                while (l.remove(v)) {
                    ++basicCount;
                }
            } else if (this.check(sniff, Number.class) && this.arg instanceof INumberExpression && this.argList instanceof INumberListExpression) {
                e = (INumberExpression)this.arg;
                INumberListExpression le = (INumberListExpression)((Object)this.argList);
                Double v = e.getDoubleValue(context, stream);
                ArrayList<Number> l = new ArrayList<Number>(le.getNumberList(context, stream));
                while (l.remove(v)) {
                    ++basicCount;
                }
            } else if (this.check(sniff, String.class) && this.arg instanceof IStringExpression && this.argList instanceof IStringListExpression) {
                e = (IStringExpression)this.arg;
                IStringListExpression le = (IStringListExpression)((Object)this.argList);
                String v = e.getStringValue(context, stream);
                ArrayList<String> l = new ArrayList<String>(le.getStringList(context, stream));
                while (l.remove(v)) {
                    ++basicCount;
                }
            } else if (this.check(sniff, Type.class) && this.arg instanceof ITypeExpression && this.argList instanceof ITypeListExpression) {
                e = (ITypeExpression)this.arg;
                ITypeListExpression le = (ITypeListExpression)((Object)this.argList);
                Type v = e.getType(context, stream);
                ArrayList<Type> l = new ArrayList<Type>(le.getTypeList(context, stream));
                while (l.remove(v)) {
                    ++basicCount;
                }
            } else if (this.check(sniff, AnnotationFS.class) && this.arg instanceof IAnnotationExpression && this.argList instanceof IAnnotationListExpression) {
                e = (IAnnotationExpression)this.arg;
                IAnnotationListExpression le = (IAnnotationListExpression)((Object)this.argList);
                AnnotationFS v = e.getAnnotation(context, stream);
                ArrayList<AnnotationFS> l = new ArrayList<AnnotationFS>(le.getAnnotationList(context, stream));
                while (l.remove(v)) {
                    ++basicCount;
                }
            }
            anchorCount = basicCount;
        }
        if (usePercentage) {
            double percentValue = 0.0;
            if (totalCount != 0) {
                percentValue = (double)basicCount / (double)totalCount * 100.0;
            }
            boolean value = percentValue >= this.min.getDoubleValue(context, stream) && percentValue <= this.max.getDoubleValue(context, stream);
            return new EvaluatedCondition(this, value);
        }
        boolean value = anchorCount >= minIntValue && anchorCount <= maxIntValue;
        return new EvaluatedCondition(this, value);
    }

    private int incrementAnchorsWithinStrictBoundaries(AnnotationFS annotation, int anchorCount, Collection<AnnotationFS> beginAnchors) {
        for (AnnotationFS eachBegin : beginAnchors) {
            if (eachBegin.getEnd() > annotation.getEnd()) continue;
            ++anchorCount;
        }
        return anchorCount;
    }

    private boolean checkExistingAnnotation(Type type, AnnotationFS annotation, RutaStream stream) {
        int begin = annotation.getBegin();
        int end = annotation.getEnd();
        FSIterator it = stream.getCas().getAnnotationIndex(type).iterator();
        it.moveTo((FeatureStructure)annotation);
        if (!it.isValid()) {
            it.moveToLast();
            if (!it.isValid()) {
                return false;
            }
        }
        boolean moved = false;
        while (it.isValid() && ((AnnotationFS)it.get()).getBegin() >= begin) {
            it.moveToPrevious();
            moved = true;
        }
        if (moved) {
            it.moveToNext();
        }
        if (!it.isValid()) {
            it.moveToFirst();
        }
        while (it.isValid() && ((AnnotationFS)it.get()).getBegin() < begin) {
            it.moveToNext();
        }
        while (it.isValid()) {
            AnnotationFS a = (AnnotationFS)it.get();
            if (a.getBegin() > end) {
                return false;
            }
            it.moveToNext();
            if (a.getEnd() > end || !stream.isVisible(a)) continue;
            return true;
        }
        return false;
    }

    private boolean check(Object sniff, Class<?> clazz) {
        if (sniff == null) {
            return true;
        }
        return clazz.isAssignableFrom(sniff.getClass());
    }

    public INumberExpression getMin() {
        return this.min;
    }

    public INumberExpression getMax() {
        return this.max;
    }

    public IBooleanExpression getPercent() {
        return this.percent;
    }

    public IRutaExpression getArg() {
        return this.arg;
    }

    public ListExpression getArgList() {
        return this.argList;
    }
}

